/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.LongBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public abstract class LongBuffer
extends Buffer
implements Comparable {
    protected long[] backing_buffer;
    protected int array_offset = 0;

    public static LongBuffer allocateDirect(int capacity) {
        throw new Error("direct buffers not implemented");
    }

    public static LongBuffer allocate(int capacity) {
        return new LongBufferImpl(capacity, 0, capacity);
    }

    public static final LongBuffer wrap(long[] array, int offset, int length) {
        return new LongBufferImpl(array, offset, length);
    }

    public static final LongBuffer wrap(String a) {
        int len = a.length();
        long[] buffer = new long[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = a.charAt(i);
        }
        return LongBuffer.wrap(buffer, 0, len);
    }

    public static final LongBuffer wrap(long[] array) {
        return LongBuffer.wrap(array, 0, array.length);
    }

    LongBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
    }

    public LongBuffer get(long[] dst, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public LongBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public LongBuffer put(LongBuffer src) {
        while (src.hasRemaining()) {
            this.put(src.get());
        }
        return this;
    }

    public LongBuffer put(long[] src, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final LongBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && this.isReadOnly() ^ true;
    }

    public final long[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongBuffer) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int compareTo(Object ob) {
        LongBuffer a = (LongBuffer)ob;
        if (a.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !a.hasArray()) {
            return 1;
        }
        int r = this.remaining();
        int i1 = this.position();
        int i2 = a.position();
        for (int i = 0; i < r; ++i) {
            int t = (int)this.get(i1) - (int)a.get(i2);
            if (t == 0) continue;
            return t;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract long get();

    public abstract LongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract LongBuffer put(int var1, long var2);

    public abstract LongBuffer compact();

    public abstract boolean isDirect();

    public abstract LongBuffer slice();

    public abstract LongBuffer duplicate();

    public abstract LongBuffer asReadOnlyBuffer();
}

