/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public abstract class JTextComponent
extends JComponent
implements Scrollable,
Accessible {
    int icon_gap;
    Icon icon;
    int align;
    Document doc;

    public JTextComponent() {
        this("", null, 0);
    }

    public JTextComponent(Icon image) {
        this("", image, 0);
    }

    public JTextComponent(Icon image, int horizontalAlignment) {
        this("", image, horizontalAlignment);
    }

    public JTextComponent(String text) {
        this(text, null, 0);
    }

    public JTextComponent(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public JTextComponent(String text, Icon icon, int horizontalAlignment) {
        this.setDocument(new PlainDocument());
        this.setText(text);
        this.icon = icon;
        this.align = horizontalAlignment;
        this.enableEvents(8);
        this.updateUI();
    }

    public void setDocument(Document s) {
        this.doc = s;
        this.revalidate();
        this.repaint();
    }

    public Document getDocument() {
        if (this.doc == null) {
            System.out.println("doc == null !!!");
        }
        return this.doc;
    }

    protected int checkHorizontalKey(int key, String message) {
        return 0;
    }

    protected int checkVerticalKey(int key, String message) {
        return 0;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public Icon getDisabledIcon() {
        return null;
    }

    public int getDisplayedMnemonic() {
        return 0;
    }

    public int getHorizontalAlignment() {
        return 0;
    }

    public int getHorizontalTextPosition() {
        return 0;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getIconTextGap() {
        return this.icon_gap;
    }

    Component getLabelFor() {
        return null;
    }

    public void setText(String text) {
        this.getDocument().remove(0, this.doc.getLength());
        this.getDocument().insertString(0, text, null);
    }

    public String getText() {
        return this.getDocument().getText(0, this.getDocument().getLength());
    }

    public String getUIClassID() {
        return "JTextComponent";
    }

    public int getVerticalAlignment() {
        return 0;
    }

    public int getVerticalTextPosition() {
        return 0;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        return img == this.icon;
    }

    protected String paramString() {
        return "JTextComponent";
    }

    void setDisabledIcon(Icon disabledIcon) {
    }

    void setDisplayedMnemonic(char aChar) {
    }

    void setDisplayedMnemonic(int key) {
    }

    void setHorizontalAlignment(int alignment) {
    }

    void setHorizontalTextPosition(int textPosition) {
    }

    void setIcon(Icon icon) {
    }

    public void setIconTextGap(int iconTextGap) {
    }

    public void setLabelFor(Component c) {
    }

    public void setVerticalAlignment(int alignment) {
    }

    public void setVerticalTextPosition(int textPosition) {
    }

    public TextUI getUI() {
        return (TextUI)this.ui;
    }

    public void updateUI() {
        TextUI b = (TextUI)UIManager.getUI(this);
        this.setUI(b);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    public int getScrollableUnitIncrement(Rectangle visible, int orientation, int direction) {
        return 0;
    }

    public int getScrollableBlockIncrement(Rectangle visible, int orientation, int direction) {
        return 0;
    }

    public static class KeyBinding {
        public KeyStroke key;
        public String actionName;

        public KeyBinding(KeyStroke key, String actionName) {
            this.key = key;
            this.actionName = actionName;
        }
    }

    public class AccessibleJTextComponent
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    CaretListener,
    DocumentListener {
        private /* synthetic */ JTextComponent this$0;
        int caretPos;

        public AccessibleJTextComponent(JTextComponent this$0, JTextComponent component) {
            this.this$0 = this$0;
            super(this$0, component);
        }

        public int getCaretPosition() {
            return 0;
        }

        public String getSelectedText() {
            return null;
        }

        public int getSelectionStart() {
            return 0;
        }

        public int getSelectionEnd() {
            return 0;
        }

        public void caretUpdate(CaretEvent value0) {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleText getAccessibleText() {
            return null;
        }

        public void insertUpdate(DocumentEvent value0) {
        }

        public void removeUpdate(DocumentEvent value0) {
        }

        public void changedUpdate(DocumentEvent value0) {
        }

        public int getIndexAtPoint(Point value0) {
            return 0;
        }

        Rectangle getRootEditorRect() {
            return null;
        }

        public Rectangle getCharacterBounds(int value0) {
            return null;
        }

        public int getCharCount() {
            return 0;
        }

        public AttributeSet getCharacterAttribute(int value0) {
            return null;
        }

        public String getAtIndex(int value0, int value1) {
            return null;
        }

        public String getAfterIndex(int value0, int value1) {
            return null;
        }

        public String getBeforeIndex(int value0, int value1) {
            return null;
        }
    }
}

