# - Try to find marblewidget library
# Once done this will define
#
#  MARBLEWIDGET_FOUND - system has MARBLEWIDGET library
#  LIBMARBLEWIDGET_INCLUDE_DIR - the LIBMARBLEWIDGET include directory
#  LIBMARBLEWIDGET_LIBRARY - the marblewidget library
#
#  copyright 2008 by Patrick Spendrin <ps_ml@gmx.de>
#  use this file as you like
#

if(LIBMARBLEWIDGET_INCLUDE_DIR AND LIBMARBLEWIDGET_LIBRARY)

  # Already in cache
  set(MARBLEWIDGET_FOUND TRUE)

else(LIBMARBLEWIDGET_INCLUDE_DIR AND LIBMARBLEWIDGET_LIBRARY)
  find_path(LIBMARBLEWIDGET_INCLUDE_DIR Quaternion.h PATH_SUFFIXES marble)

  if (WIN32 AND CMAKE_BUILD_TYPE_TOLOWER MATCHES debug)
         set (LIBRARY_NAME marblewidgetd)
    else(WIN32 AND CMAKE_BUILD_TYPE_TOLOWER MATCHES debug)
        set (LIBRARY_NAME marblewidget)
  endif (WIN32 AND CMAKE_BUILD_TYPE_TOLOWER MATCHES debug)
  find_library(LIBMARBLEWIDGET_LIBRARY ${LIBRARY_NAME})

  if(LIBMARBLEWIDGET_INCLUDE_DIR AND LIBMARBLEWIDGET_LIBRARY)
    set(MARBLEWIDGET_FOUND TRUE)
  endif(LIBMARBLEWIDGET_INCLUDE_DIR AND LIBMARBLEWIDGET_LIBRARY)

  if(MARBLEWIDGET_FOUND)
    if (NOT MARBLEWIDGET_FIND_QUIETLY)
      message(STATUS "Found Marble: ${LIBMARBLEWIDGET_LIBRARY}")
    endif (NOT MARBLEWIDGET_FIND_QUIETLY)
  else(MARBLEWIDGET_FOUND)
    if(MARBLEWIDGET_FIND_REQUIRED)
      message(FATAL_ERROR "Could NOT find any Marble library")
    endif(MARBLEWIDGET_FIND_REQUIRED)
  endif(MARBLEWIDGET_FOUND)

  mark_as_advanced(LIBMARBLEWIDGET_INCLUDE_DIR LIBMARBLEWIDGET_LIBRARY)
endif(LIBMARBLEWIDGET_INCLUDE_DIR AND LIBMARBLEWIDGET_LIBRARY)
