/*
 * WARNING!
 *
 * Do not edit this file directly, it is built from the sources at
 * https://github.com/mozilla/source-map/
 */

Components.utils.import('resource://test/Utils.jsm');
/* -*- Mode: js; js-indent-level: 2; -*- */
/*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */
define("test/source-map/test-array-set", ["require", "exports", "module"], function (require, exports, module) {

  var ArraySet = require('source-map/array-set').ArraySet;

  function makeTestSet() {
    var set = new ArraySet();
    for (var i = 0; i < 100; i++) {
      set.add(String(i));
    }
    return set;
  }

  exports['test .has() membership'] = function (assert, util) {
    var set = makeTestSet();
    for (var i = 0; i < 100; i++) {
      assert.ok(set.has(String(i)));
    }
  };

  exports['test .indexOf() elements'] = function (assert, util) {
    var set = makeTestSet();
    for (var i = 0; i < 100; i++) {
      assert.strictEqual(set.indexOf(String(i)), i);
    }
  };

  exports['test .at() indexing'] = function (assert, util) {
    var set = makeTestSet();
    for (var i = 0; i < 100; i++) {
      assert.strictEqual(set.at(i), String(i));
    }
  };

  exports['test creating from an array'] = function (assert, util) {
    var set = ArraySet.fromArray(['foo', 'bar', 'baz', 'quux', 'hasOwnProperty']);

    assert.ok(set.has('foo'));
    assert.ok(set.has('bar'));
    assert.ok(set.has('baz'));
    assert.ok(set.has('quux'));
    assert.ok(set.has('hasOwnProperty'));

    assert.strictEqual(set.indexOf('foo'), 0);
    assert.strictEqual(set.indexOf('bar'), 1);
    assert.strictEqual(set.indexOf('baz'), 2);
    assert.strictEqual(set.indexOf('quux'), 3);

    assert.strictEqual(set.at(0), 'foo');
    assert.strictEqual(set.at(1), 'bar');
    assert.strictEqual(set.at(2), 'baz');
    assert.strictEqual(set.at(3), 'quux');
  };

});
function run_test() {
  runSourceMapTests('test/source-map/test-array-set', do_throw);
}
