/*
 * Decompiled with CFR 0.152.
 */
package classycle.ant;

import classycle.util.AndStringPattern;
import classycle.util.NotStringPattern;
import classycle.util.StringPattern;
import classycle.util.TrueStringPattern;
import classycle.util.WildCardPattern;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;

public abstract class ClassycleTask
extends Task {
    private boolean _mergeInnerClasses;
    private StringPattern _includingClasses = new TrueStringPattern();
    private StringPattern _excludingClasses = new TrueStringPattern();
    private StringPattern _reflectionPattern;
    private List<ResourceCollection> _resources = new LinkedList<ResourceCollection>();
    protected File _reportFile;

    public void setMergeInnerClasses(boolean mergeInnerClasses) {
        this._mergeInnerClasses = mergeInnerClasses;
    }

    public void setIncludingClasses(String patternList) {
        this._includingClasses = WildCardPattern.createFromsPatterns(patternList, ", ");
    }

    public void setExcludingClasses(String patternList) {
        this._excludingClasses = new NotStringPattern(WildCardPattern.createFromsPatterns(patternList, ", "));
    }

    public void setReflectionPattern(String patternList) {
        this._reflectionPattern = "".equals(patternList) ? new TrueStringPattern() : WildCardPattern.createFromsPatterns(patternList, ", ");
    }

    public void add(ResourceCollection rc) {
        this._resources.add(rc);
    }

    public void execute() throws BuildException {
        super.execute();
        if (this._resources.size() == 0) {
            throw new BuildException("at least one file set is required");
        }
    }

    protected String[] getClassFileNames() {
        ArrayList<String> fileNames = new ArrayList<String>();
        String fileSeparator = System.getProperty("file.separator");
        for (ResourceCollection rc : this._resources) {
            if (!(rc instanceof FileSet)) {
                throw new BuildException("resource collection unsupported " + rc);
            }
            FileSet set = (FileSet)rc;
            DirectoryScanner scanner = set.getDirectoryScanner(this.getProject());
            String path = scanner.getBasedir().getAbsolutePath();
            String[] localFiles = scanner.getIncludedFiles();
            String separator = fileSeparator;
            if (rc instanceof ZipFileSet) {
                ZipFileSet zipFileSet = (ZipFileSet)rc;
                path = zipFileSet.getSrc().getAbsolutePath();
                separator = "::";
            }
            for (int j = 0; j < localFiles.length; ++j) {
                fileNames.add(path + separator + localFiles[j]);
            }
        }
        String[] classFiles = new String[fileNames.size()];
        return fileNames.toArray(classFiles);
    }

    protected StringPattern getPattern() {
        AndStringPattern pattern = new AndStringPattern(new StringPattern[0]);
        pattern.appendPattern(this._includingClasses);
        pattern.appendPattern(this._excludingClasses);
        return pattern;
    }

    protected StringPattern getReflectionPattern() {
        return this._reflectionPattern;
    }

    protected boolean isMergeInnerClasses() {
        return this._mergeInnerClasses;
    }

    public void setReportFile(File xmlFile) {
        this._reportFile = xmlFile;
    }
}

