//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Runtime.InteropServices;
    using System.Collections.Generic;
    /// <remarks>
    ///  Base class representing a time zone.
    ///  The KTimeZone base class contains general descriptive data about the time zone, and
    ///  provides an interface for methods to read and parse time zone definitions, and to
    ///  translate between UTC and local time. Derived classes must implement these methods,
    ///  and may also hold the actual details of the dates and times of daylight savings
    ///  changes, offsets from UTC, etc. They should be tailored to deal with the type and
    ///  format of data held by a particular type of time zone database.
    ///  If this base class is instantiated as a valid instance, it always represents the
    ///  UTC time zone.
    ///  KTimeZone is designed to work in partnership with KTimeZoneSource. KTimeZone
    ///  provides access to individual time zones, while classes derived from
    ///  KTimeZoneSource read and parse a particular format of time zone definition.
    ///  Because time zone sources can differ in what information they provide about time zones,
    ///  the parsed data retured by KTimeZoneSource can vary between different sources,
    ///  resulting in the need to create different KTimeZone classes to handle the data.
    ///  KTimeZone instances are often grouped into KTimeZones collections.
    ///  Copying KTimeZone instances is very efficient since the class data is explicitly
    ///  shared, meaning that only a pointer to the data is actually copied. To achieve
    ///  this, each class inherited from KTimeZone must have a corresponding backend
    ///  class derived from KTimeZoneBackend.
    ///  @note Classes derived from KTimeZone should not have their own d-pointer. The
    ///  d-pointer is instead contained in their backend class (derived from
    ///  KTimeZoneBackend). This allows KTimeZone's reference-counting of private data to
    ///  take care of the derived class's data as well, ensuring that instance data is
    ///  not deleted while any references to the class instance remains. All virtual
    ///  methods which override KTimeZone methods must be defined in the
    ///  backend class instead.
    /// </remarks>        <author> S.R.Haque <srhaque@iee.org>.
    ///  </author>
    ///         <short> Base class representing a time zone.</short>
    ///         <see> KTimeZoneBackend</see>
    ///         <see> KTimeZoneSource</see>
    ///         <see> KTimeZoneData</see>
    ///         <see> @ingroup</see>
    ///         <see> timezones</see>
    [SmokeClass("KTimeZone")]
    public class KTimeZone : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KTimeZone(Type dummy) {}
        [SmokeClass("KTimeZone::Transition")]
        public class Transition : Object {
            protected SmokeInvocation interceptor = null;
            private IntPtr smokeObject;
            protected Transition(Type dummy) {}
            protected void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(Transition), this);
            }
            //  Transition(); >>>> NOT CONVERTED
            //  Transition(,); >>>> NOT CONVERTED
            //  Transition(); >>>> NOT CONVERTED
            // Phase phase(); >>>> NOT CONVERTED
            // bool operator<(); >>>> NOT CONVERTED
            /// <remarks>
            ///  Return the UTC time of the transition.
            /// </remarks>        <return> UTC time
            ///          </return>
            ///         <short>    Return the UTC time of the transition.</short>
            public QDateTime Time() {
                return (QDateTime) interceptor.Invoke("time", "time() const", typeof(QDateTime));
            }
            /// <remarks>
            ///  Return the time zone phase which takes effect after the transition.
            /// </remarks>        <return> time zone phase
            ///          </return>
            ///         <short>    Return the time zone phase which takes effect after the transition.</short>
            /// <remarks>
            ///  Compare the date/time values of two transitions.
            /// <param> name="rhs" other instance
            /// </param></remarks>        <return> @c true if this Transition is earlier than <code>rhs</code>
            ///          </return>
            ///         <short>    Compare the date/time values of two transitions.</short>
        }
        [SmokeClass("KTimeZone::Phase")]
        public class Phase : Object, IDisposable {
            protected SmokeInvocation interceptor = null;
            private IntPtr smokeObject;
            protected Phase(Type dummy) {}
            protected void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(Phase), this);
            }
            private static SmokeInvocation staticInterceptor = null;
            static Phase() {
                staticInterceptor = new SmokeInvocation(typeof(Phase), null);
            }
            public Phase() : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Phase", "Phase()", typeof(void));
            }
            /// <remarks>
            ///  Constructor.
            /// <param> name="utcOffset" number of seconds to add to UTC to get local time in this phase
            /// </param><param> name="abbreviations" time zone abbreviation for this phase. If translations exist,
            ///                       concatenate all abbreviations as null-terminated strings.
            /// </param><param> name="dst" true if daylight savings time, false if standard time
            /// </param><param> name="comment" optional comment
            ///          </param></remarks>        <short>    Constructor.</short>
            public Phase(int utcOffset, QByteArray abbreviations, bool dst, string comment) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Phase$#$$", "Phase(int, const QByteArray&, bool, const QString&)", typeof(void), typeof(int), utcOffset, typeof(QByteArray), abbreviations, typeof(bool), dst, typeof(string), comment);
            }
            public Phase(int utcOffset, QByteArray abbreviations, bool dst) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Phase$#$", "Phase(int, const QByteArray&, bool)", typeof(void), typeof(int), utcOffset, typeof(QByteArray), abbreviations, typeof(bool), dst);
            }
            /// <remarks>
            ///  Constructor.
            /// <param> name="utcOffset" number of seconds to add to UTC to get local time in this phase
            /// </param><param> name="abbreviations" time zone abbreviation for this phase, plus any translations
            /// </param><param> name="dst" true if daylight savings time, false if standard time
            /// </param><param> name="comment" optional comment
            ///          </param></remarks>        <short>    Constructor.</short>
            public Phase(int utcOffset, List<QByteArray> abbreviations, bool dst, string comment) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Phase$?$$", "Phase(int, const QList<QByteArray>&, bool, const QString&)", typeof(void), typeof(int), utcOffset, typeof(List<QByteArray>), abbreviations, typeof(bool), dst, typeof(string), comment);
            }
            public Phase(int utcOffset, List<QByteArray> abbreviations, bool dst) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Phase$?$", "Phase(int, const QList<QByteArray>&, bool)", typeof(void), typeof(int), utcOffset, typeof(List<QByteArray>), abbreviations, typeof(bool), dst);
            }
            public Phase(KTimeZone.Phase rhs) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("Phase#", "Phase(const KTimeZone::Phase&)", typeof(void), typeof(KTimeZone.Phase), rhs);
            }
            public override bool Equals(object o) {
                if (!(o is Phase)) { return false; }
                return this == (Phase) o;
            }
            public override int GetHashCode() {
                return interceptor.GetHashCode();
            }
            /// <remarks>
            ///  Return the UTC offset in seconds during this phase.
            ///  The UTC offset is the number of seconds which you must add to UTC
            ///  to get local time.
            /// </remarks>        <return> offset in seconds to add to UTC
            ///          </return>
            ///         <short>    Return the UTC offset in seconds during this phase.</short>
            public int UtcOffset() {
                return (int) interceptor.Invoke("utcOffset", "utcOffset() const", typeof(int));
            }
            /// <remarks>
            ///  Return the time zone abbreviations which apply to this phase.
            ///  More than one abbreviation may be returned, to allow for possible translations.
            /// </remarks>        <return> time zone abbreviations
            ///          </return>
            ///         <short>    Return the time zone abbreviations which apply to this phase.</short>
            public List<QByteArray> Abbreviations() {
                return (List<QByteArray>) interceptor.Invoke("abbreviations", "abbreviations() const", typeof(List<QByteArray>));
            }
            /// <remarks>
            ///  Return whether daylight savings time applies during this phase.
            /// </remarks>        <return> true if daylight savings are in operation, false otherwise
            ///          </return>
            ///         <short>    Return whether daylight savings time applies during this phase.</short>
            public bool IsDst() {
                return (bool) interceptor.Invoke("isDst", "isDst() const", typeof(bool));
            }
            /// <remarks>
            ///  Return the comment (if any) applying to this phase.
            /// </remarks>        <return> comment
            ///          </return>
            ///         <short>    Return the comment (if any) applying to this phase.</short>
            public string Comment() {
                return (string) interceptor.Invoke("comment", "comment() const", typeof(string));
            }
            ~Phase() {
                interceptor.Invoke("~Phase", "~Phase()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~Phase", "~Phase()", typeof(void));
            }
            public static bool operator==(Phase lhs, KTimeZone.Phase rhs) {
                return (bool) staticInterceptor.Invoke("operator==#", "operator==(const KTimeZone::Phase&) const", typeof(bool), typeof(Phase), lhs, typeof(KTimeZone.Phase), rhs);
            }
            public static bool operator!=(Phase lhs, KTimeZone.Phase rhs) {
                return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const KTimeZone::Phase&) const", typeof(bool), typeof(Phase), lhs, typeof(KTimeZone.Phase), rhs);
            }
        }
        [SmokeClass("KTimeZone::LeapSeconds")]
        public class LeapSeconds : Object, IDisposable {
            protected SmokeInvocation interceptor = null;
            private IntPtr smokeObject;
            protected LeapSeconds(Type dummy) {}
            protected void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(LeapSeconds), this);
            }
            private static SmokeInvocation staticInterceptor = null;
            static LeapSeconds() {
                staticInterceptor = new SmokeInvocation(typeof(LeapSeconds), null);
            }
            public LeapSeconds() : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("LeapSeconds", "LeapSeconds()", typeof(void));
            }
            public LeapSeconds(QDateTime utcTime, int leapSeconds, string comment) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("LeapSeconds#$$", "LeapSeconds(const QDateTime&, int, const QString&)", typeof(void), typeof(QDateTime), utcTime, typeof(int), leapSeconds, typeof(string), comment);
            }
            public LeapSeconds(QDateTime utcTime, int leapSeconds) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("LeapSeconds#$", "LeapSeconds(const QDateTime&, int)", typeof(void), typeof(QDateTime), utcTime, typeof(int), leapSeconds);
            }
            public LeapSeconds(KTimeZone.LeapSeconds c) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("LeapSeconds#", "LeapSeconds(const KTimeZone::LeapSeconds&)", typeof(void), typeof(KTimeZone.LeapSeconds), c);
            }
            /// <remarks>
            ///  Return whether this instance holds valid data.
            /// </remarks>        <return> true if valid, false if invalid
            ///          </return>
            ///         <short>    Return whether this instance holds valid data.</short>
            public bool IsValid() {
                return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
            }
            /// <remarks>
            ///  Return the UTC date/time when this change occurred.
            /// </remarks>        <return> date/time
            ///          </return>
            ///         <short>    Return the UTC date/time when this change occurred.</short>
            public QDateTime DateTime() {
                return (QDateTime) interceptor.Invoke("dateTime", "dateTime() const", typeof(QDateTime));
            }
            /// <remarks>
            ///  Return the cumulative number of leap seconds to be added after this
            ///  change occurs.
            /// </remarks>        <return> number of leap seconds
            ///          </return>
            ///         <short>    Return the cumulative number of leap seconds to be added after this  change occurs.</short>
            public int leapSeconds() {
                return (int) interceptor.Invoke("leapSeconds", "leapSeconds() const", typeof(int));
            }
            /// <remarks>
            ///  Return the comment (if any) applying to this change.
            /// </remarks>        <return> comment
            ///          </return>
            ///         <short>    Return the comment (if any) applying to this change.</short>
            public string Comment() {
                return (string) interceptor.Invoke("comment", "comment() const", typeof(string));
            }
            ~LeapSeconds() {
                interceptor.Invoke("~LeapSeconds", "~LeapSeconds()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~LeapSeconds", "~LeapSeconds()", typeof(void));
            }
            public static bool operator<(LeapSeconds lhs, KTimeZone.LeapSeconds c) {
                return (bool) staticInterceptor.Invoke("operator<#", "operator<(const KTimeZone::LeapSeconds&) const", typeof(bool), typeof(LeapSeconds), lhs, typeof(KTimeZone.LeapSeconds), c);
            }
            public static bool operator>(LeapSeconds lhs, KTimeZone.LeapSeconds c) {
                return !(bool) staticInterceptor.Invoke("operator<#", "operator<(const KTimeZone::LeapSeconds&) const", typeof(bool), typeof(LeapSeconds), lhs, typeof(KTimeZone.LeapSeconds), c)
                            && !(bool) staticInterceptor.Invoke("operator==#", "operator==(const KTimeZone::LeapSeconds&) const", typeof(bool), typeof(LeapSeconds), lhs, typeof(KTimeZone.LeapSeconds), c);
            }
        }
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KTimeZone), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KTimeZone() {
            staticInterceptor = new SmokeInvocation(typeof(KTimeZone), null);
        }
        public static int InvalidOffset() {
            return (int) staticInterceptor.Invoke("InvalidOffset", "InvalidOffset()", typeof(int));
        }
        public static int InvalidTime_t() {
            return (int) staticInterceptor.Invoke("InvalidTime_t", "InvalidTime_t()", typeof(int));
        }
        public static float UNKNOWN() {
            return (float) staticInterceptor.Invoke("UNKNOWN", "UNKNOWN()", typeof(float));
        }
        // QList<KTimeZone::Transition> transitions(const QDateTime& arg1,const QDateTime& arg2); >>>> NOT CONVERTED
        // QList<KTimeZone::Transition> transitions(const QDateTime& arg1); >>>> NOT CONVERTED
        // QList<KTimeZone::Transition> transitions(); >>>> NOT CONVERTED
        // const KTimeZone::Transition* transition(const QDateTime& arg1,const KTimeZone::Transition** arg2,bool* arg3); >>>> NOT CONVERTED
        // const KTimeZone::Transition* transition(const QDateTime& arg1,const KTimeZone::Transition** arg2); >>>> NOT CONVERTED
        // const KTimeZone::Transition* transition(const QDateTime& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  Constructs a null time zone. A null time zone is invalid.
        /// </remarks>        <short>    Constructs a null time zone.</short>
        ///         <see> isValid</see>
        public KTimeZone() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KTimeZone", "KTimeZone()", typeof(void));
        }
        /// <remarks>
        ///  Constructs a UTC time zone.
        /// <param> name="name" name of the UTC time zone
        ///      </param></remarks>        <short>    Constructs a UTC time zone.</short>
        public KTimeZone(string name) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KTimeZone$", "KTimeZone(const QString&)", typeof(void), typeof(string), name);
        }
        public KTimeZone(KTimeZone tz) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KTimeZone#", "KTimeZone(const KTimeZone&)", typeof(void), typeof(KTimeZone), tz);
        }
        /// <remarks>
        ///  Checks whether this is the same instance as another one.
        ///  Note that only the pointers to the time zone data are compared, not the
        ///  contents. So it will only return equality if one instance was copied
        ///  from the other.
        /// <param> name="rhs" other instance
        /// </param></remarks>        <return> true if the same instance, else false
        ///      </return>
        ///         <short>    Checks whether this is the same instance as another one.</short>
        public override bool Equals(object o) {
            if (!(o is KTimeZone)) { return false; }
            return this == (KTimeZone) o;
        }
        public override int GetHashCode() {
            return interceptor.GetHashCode();
        }
        /// <remarks>
        ///  Returns the class name of the data represented by this instance.
        ///  If a derived class object has been assigned to this instance, this
        ///  method will return the name of that class.
        /// </remarks>        <return> "KTimeZone" or the class name of a derived class
        ///      </return>
        ///         <short>    Returns the class name of the data represented by this instance.</short>
        public QByteArray type() {
            return (QByteArray) interceptor.Invoke("type", "type() const", typeof(QByteArray));
        }
        /// <remarks>
        ///  Checks whether the instance is valid.
        /// </remarks>        <return> true if valid, false if invalid
        ///      </return>
        ///         <short>    Checks whether the instance is valid.</short>
        public bool IsValid() {
            return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the name of the time zone.
        ///  If it is held in a KTimeZones container, the name is the time zone's unique
        ///  identifier within that KTimeZones instance.
        /// </remarks>        <return> name in system-dependent format
        ///      </return>
        ///         <short>    Returns the name of the time zone.</short>
        public string Name() {
            return (string) interceptor.Invoke("name", "name() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the two-letter country code of the time zone.
        /// </remarks>        <return> upper case ISO 3166 2-character country code, empty if unknown
        ///      </return>
        ///         <short>    Returns the two-letter country code of the time zone.</short>
        public string CountryCode() {
            return (string) interceptor.Invoke("countryCode", "countryCode() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the latitude of the time zone.
        /// </remarks>        <return> latitude in degrees, UNKNOWN if not known
        ///      </return>
        ///         <short>    Returns the latitude of the time zone.</short>
        public float Latitude() {
            return (float) interceptor.Invoke("latitude", "latitude() const", typeof(float));
        }
        /// <remarks>
        ///  Returns the latitude of the time zone.
        /// </remarks>        <return> latitude in degrees, UNKNOWN if not known
        ///      </return>
        ///         <short>    Returns the latitude of the time zone.</short>
        public float Longitude() {
            return (float) interceptor.Invoke("longitude", "longitude() const", typeof(float));
        }
        /// <remarks>
        ///  Returns any comment for the time zone.
        /// </remarks>        <return> comment, may be empty
        ///      </return>
        ///         <short>    Returns any comment for the time zone.</short>
        public string Comment() {
            return (string) interceptor.Invoke("comment", "comment() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the list of time zone abbreviations used by the time zone.
        ///  This may include historical ones which are no longer in use or have
        ///  been superseded.
        /// </remarks>        <return> list of abbreviations
        /// </return>
        ///         <short>    Returns the list of time zone abbreviations used by the time zone.</short>
        ///         <see> abbreviation</see>
        public List<QByteArray> Abbreviations() {
            return (List<QByteArray>) interceptor.Invoke("abbreviations", "abbreviations() const", typeof(List<QByteArray>));
        }
        /// <remarks>
        ///  Returns the time zone abbreviation current at a specified time.
        /// <param> name="utcDateTime" UTC date/time. An error occurs if
        ///                     <code>utcDateTime.timeSpec</code>() is not Qt.UTC.
        /// </param></remarks>        <return> time zone abbreviation, or empty string if error
        /// </return>
        ///         <short>    Returns the time zone abbreviation current at a specified time.</short>
        ///         <see> abbreviations</see>
        public QByteArray Abbreviation(QDateTime utcDateTime) {
            return (QByteArray) interceptor.Invoke("abbreviation#", "abbreviation(const QDateTime&) const", typeof(QByteArray), typeof(QDateTime), utcDateTime);
        }
        /// <remarks>
        ///  Returns the complete list of UTC offsets used by the time zone. This may
        ///  include historical ones which are no longer in use or have been
        ///  superseded.
        ///  A UTC offset is the number of seconds which you must add to UTC to get
        ///  local time in this time zone.
        ///  If due to the nature of the source data for the time zone, compiling a
        ///  complete list would require significant processing, an empty list is
        ///  returned instead.
        /// </remarks>        <return> sorted list of UTC offsets, or empty list if not readily available.
        ///      </return>
        ///         <short>    Returns the complete list of UTC offsets used by the time zone.</short>
        public List<int> UtcOffsets() {
            return (List<int>) interceptor.Invoke("utcOffsets", "utcOffsets() const", typeof(List<int>));
        }
        /// <remarks>
        ///  Converts a date/time, which is interpreted as being local time in this
        ///  time zone, into local time in another time zone.
        /// <param> name="newZone" other time zone which the time is to be converted into
        /// </param><param> name="zoneDateTime" local date/time. An error occurs if
        ///                      <code>zoneDateTime.timeSpec</code>() is not Qt.LocalTime.
        /// </param></remarks>        <return> converted date/time, or invalid date/time if error
        /// </return>
        ///         <short>    Converts a date/time, which is interpreted as being local time in this  time zone, into local time in another time zone.</short>
        ///         <see> toUtc</see>
        ///         <see> toZoneTime</see>
        public QDateTime Convert(KTimeZone newZone, QDateTime zoneDateTime) {
            return (QDateTime) interceptor.Invoke("convert##", "convert(const KTimeZone&, const QDateTime&) const", typeof(QDateTime), typeof(KTimeZone), newZone, typeof(QDateTime), zoneDateTime);
        }
        /// <remarks>
        ///  Converts a date/time, which is interpreted as local time in this time
        ///  zone, into UTC.
        ///  Because of daylight savings time shifts, the date/time may occur twice. In
        ///  such cases, this method returns the UTC time for the first occurrence.
        ///  If you need the UTC time of the second occurrence, use offsetAtZoneTime().
        /// <param> name="zoneDateTime" local date/time. An error occurs if
        ///                      <code>zoneDateTime.timeSpec</code>() is not Qt.LocalTime.
        /// </param></remarks>        <return> UTC date/time, or invalid date/time if error
        /// </return>
        ///         <short>    Converts a date/time, which is interpreted as local time in this time  zone, into UTC.</short>
        ///         <see> toZoneTime</see>
        ///         <see> convert</see>
        public QDateTime ToUtc(QDateTime zoneDateTime) {
            return (QDateTime) interceptor.Invoke("toUtc#", "toUtc(const QDateTime&) const", typeof(QDateTime), typeof(QDateTime), zoneDateTime);
        }
        /// <remarks>
        ///  Converts a UTC date/time into local time in this time zone.
        ///  Because of daylight savings time shifts, some local date/time values occur
        ///  twice. The <code>secondOccurrence</code> parameter may be used to determine whether
        ///  the time returned is the first or second occurrence of that time.
        /// <param> name="utcDateTime" UTC date/time. An error occurs if
        ///                     <code>utcDateTime.timeSpec</code>() is not Qt.UTC.
        /// </param><param> name="secondOccurrence" if non-null, returns <code>true</code> if the return value
        ///                     is the second occurrence of that time, else <code>false</code>
        /// </param></remarks>        <return> local date/time, or invalid date/time if error
        /// </return>
        ///         <short>    Converts a UTC date/time into local time in this time zone.</short>
        ///         <see> toUtc</see>
        ///         <see> convert</see>
        public QDateTime ToZoneTime(QDateTime utcDateTime, ref bool secondOccurrence) {
            StackItem[] stack = new StackItem[3];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(utcDateTime);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(utcDateTime);
#endif
            stack[2].s_bool = secondOccurrence;
            interceptor.Invoke("toZoneTime#$", "toZoneTime(const QDateTime&, bool*) const", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).SynchronizedFree();
#endif
            secondOccurrence = stack[2].s_bool;
            object returnValue = ((GCHandle) stack[0].s_class).Target;
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[0].s_class);
#else
            ((GCHandle) stack[0].s_class).SynchronizedFree();
#endif
            return (QDateTime) returnValue;
        }
        public QDateTime ToZoneTime(QDateTime utcDateTime) {
            return (QDateTime) interceptor.Invoke("toZoneTime#", "toZoneTime(const QDateTime&) const", typeof(QDateTime), typeof(QDateTime), utcDateTime);
        }
        /// <remarks>
        ///  Returns the current offset of this time zone to UTC or the local
        ///  system time zone. The offset is the number of seconds which you must
        ///  add to UTC or the local system time to get local time in this time zone.
        ///  Take care if you cache the results of this routine; that would
        ///  break if the result were stored across a daylight savings change.
        /// <param> name="basis" Qt.UTC to return the offset to UTC, Qt.LocalTime
        ///                   to return the offset to local system time
        /// </param></remarks>        <return> offset in seconds
        /// </return>
        ///         <short>    Returns the current offset of this time zone to UTC or the local  system time zone.</short>
        ///         <see> offsetAtZoneTime</see>
        ///         <see> offsetAtUtc</see>
        public int CurrentOffset(Qt.TimeSpec basis) {
            return (int) interceptor.Invoke("currentOffset$", "currentOffset(Qt::TimeSpec) const", typeof(int), typeof(Qt.TimeSpec), basis);
        }
        public int CurrentOffset() {
            return (int) interceptor.Invoke("currentOffset", "currentOffset() const", typeof(int));
        }
        /// <remarks>
        ///  Returns the offset of this time zone to UTC at the given local date/time.
        ///  Because of daylight savings time shifts, the date/time may occur twice. Optionally,
        ///  the offsets at both occurrences of <code>dateTime</code> are calculated.
        ///  The offset is the number of seconds which you must add to UTC to get
        ///  local time in this time zone.
        /// <param> name="zoneDateTime" the date/time at which the offset is to be calculated. This
        ///                      is interpreted as a local time in this time zone. An error
        ///                      occurs if <code>zoneDateTime.timeSpec</code>() is not Qt.LocalTime.
        /// </param><param> name="secondOffset" if non-null, and the <code>zoneDateTime</code> occurs twice, receives the
        ///                      UTC offset for the second occurrence. Otherwise, it is set
        ///                      the same as the return value.
        /// </param></remarks>        <return> offset in seconds. If <code>zoneDateTime</code> occurs twice, it is the offset at the
        ///          first occurrence which is returned. If <code>zoneDateTime</code> does not exist because
        ///          of daylight savings time shifts, InvalidOffset is returned. If any other error
        ///          occurs, 0 is returned.
        /// </return>
        ///         <short>    Returns the offset of this time zone to UTC at the given local date/time.</short>
        ///         <see> offsetAtUtc</see>
        ///         <see> currentOffset</see>
        [SmokeMethod("offsetAtZoneTime(const QDateTime&, int*) const")]
        public virtual int OffsetAtZoneTime(QDateTime zoneDateTime, ref int secondOffset) {
            StackItem[] stack = new StackItem[3];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(zoneDateTime);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(zoneDateTime);
#endif
            stack[2].s_int = secondOffset;
            interceptor.Invoke("offsetAtZoneTime#$", "offsetAtZoneTime(const QDateTime&, int*) const", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).SynchronizedFree();
#endif
            secondOffset = stack[2].s_int;
            return stack[0].s_int;
        }
        [SmokeMethod("offsetAtZoneTime(const QDateTime&) const")]
        public virtual int OffsetAtZoneTime(QDateTime zoneDateTime) {
            return (int) interceptor.Invoke("offsetAtZoneTime#", "offsetAtZoneTime(const QDateTime&) const", typeof(int), typeof(QDateTime), zoneDateTime);
        }
        /// <remarks>
        ///  Returns the offset of this time zone to UTC at the given UTC date/time.
        ///  The offset is the number of seconds which you must add to UTC to get
        ///  local time in this time zone.
        ///  If a derived class needs to work in terms of time_t (as when accessing the
        ///  system time functions, for example), it should override both this method and
        ///  offset() so as to implement its offset calculations in offset(), and
        ///  reimplement this method simply as
        ///  <pre>
        ///      offset(toTime_t(utcDateTime));
        ///  </pre>
        /// <param> name="utcDateTime" the UTC date/time at which the offset is to be calculated.
        ///                     An error occurs if <code>utcDateTime.timeSpec</code>() is not Qt.UTC.
        /// </param></remarks>        <return> offset in seconds, or 0 if error
        /// </return>
        ///         <short>    Returns the offset of this time zone to UTC at the given UTC date/time.</short>
        ///         <see> offset</see>
        ///         <see> offsetAtZoneTime</see>
        ///         <see> currentOffset</see>
        [SmokeMethod("offsetAtUtc(const QDateTime&) const")]
        public virtual int OffsetAtUtc(QDateTime utcDateTime) {
            return (int) interceptor.Invoke("offsetAtUtc#", "offsetAtUtc(const QDateTime&) const", typeof(int), typeof(QDateTime), utcDateTime);
        }
        /// <remarks>
        ///  Returns the offset of this time zone to UTC at a specified UTC time.
        ///  The offset is the number of seconds which you must add to UTC to get
        ///  local time in this time zone.
        ///  Note that time_t has a more limited range than QDateTime, so consider using
        ///  offsetAtUtc() instead.
        /// <param> name="t" the UTC time at which the offset is to be calculated, measured in seconds
        ///           since 00:00:00 UTC 1st January 1970 (as returned by time(2))
        /// </param></remarks>        <return> offset in seconds, or 0 if error
        /// </return>
        ///         <short>    Returns the offset of this time zone to UTC at a specified UTC time.</short>
        ///         <see> offsetAtUtc</see>
        [SmokeMethod("offset(time_t) const")]
        public virtual int Offset(int t) {
            return (int) interceptor.Invoke("offset$", "offset(time_t) const", typeof(int), typeof(int), t);
        }
        /// <remarks>
        ///  Returns whether daylight savings time is in operation at the given UTC date/time.
        ///  If a derived class needs to work in terms of time_t (as when accessing the
        ///  system time functions, for example), it should override both this method and
        ///  isDst() so as to implement its offset calculations in isDst(), and reimplement
        ///  this method simply as
        ///  <pre>
        ///      isDst(toTime_t(utcDateTime));
        ///  </pre>
        /// <param> name="utcDateTime" the UTC date/time. An error occurs if
        ///                     <code>utcDateTime.timeSpec</code>() is not Qt.UTC.
        /// </param></remarks>        <return> @c true if daylight savings time is in operation, @c false otherwise
        /// </return>
        ///         <short>    Returns whether daylight savings time is in operation at the given UTC date/time.</short>
        ///         <see> isDst</see>
        [SmokeMethod("isDstAtUtc(const QDateTime&) const")]
        public virtual bool IsDstAtUtc(QDateTime utcDateTime) {
            return (bool) interceptor.Invoke("isDstAtUtc#", "isDstAtUtc(const QDateTime&) const", typeof(bool), typeof(QDateTime), utcDateTime);
        }
        /// <remarks>
        ///  Returns whether daylight savings time is in operation at a specified UTC time.
        ///  Note that time_t has a more limited range than QDateTime, so consider using
        ///  isDstAtUtc() instead.
        /// <param> name="t" the UTC time, measured in seconds since 00:00:00 UTC 1st January 1970
        ///           (as returned by time(2))
        /// </param></remarks>        <return> @c true if daylight savings time is in operation, @c false otherwise
        /// </return>
        ///         <short>    Returns whether daylight savings time is in operation at a specified UTC time.</short>
        ///         <see> isDstAtUtc</see>
        [SmokeMethod("isDst(time_t) const")]
        public virtual bool IsDst(int t) {
            return (bool) interceptor.Invoke("isDst$", "isDst(time_t) const", typeof(bool), typeof(int), t);
        }
        /// <remarks>
        ///  Return all daylight savings time phases for the time zone.
        ///  Note that some time zone data sources (such as system time zones accessed
        ///  via the system libraries) may not allow a list of daylight savings time
        ///  changes to be compiled easily. In such cases, this method will return an
        ///  empty list.
        /// </remarks>        <return> list of phases
        ///      </return>
        ///         <short>    Return all daylight savings time phases for the time zone.</short>
        public List<KTimeZone.Phase> Phases() {
            return (List<KTimeZone.Phase>) interceptor.Invoke("phases", "phases() const", typeof(List<KTimeZone.Phase>));
        }
        /// <remarks>
        ///  Return whether daylight saving transitions are available for the time zone.
        ///  The base class returns <code>false.</code>
        /// </remarks>        <return> @c true if transitions are available, @c false if not
        /// </return>
        ///         <short>    Return whether daylight saving transitions are available for the time zone.</short>
        ///         <see> transitions</see>
        ///         <see> transition</see>
        [SmokeMethod("hasTransitions() const")]
        public virtual bool HasTransitions() {
            return (bool) interceptor.Invoke("hasTransitions", "hasTransitions() const", typeof(bool));
        }
        /// <remarks>
        ///  Return all daylight saving transitions, in time order. If desired, the
        ///  transitions returned may be restricted to a specified time range.
        ///  Note that some time zone data sources (such as system time zones accessed
        ///  via the system libraries) may not allow a list of daylight saving time
        ///  changes to be compiled easily. In such cases, this method will return an
        ///  empty list.
        /// <param> name="start" start UTC date/time, or invalid date/time to return all transitions
        ///               up to <code>end.</code> <code>start.timeSpec</code>() must be Qt.UTC, else
        ///               <code>start</code> will be considered invalid.
        /// </param><param> name="end" end UTC date/time, or invalid date/time for no end. <code>end.timeSpec</code>()
        ///                 must be Qt.UTC, else <code>end</code> will be considered invalid.
        /// </param></remarks>        <return> list of transitions, in time order
        /// </return>
        ///         <short>    Return all daylight saving transitions, in time order.</short>
        ///         <see> hasTransitions</see>
        ///         <see> transition</see>
        ///         <see> transitionTimes</see>
        /// <remarks>
        ///  Find the last daylight savings time transition at or before a given
        ///  UTC or local time.
        ///  Because of daylight savings time shifts, a local time may occur twice or
        ///  may not occur at all. In the former case, the transitions at or before
        ///  both occurrences of <code>dt</code> may optionally be calculated and returned in
        ///  <code>secondTransition.</code> The latter case may optionally be detected by use of
        ///  <code>validTime.</code>
        /// <param> name="dt" date/time. <code>dt.timeSpec</code>() may be set to Qt.UTC or Qt.LocalTime.
        /// </param><param> name="secondTransition" if non-null, and the <code>dt</code> occurs twice, receives the
        ///                      transition for the second occurrence. Otherwise, it is set
        ///                      the same as the return value.
        /// </param><param> name="validTime" if non-null, is set to false if <code>dt</code> does not occur, or
        ///                   to true otherwise
        /// </param></remarks>        <return> time zone transition, or null either if <code>dt</code> is either outside the
        ///          defined range of the transition data or if <code>dt</code> does not occur
        /// </return>
        ///         <short>    Find the last daylight savings time transition at or before a given  UTC or local time.</short>
        ///         <see> transitionIndex</see>
        ///         <see> hasTransitions</see>
        ///         <see> transitions</see>
        /// <remarks>
        ///  Find the index to the last daylight savings time transition at or before
        ///  a given UTC or local time. The return value is the index into the transition
        ///  list returned by transitions().
        ///  Because of daylight savings time shifts, a local time may occur twice or
        ///  may not occur at all. In the former case, the transitions at or before
        ///  both occurrences of <code>dt</code> may optionally be calculated and returned in
        ///  <code>secondIndex.</code> The latter case may optionally be detected by use of
        ///  <code>validTime.</code>
        /// <param> name="dt" date/time. <code>dt.timeSpec</code>() may be set to Qt.UTC or Qt.LocalTime.
        /// </param><param> name="secondIndex" if non-null, and the <code>dt</code> occurs twice, receives the
        ///                     index to the transition for the second occurrence. Otherwise,
        ///                     it is set the same as the return value.
        /// </param><param> name="validTime" if non-null, is set to false if <code>dt</code> does not occur, or
        ///                   to true otherwise
        /// </param></remarks>        <return> index into the time zone transition list, or -1 either if <code>dt</code> is
        ///          either outside the defined range of the transition data or if <code>dt</code>
        ///          does not occur
        /// </return>
        ///         <short>    Find the index to the last daylight savings time transition at or before  a given UTC or local time.</short>
        ///         <see> transition</see>
        ///         <see> transitions</see>
        ///         <see> hasTransitions</see>
        public int TransitionIndex(QDateTime dt, ref int secondIndex, ref bool validTime) {
            StackItem[] stack = new StackItem[4];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(dt);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(dt);
#endif
            stack[2].s_int = secondIndex;
            stack[3].s_bool = validTime;
            interceptor.Invoke("transitionIndex#$$", "transitionIndex(const QDateTime&, int*, bool*) const", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).SynchronizedFree();
#endif
            secondIndex = stack[2].s_int;
            validTime = stack[3].s_bool;
            return stack[0].s_int;
        }
        public int TransitionIndex(QDateTime dt, ref int secondIndex) {
            StackItem[] stack = new StackItem[3];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(dt);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(dt);
#endif
            stack[2].s_int = secondIndex;
            interceptor.Invoke("transitionIndex#$", "transitionIndex(const QDateTime&, int*) const", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).SynchronizedFree();
#endif
            secondIndex = stack[2].s_int;
            return stack[0].s_int;
        }
        public int TransitionIndex(QDateTime dt) {
            return (int) interceptor.Invoke("transitionIndex#", "transitionIndex(const QDateTime&) const", typeof(int), typeof(QDateTime), dt);
        }
        /// <remarks>
        ///  Return the times of all daylight saving transitions to a given time zone
        ///  phase, in time order. If desired, the times returned may be restricted to
        ///  a specified time range.
        ///  Note that some time zone data sources (such as system time zones accessed
        ///  via the system libraries) may not allow a list of daylight saving time
        ///  changes to be compiled easily. In such cases, this method will return an
        ///  empty list.
        /// <param> name="phase" time zone phase
        /// </param><param> name="start" start UTC date/time, or invalid date/time to return all transitions
        ///               up to <code>end.</code> <code>start.timeSpec</code>() must be Qt.UTC, else
        ///               <code>start</code> will be considered invalid.
        /// </param><param> name="end" end UTC date/time, or invalid date/time for no end. <code>end.timeSpec</code>()
        ///                 must be Qt.UTC, else <code>end</code> will be considered invalid.
        /// </param></remarks>        <return> ordered list of transition times
        /// </return>
        ///         <short>    Return the times of all daylight saving transitions to a given time zone  phase, in time order.</short>
        ///         <see> hasTransitions</see>
        ///         <see> transition</see>
        ///         <see> transitions</see>
        public List<QDateTime> TransitionTimes(KTimeZone.Phase phase, QDateTime start, QDateTime end) {
            return (List<QDateTime>) interceptor.Invoke("transitionTimes###", "transitionTimes(const KTimeZone::Phase&, const QDateTime&, const QDateTime&) const", typeof(List<QDateTime>), typeof(KTimeZone.Phase), phase, typeof(QDateTime), start, typeof(QDateTime), end);
        }
        public List<QDateTime> TransitionTimes(KTimeZone.Phase phase, QDateTime start) {
            return (List<QDateTime>) interceptor.Invoke("transitionTimes##", "transitionTimes(const KTimeZone::Phase&, const QDateTime&) const", typeof(List<QDateTime>), typeof(KTimeZone.Phase), phase, typeof(QDateTime), start);
        }
        public List<QDateTime> TransitionTimes(KTimeZone.Phase phase) {
            return (List<QDateTime>) interceptor.Invoke("transitionTimes#", "transitionTimes(const KTimeZone::Phase&) const", typeof(List<QDateTime>), typeof(KTimeZone.Phase), phase);
        }
        /// <remarks>
        ///  Return all leap second adjustments, in time order.
        ///  Note that some time zone data sources (such as system time zones accessed
        ///  via the system libraries) may not provide information on leap second
        ///  adjustments. In such cases, this method will return an empty list.
        /// </remarks>        <return> list of adjustments
        ///      </return>
        ///         <short>    Return all leap second adjustments, in time order.</short>
        public List<KTimeZone.LeapSeconds> LeapSecondChanges() {
            return (List<KTimeZone.LeapSeconds>) interceptor.Invoke("leapSecondChanges", "leapSecondChanges() const", typeof(List<KTimeZone.LeapSeconds>));
        }
        /// <remarks>
        ///  Returns the source reader/parser for the time zone's source database.
        /// </remarks>        <return> reader/parser
        ///      </return>
        ///         <short>    Returns the source reader/parser for the time zone's source database.</short>
        public KTimeZoneSource Source() {
            return (KTimeZoneSource) interceptor.Invoke("source", "source() const", typeof(KTimeZoneSource));
        }
        /// <remarks>
        ///  Extracts time zone detail information for this time zone from the source database.
        /// </remarks>        <return> @c false if the parse encountered errors, @c true otherwise
        ///      </return>
        ///         <short>    Extracts time zone detail information for this time zone from the source database.</short>
        public bool Parse() {
            return (bool) interceptor.Invoke("parse", "parse() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the detailed parsed data for the time zone.
        ///  This will return null unless either parse() has been called beforehand, or
        ///  <code>create</code> is true.
        /// <param> name="create" true to parse the zone's data first if not already parsed
        /// </param></remarks>        <return> pointer to data, or null if data has not been parsed
        ///      </return>
        ///         <short>    Returns the detailed parsed data for the time zone.</short>
        public KTimeZoneData Data(bool create) {
            return (KTimeZoneData) interceptor.Invoke("data$", "data(bool) const", typeof(KTimeZoneData), typeof(bool), create);
        }
        public KTimeZoneData Data() {
            return (KTimeZoneData) interceptor.Invoke("data", "data() const", typeof(KTimeZoneData));
        }
        /// <remarks>
        ///  Update the definition of the time zone to be identical to another
        ///  KTimeZone instance. A prerequisite is that the two instances must
        ///  have the same name.
        ///  The main purpose of this method is to allow updates of the time zone
        ///  definition by derived classes without invalidating pointers to the
        ///  instance (particularly pointers held by KDateTime objects). Note
        ///  that the KTimeZoneData object and KTimeZoneSource pointer are not
        ///  updated: the caller class should do this itself by calling setData().
        /// <param> name="other" time zone whose definition is to be used
        /// </param></remarks>        <return> true if definition was updated (i.e. names are the same)
        /// </return>
        ///         <short>    Update the definition of the time zone to be identical to another  KTimeZone instance.</short>
        ///         <see> setData</see>
        public bool UpdateBase(KTimeZone other) {
            return (bool) interceptor.Invoke("updateBase#", "updateBase(const KTimeZone&)", typeof(bool), typeof(KTimeZone), other);
        }
        public KTimeZone(KTimeZoneBackend impl) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KTimeZone#", "KTimeZone(KTimeZoneBackend*)", typeof(void), typeof(KTimeZoneBackend), impl);
        }
        /// <remarks>
        ///  Sets the detailed parsed data for the time zone, and optionally
        ///  a new time zone source object.
        /// <param> name="data" parsed data
        /// </param><param> name="source" if non-null, the new source object for the time zone
        /// </param></remarks>        <short>    Sets the detailed parsed data for the time zone, and optionally  a new time zone source object.</short>
        ///         <see> data</see>
        protected void SetData(KTimeZoneData data, KTimeZoneSource source) {
            interceptor.Invoke("setData##", "setData(KTimeZoneData*, KTimeZoneSource*)", typeof(void), typeof(KTimeZoneData), data, typeof(KTimeZoneSource), source);
        }
        protected void SetData(KTimeZoneData data) {
            interceptor.Invoke("setData#", "setData(KTimeZoneData*)", typeof(void), typeof(KTimeZoneData), data);
        }
        ~KTimeZone() {
            interceptor.Invoke("~KTimeZone", "~KTimeZone()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KTimeZone", "~KTimeZone()", typeof(void));
        }
        public static bool operator==(KTimeZone lhs, KTimeZone rhs) {
            return (bool) staticInterceptor.Invoke("operator==#", "operator==(const KTimeZone&) const", typeof(bool), typeof(KTimeZone), lhs, typeof(KTimeZone), rhs);
        }
        public static bool operator!=(KTimeZone lhs, KTimeZone rhs) {
            return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const KTimeZone&) const", typeof(bool), typeof(KTimeZone), lhs, typeof(KTimeZone), rhs);
        }
        /// <remarks>
        ///  Converts a UTC time, measured in seconds since 00:00:00 UTC 1st January 1970
        ///  (as returned by time(2)), to a UTC QDateTime value.
        ///  QDateTime.SetTime_t() is limited to handling <code>t</code> >= 0, since its parameter
        ///  is unsigned. This method takes a parameter of time_t which is signed.
        /// </remarks>        <return> converted time
        /// </return>
        ///         <short>    Converts a UTC time, measured in seconds since 00:00:00 UTC 1st January 1970  (as returned by time(2)), to a UTC QDateTime value.</short>
        ///         <see> toTime_t</see>
        public static QDateTime FromTime_t(int t) {
            return (QDateTime) staticInterceptor.Invoke("fromTime_t$", "fromTime_t(time_t)", typeof(QDateTime), typeof(int), t);
        }
        /// <remarks>
        ///  Converts a UTC QDateTime to a UTC time, measured in seconds since 00:00:00 UTC
        ///  1st January 1970 (as returned by time(2)).
        ///  QDateTime.ToTime_t() returns an unsigned value. This method returns a time_t
        ///  value, which is signed.
        /// <param> name="utcDateTime" date/time. An error occurs if <code>utcDateTime.timeSpec</code>() is
        ///                     not Qt.UTC.
        /// </param></remarks>        <return> converted time, or -1 if the date is out of range for time_t or
        ///          <code>utcDateTime.timeSpec</code>() is not Qt.UTC
        /// </return>
        ///         <short>    Converts a UTC QDateTime to a UTC time, measured in seconds since 00:00:00 UTC  1st January 1970 (as returned by time(2)).</short>
        ///         <see> fromTime_t</see>
        public static int ToTime_t(QDateTime utcDateTime) {
            return (int) staticInterceptor.Invoke("toTime_t#", "toTime_t(const QDateTime&)", typeof(int), typeof(QDateTime), utcDateTime);
        }
        /// <remarks>
        ///  Returns a standard UTC time zone, with name "UTC".
        ///  @note The KTimeZone returned by this method does not belong to any
        ///  KTimeZones collection. Any KTimeZones instance may contain its own UTC
        ///  KTimeZone defined by its time zone source data, but that will be a
        ///  different instance than this KTimeZone.
        /// </remarks>        <return> UTC time zone
        ///      </return>
        ///         <short>    Returns a standard UTC time zone, with name "UTC".</short>
        public static KTimeZone Utc() {
            return (KTimeZone) staticInterceptor.Invoke("utc", "utc()", typeof(KTimeZone));
        }
    }
}
