//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \brief Accessor to the Editor implementation.
    ///  Topics:
    ///   - \ref factory_intro
    ///   - \ref factory_example
    ///   - \ref factory_notes
    ///  \section factory_intro Introduction
    ///  The Factory provides access to the chosen Editor (selected with
    ///  KTextEditor.EditorChooser). The Editor itself then provides methods
    ///  to handle documents and config options.
    ///  To access the Editor use editor().
    ///  Each KTextEditor implementation must reimplement this factory to allow
    ///  access to the editor object.
    ///  \section factory_example Creating an Editor Part
    ///  To get a kate part the following code snippet can be used:
    ///  <pre>
    ///  KLibFactory factory = KLibLoader.Self().Factory("katepart");
    ///  KTextEditor.Factory kte_factory =
    ///      qobject_cast<KTextEditor.Factory>(factory);
    ///  if(kte_factory) {
    ///      // valid editor factory, it is possible to access the editor now
    ///      KTextEditor.Editor editor = kte_factory.Editor();
    ///  } else {
    ///      // error
    ///  }
    ///  </pre>
    ///  If another editor part is desired substitue the string "katepart" with the
    ///  corresponding library name.
    ///  However, if you are only interested in getting the editor part (which is
    ///  usually the case) a simple call of
    ///  <pre>
    ///  KTextEditor.Editor editor = KTextEditor.Editor("katepart");
    ///  </pre>
    ///  is enough.
    ///  \section factory_notes Notes
    ///  It is recommend to use the EditorChooser to get the used editor part. This
    ///  way the user can choose the editor implementation. The Factory itself is
    ///  not needed to get the Editor with the help of the EditorChooser.
    ///  \see KParts.Factory, KTextEditor.Editor
    ///  \author Christoph Cullmann \<cullmann@kde.org\>
    ///  </remarks>        <short>    \brief Accessor to the Editor implementation.</short>
    [SmokeClass("KTextEditor::Factory")]
    public partial class Factory : KParts.Factory, IDisposable {
        protected Factory(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Factory), this);
        }
        /// <remarks>
        ///  Constructor.
        ///  Create a new Factory with <pre>parent</pre>.
        ///  \param parent parent object
        ///      </remarks>        <short>    Constructor.</short>
        public Factory(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Factory#", "Factory(QObject*)", typeof(void), typeof(QObject), parent);
        }
        /// <remarks>
        ///  Get the global Editor object. The editor part implementation \e must
        ///  ensure that this object lives as long as any factory or document
        ///  object exists.
        ///  \return global KTextEditor.Editor object
        ///      </remarks>        <short>    Get the global Editor object.</short>
        [SmokeMethod("editor()")]
        public virtual KTextEditor.Editor Editor() {
            return (KTextEditor.Editor) interceptor.Invoke("editor", "editor()", typeof(KTextEditor.Editor));
        }
        ~Factory() {
            interceptor.Invoke("~Factory", "~Factory()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~Factory", "~Factory()", typeof(void));
        }
    }
}
