/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf.model;

import org.openrdf.model.URI;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.sail.nativerdf.ValueStoreRevision;
import org.openrdf.sail.nativerdf.model.NativeValue;

public class NativeLiteral
extends LiteralImpl
implements NativeValue {
    private static final long serialVersionUID = 5198968663650168819L;
    private ValueStoreRevision revision;
    private int internalID;

    protected NativeLiteral(ValueStoreRevision revision, int internalID) {
        this.setInternalID(internalID, revision);
    }

    public NativeLiteral(ValueStoreRevision revision, String label) {
        this(revision, label, -1);
    }

    public NativeLiteral(ValueStoreRevision revision, String label, int internalID) {
        super(label);
        this.setInternalID(internalID, revision);
    }

    public NativeLiteral(ValueStoreRevision revision, String label, String lang) {
        this(revision, label, lang, -1);
    }

    public NativeLiteral(ValueStoreRevision revision, String label, String lang, int internalID) {
        super(label, lang);
        this.setInternalID(internalID, revision);
    }

    public NativeLiteral(ValueStoreRevision revision, String label, URI datatype) {
        this(revision, label, datatype, -1);
    }

    public NativeLiteral(ValueStoreRevision revision, String label, URI datatype, int internalID) {
        super(label, datatype);
        this.setInternalID(internalID, revision);
    }

    public void setInternalID(int internalID, ValueStoreRevision revision) {
        this.internalID = internalID;
        this.revision = revision;
    }

    public ValueStoreRevision getValueStoreRevision() {
        return this.revision;
    }

    public int getInternalID() {
        return this.internalID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NativeLiteral && this.internalID != -1) {
            NativeLiteral otherNativeLiteral = (NativeLiteral)o;
            if (otherNativeLiteral.internalID != -1 && this.revision.equals(otherNativeLiteral.revision)) {
                return this.internalID == otherNativeLiteral.internalID;
            }
        }
        return super.equals(o);
    }
}

