/*
 * Check pam_debug return values.
 *
 * Copyright (c) 2020 Dmitry V. Levin <ldv@altlinux.org>
 */

#include "test_assert.h"

#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <security/pam_appl.h>

#define MODULE_NAME "pam_debug"
#define TEST_NAME "tst-" MODULE_NAME "-retval"

static const char service_file[] = TEST_NAME ".service";
static const char user_name[] = "";
static const char args[] = " auth=perm_denied"
			   " cred=cred_unavail"
			   " acct=acct_expired"
			   " prechauthtok=success"
			   " chauthtok=service_err"
			   " open_session=buf_err"
			   " close_session=system_err";
static struct pam_conv conv;

int
main(void)
{
	pam_handle_t *pamh = NULL;
	FILE *fp;
	char cwd[PATH_MAX];

	ASSERT_NE(NULL, getcwd(cwd, sizeof(cwd)));

	ASSERT_NE(NULL, fp = fopen(service_file, "w"));
	ASSERT_LT(0, fprintf(fp, "#%%PAM-1.0\n"
			     "auth required %s/.libs/%s.so %s\n"
			     "account required %s/.libs/%s.so %s\n"
			     "password required %s/.libs/%s.so %s\n"
			     "session required %s/.libs/%s.so %s\n",
			     cwd, MODULE_NAME, args,
			     cwd, MODULE_NAME, args,
			     cwd, MODULE_NAME, args,
			     cwd, MODULE_NAME, args));
	ASSERT_EQ(0, fclose(fp));

	ASSERT_EQ(PAM_SUCCESS,
		  pam_start_confdir(service_file, user_name, &conv, ".", &pamh));
	ASSERT_NE(NULL, pamh);
	ASSERT_EQ(PAM_PERM_DENIED, pam_authenticate(pamh, 0));
	ASSERT_EQ(PAM_CRED_UNAVAIL, pam_setcred(pamh, 0));
	ASSERT_EQ(PAM_ACCT_EXPIRED, pam_acct_mgmt(pamh, 0));
	ASSERT_EQ(PAM_SERVICE_ERR, pam_chauthtok(pamh, 0));
	ASSERT_EQ(PAM_BUF_ERR, pam_open_session(pamh, 0));
	ASSERT_EQ(PAM_SYSTEM_ERR, pam_close_session(pamh, 0));
	ASSERT_EQ(PAM_SUCCESS, pam_end(pamh, 0));
	pamh = NULL;

	ASSERT_EQ(0, unlink(service_file));

	return 0;
}
