; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O2 -mtriple armv7a < %s | FileCheck --check-prefixes=ARM %s

; RUN: llc -O2 -mtriple thumbv6m < %s | FileCheck --check-prefixes=THUMBV6M %s
; RUN: llc -O2 -mtriple thumbv8m.base < %s | FileCheck --check-prefixes=THUMBV8M-BASE %s

; RUN: llc -O2 -mtriple thumbv7a < %s | FileCheck --check-prefixes=THUMB %s
; RUN: llc -O2 -mtriple thumbv8m.main < %s | FileCheck --check-prefixes=THUMB %s

define void @fn1(i32 %a, i32 %b, i32 %c) local_unnamed_addr #0 {
; ARM-LABEL: fn1:
; ARM:       @ %bb.0: @ %entry
; ARM-NEXT:    rsb r2, r2, #0
; ARM-NEXT:    adds r0, r1, r0
; ARM-NEXT:    movw r1, #65535
; ARM-NEXT:    sxth r2, r2
; ARM-NEXT:    adc r0, r2, #0
; ARM-NEXT:    uxth r0, r0
; ARM-NEXT:    cmp r0, r1
; ARM-NEXT:    bxeq lr
; ARM-NEXT:  .LBB0_1: @ %for.cond
; ARM-NEXT:    @ =>This Inner Loop Header: Depth=1
; ARM-NEXT:    b .LBB0_1
;
; THUMBV6M-LABEL: fn1:
; THUMBV6M:       @ %bb.0: @ %entry
; THUMBV6M-NEXT:    rsbs r2, r2, #0
; THUMBV6M-NEXT:    sxth r2, r2
; THUMBV6M-NEXT:    movs r3, #0
; THUMBV6M-NEXT:    adds r0, r1, r0
; THUMBV6M-NEXT:    adcs r3, r2
; THUMBV6M-NEXT:    uxth r0, r3
; THUMBV6M-NEXT:    ldr r1, .LCPI0_0
; THUMBV6M-NEXT:    cmp r0, r1
; THUMBV6M-NEXT:    beq .LBB0_2
; THUMBV6M-NEXT:  .LBB0_1: @ %for.cond
; THUMBV6M-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMBV6M-NEXT:    b .LBB0_1
; THUMBV6M-NEXT:  .LBB0_2: @ %if.end
; THUMBV6M-NEXT:    bx lr
; THUMBV6M-NEXT:    .p2align 2
; THUMBV6M-NEXT:  @ %bb.3:
; THUMBV6M-NEXT:  .LCPI0_0:
; THUMBV6M-NEXT:    .long 65535 @ 0xffff
;
; THUMBV8M-BASE-LABEL: fn1:
; THUMBV8M-BASE:       @ %bb.0: @ %entry
; THUMBV8M-BASE-NEXT:    rsbs r2, r2, #0
; THUMBV8M-BASE-NEXT:    sxth r2, r2
; THUMBV8M-BASE-NEXT:    movs r3, #0
; THUMBV8M-BASE-NEXT:    adds r0, r1, r0
; THUMBV8M-BASE-NEXT:    adcs r3, r2
; THUMBV8M-BASE-NEXT:    uxth r0, r3
; THUMBV8M-BASE-NEXT:    movw r1, #65535
; THUMBV8M-BASE-NEXT:    cmp r0, r1
; THUMBV8M-BASE-NEXT:    beq .LBB0_2
; THUMBV8M-BASE-NEXT:  .LBB0_1: @ %for.cond
; THUMBV8M-BASE-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMBV8M-BASE-NEXT:    b .LBB0_1
; THUMBV8M-BASE-NEXT:  .LBB0_2: @ %if.end
; THUMBV8M-BASE-NEXT:    bx lr
;
; THUMB-LABEL: fn1:
; THUMB:       @ %bb.0: @ %entry
; THUMB-NEXT:    rsbs r2, r2, #0
; THUMB-NEXT:    adds r0, r0, r1
; THUMB-NEXT:    movw r1, #65535
; THUMB-NEXT:    sxth r2, r2
; THUMB-NEXT:    adc r0, r2, #0
; THUMB-NEXT:    uxth r0, r0
; THUMB-NEXT:    cmp r0, r1
; THUMB-NEXT:    it eq
; THUMB-NEXT:    bxeq lr
; THUMB-NEXT:  .LBB0_1: @ %for.cond
; THUMB-NEXT:    @ =>This Inner Loop Header: Depth=1
; THUMB-NEXT:    b .LBB0_1
entry:
  %add = add i32 %b, %a
  %cmp = icmp ult i32 %add, %b
  %conv = zext i1 %cmp to i32
  %sub = sub i32 1, %c
  %add1 = add i32 %sub, %conv
  %conv2 = trunc i32 %add1 to i16
  %tobool = icmp eq i16 %conv2, 0
  br i1 %tobool, label %if.end, label %for.cond.preheader

for.cond.preheader:                               ; preds = %entry
  br label %for.cond

for.cond:                                         ; preds = %for.cond.preheader, %for.cond
  br label %for.cond

if.end:                                           ; preds = %entry
  ret void
}
