/* License: GPL
 *
 * Preliminary hack to change channels on ivtv driver
 *
 * Author: Kevin Thayer <nufan_wfk at yahoo dot com>
 *
 * Enjoy :)
 */

#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <linux/videodev.h>
#include <fcntl.h>

#define VIDIOC_S_FREQUENCY2 0x402c5639

enum v4l2_tuner_type2 {
        V4L2_TUNER_RADIO             = 1,
        V4L2_TUNER_ANALOG_TV         = 2,
};

struct v4l2_frequency2
{
        __u32                 tuner;
        enum v4l2_tuner_type2  type;
        __u32                 frequency;
        __u32                 reserved[8];
};

unsigned long NTSC_BCAST[] = {
      2,	 55250,
      3,	 61250,
      4,	 67250,
      5,	 77250,
      6,	 83250,
      7,	175250,
      8,	181250,
      9,	187250,
      10,	193250,
      11,	199250,
      12,	205250,
      13,	211250,
      14,	471250,
      15,	477250,
      16,	483250,
      17,	489250,
      18,	495250,
      19,	501250,
      20,	507250,
      21,	513250,
      22,	519250,
      23,	525250,
      24,	531250,
      25,	537250,
      26,	543250,
      27,	549250,
      28,	555250,
      29,	561250,
      30,	567250,
      31,	573250,
      32,	579250,
      33,	585250,
      34,	591250,
      35,	597250,
      36,	603250,
      37,	609250,
      38,	615250,
      39,	621250,
      40,	627250,
      41,	633250,
      42,	639250,
      43,	645250,
      44,	651250,
      45,	657250,
      46,	663250,
      47,	669250,
      48,	675250,
      49,	681250,
      50,	687250,
      51,	693250,
      52,	699250,
      53,	705250,
      54,	711250,
      55,	717250,
      56,	723250,
      57,	729250,
      58,	735250,
      59,	741250,
      60,	747250,
      61,	753250,
      62,	759250,
      63,	765250,
      64,	771250,
      65,	777250,
      66,	783250,
      67,	789250,
      68,	795250,
      69,	801250,

      70,	807250,
      71,	813250,
      72,	819250,
      73,	825250,
      74,	831250,
      75,	837250,
      76,	843250,
      77,	849250,
      78,	855250,
      79,	861250,
      80,	867250,
      81,	873250,
      82,	879250,
      83,	885250,
	0,	0
};

unsigned long NTSC_CABLE[] = {
      1,	 73250,
      2,	 55250,
      3,	 61250,
      4,	 67250,
      5,	 77250,
      6,	 83250,
      7,	175250,
      8,	181250,
      9,	187250,
      10,	193250,
      11,	199250,
      12,	205250,

      13,	211250,
      14,	121250,
      15,	127250,
      16,	133250,
      17,	139250,
      18,	145250,
      19,	151250,
      20,	157250,

      21,	163250,
      22,	169250,
      23,	217250,
      24,	223250,
      25,	229250,
      26,	235250,
      27,	241250,
      28,	247250,
      29,	253250,
      30,	259250,
      31,	265250,
      32,	271250,
      33,	277250,
      34,	283250,
      35,	289250,
      36,	295250,
      37,	301250,
      38,	307250,
      39,	313250,
      40,	319250,
      41,	325250,
      42,	331250,
      43,	337250,
      44,	343250,
      45,	349250,
      46,	355250,
      47,	361250,
      48,	367250,
      49,	373250,
      50,	379250,
      51,	385250,
      52,	391250,
      53,	397250,
      54,	403250,
      55,	409250,
      56,	415250,
      57,	421250,
      58,	427250,
      59,	433250,
      60,	439250,
      61,	445250,
      62,	451250,
      63,	457250,
      64,	463250,
      65,	469250,
      66,	475250,
      67,	481250,
      68,	487250,
      69,	493250,

      70,	499250,
      71,	505250,
      72,	511250,
      73,	517250,
      74,	523250,
      75,	529250,
      76,	535250,
      77,	541250,
      78,	547250,
      79,	553250,
      80,	559250,
      81,	565250,
      82,	571250,
      83,	577250,
      84,	583250,
      85,	589250,
      86,	595250,
      87,	601250,
      88,	607250,
      89,	613250,
      90,	619250,
      91,	625250,
      92,	631250,
      93,	637250,
      94,	643250,
      95,	 91250,
      96,	 97250,
      97,	103250,
      98,	109250,
      99,	115250,
      100,	649250,
      101,	655250,
      102,	661250,
      103,	667250,
      104,	673250,
      105,	679250,
      106,	685250,
      107,	691250,
      108,	697250,
      109,	703250,
      110,	709250,
      111,	715250,
      112,	721250,
      113,	727250,
      114,	733250,
      115,	739250,
      116,	745250,
      117,	751250,
      118,	757250,
      119,	763250,
      120,	769250,
      121,	775250,
      122,	781250,
      123,	787250,
      124,	793250,
      125,	799250,
	0,	0
};

unsigned long NTSC_HRC[] = {
      1,	  72000,
      2,	  54000,
      3,	  60000,
      4,	  66000,
      5,	  78000,
      6,	  84000,
      7,	 174000,
      8,	 180000,
      9,	 186000,
      10,	 192000,
      11,	 198000,
      12,	 204000,

      13,	 210000,
      14,	 120000,
      15,	 126000,
      16,	 132000,
      17,	 138000,
      18,	 144000,
      19,	 150000,
      20,	 156000,

      21,	 162000,
      22,	 168000,
      23,	 216000,
      24,	 222000,
      25,	 228000,
      26,	 234000,
      27,	 240000,
      28,	 246000,
      29,	 252000,
      30,	 258000,
      31,	 264000,
      32,	 270000,
      33,	 276000,
      34,	 282000,
      35,	 288000,
      36,	 294000,
      37,	 300000,
      38,	 306000,
      39,	 312000,
      40,	 318000,
      41,	 324000,
      42,	 330000,
      43,	 336000,
      44,	 342000,
      45,	 348000,
      46,	 354000,
      47,	 360000,
      48,	 366000,
      49,	 372000,
      50,	 378000,
      51,	 384000,
      52,	 390000,
      53,	 396000,
      54,	 402000,
      55,	 408000,
      56,	 414000,
      57,	 420000,
      58,	 426000,
      59,	 432000,
      60,	 438000,
      61,	 444000,
      62,	 450000,
      63,	 456000,
      64,	 462000,
      65,	 468000,
      66,	 474000,
      67,	 480000,
      68,	 486000,
      69,	 492000,

      70,	 498000,
      71,	 504000,
      72,	 510000,
      73,	 516000,
      74,	 522000,
      75,	 528000,
      76,	 534000,
      77,	 540000,
      78,	 546000,
      79,	 552000,
      80,	 558000,
      81,	 564000,
      82,	 570000,
      83,	 576000,
      84,	 582000,
      85,	 588000,
      86,	 594000,
      87,	 600000,
      88,	 606000,
      89,	 612000,
      90,	 618000,
      91,	 624000,
      92,	 630000,
      93,	 636000,
      94,	 642000,
      95,	 900000,
      96,	 960000,
      97,	 102000,
      98,	 108000,
      99,	 114000,
      100,	 648000,
      101,	 654000,
      102,	 660000,
      103,	 666000,
      104,	 672000,
      105,	 678000,
      106,	 684000,
      107,	 690000,
      108,	 696000,
      109,	 702000,
      110,	 708000,
      111,	 714000,
      112,	 720000,
      113,	 726000,
      114,	 732000,
      115,	 738000,
      116,	 744000,
      117,	 750000,
      118,	 756000,
      119,	 762000,
      120,	 768000,
      121,	 774000,
      122,	 780000,
      123,	 786000,
      124,	 792000,
      125,	 798000,
	0,	0
};

unsigned long NTSC_BCAST_JP[] = {
      1,   91250,
      2,   97250,
      3,  103250,
      4,  171250,
      5,  177250,
      6,  183250,
      7,  189250,
      8,  193250,
      9,  199250,
      10, 205250,
      11, 211250,
      12, 217250,

      13, 471250,
      14, 477250,
      15, 483250,
      16, 489250,
      17, 495250,
      18, 501250,
      19, 507250,
      20, 513250,
      21, 519250,
      22, 525250,
      23, 531250,
      24, 537250,
      25, 543250,
      26, 549250,
      27, 555250,
      28, 561250,
      29, 567250,
      30, 573250,
      31, 579250,
      32, 585250,
      33, 591250,
      34, 597250,
      35, 603250,
      36, 609250,
      37, 615250,
      38, 621250,
      39, 627250,
      40, 633250,
      41, 639250,
      42, 645250,
      43, 651250,
      44, 657250,

      45, 663250,
      46, 669250,
      47, 675250,
      48, 681250,
      49, 687250,
      50, 693250,
      51, 699250,
      52, 705250,
      53, 711250,
      54, 717250,
      55, 723250,
      56, 729250,
      57, 735250,
      58, 741250,
      59, 747250,
      60, 753250,
      61, 759250,
      62, 765250,
	0,	0
};

unsigned long NTSC_CABLE_JP[] = {
      13,	109250,
      14,	115250,
      15,	121250,
      16,	127250,
      17,	133250,
      18,	139250,
      19,	145250,
      20,	151250,

      21,	157250,
      22,	165250,
      23,	223250,
      24,	231250,
      25,	237250,
      26,	243250,
      27,	249250,
      28,	253250,
      29,	259250,
      30,	265250,
      31,	271250,
      32,	277250,
      33,	283250,
      34,	289250,
      35,	295250,
      36,	301250,
      37,	307250,
      38,	313250,
      39,	319250,
      40,	325250,
      41,	331250,
      42,	337250,
      43,	343250,
      44,	349250,
      45, 	355250,
      46, 	361250,
      47, 	367250,
      48, 	373250,
      49, 	379250,
      50, 	385250,
      51, 	391250,
      52, 	397250,
      53, 	403250,
      54, 	409250,
      55, 	415250,
      56, 	421250,
      57, 	427250,
	0,	0
};
int main(int argc, char *argv[]) {
	int fd, retval;
	unsigned long chann,freq, c, f, *array;
	struct v4l2_frequency2 vf;

	/* Pick your TV standard here! */
	array = NTSC_BCAST;
	
	if (argc != 2) {
		printf("Usage: %s <channel>\n", argv[0]);
		return -1;
	}	
	
	fd = open("/dev/video0", O_RDONLY);
	if (fd < 0) {
		printf("Couldn't open file\n");
		return -1;
	}

	chann = (unsigned long)atol(argv[1]);
	
	freq = 0;
	while (*array != 0) {
		c = *(array++);
		f = *(array++);
		if (chann == c) {
			printf("found channel %d at %d\n", c, f);
			freq = (int)((f*16)/1000); /* was /1000 */
			break;
		}
	}

	if (freq == 0) {
		printf("channel %d invalid or not found in this standard\n",chann);
		return -1;
	}
	
	vf.tuner = 0;
	vf.frequency = freq;
        retval = ioctl(fd, VIDIOC_S_FREQUENCY2, &vf);

	if (retval)
		printf("ioctl dinna work\n");
	else
		printf("ioctl worked!\n");
	
	return 0;
}

