#include "gradm.h"

static void
compute_cap_creds(struct proc_acl *set, struct proc_acl *cmp)
{
	__u32 cap_same;

	set->cap_raise |= cmp->cap_raise;
	set->cap_drop |= cmp->cap_drop;

	cap_same = set->cap_raise & cmp->cap_drop;
	set->cap_raise &= ~cap_same;
	set->cap_drop &= ~cap_same;
	cap_same = set->cap_drop & cmp->cap_raise;
	set->cap_drop &= ~cap_same;
	set->cap_raise &= ~cap_same;

	return;
}

static void
expand_acl(struct proc_acl *proc)
{
	char *tmpproc;
	struct proc_acl *tmpp;
	struct file_acl *tmpf1;
	struct file_acl *tmpf2;

	if ((tmpproc =
	     calloc(strlen(proc->filename) + 1, sizeof (char))) == NULL)
		failure("calloc");

	strcpy(tmpproc, proc->filename);

	while (parent_dir(proc->filename, &tmpproc)) {
		for_each_subject(tmpp, def_acl_tmp) {
			if (!strcmp(tmpproc, tmpp->filename)) {
				compute_cap_creds(proc, tmpp);	// perform capability inheritance
				for_each_object(tmpf1, tmpp->proc_object) {
					for_each_object(tmpf2,
							proc->proc_object)
					    if (!strcmp
						(tmpf1->filename,
						 tmpf2->filename))
						break;
					if (!tmpf2)	// not found in current subject
						add_proc_object_acl(&proc->
								    proc_object,
								    tmpf1->
								    filename,
								    tmpf1->mode,
								    GR_FEXIST | GR_GLOB | GR_SYMLINK);
				}
			}
		}
	}

	free(tmpproc);
	return;
}

void
expand_acls(void)
{
	struct proc_acl *proc;

	for_each_subject(proc, def_acl_tmp) {
		if (!(proc->mode & GR_OVERRIDE) && strcmp(proc->filename, "/"))
			expand_acl(proc);
		else {
			proc->mode &= ~GR_OVERRIDE;
			compute_cap_creds(proc, proc);
		}
	}

	return;
}
