/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Enterprise Fibre Channel Host Bus Adapters.                     *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003 Emulex Corporation.                          *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/

#ifndef _H_FCOS
#define _H_FCOS

#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/blk.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/version.h>
#define LinuxVersionCode(v, p, s) (((v)<<16)+((p)<<8)+(s))
#endif /* __KERNEL__ */


#ifdef LP6000
#ifdef __KERNEL__
/* From drivers/scsi */
#include "sd.h"   
#include "hosts.h"

/* The driver is comditionally compiled to utilize the old scsi error
 * handling logic, or the make use of the new scsi logic (use_new_eh_code).
 * To use the old error handling logic, delete the line "#define FC_NEW_EH 1".
 * To use the new error handling logic, add the line "#define FC_NEW_EH 1".
 *
 * #define FC_NEW_EH    1
 */

/* Turn on new error handling for 2.4 kernel base and on */
#if LINUX_VERSION_CODE >= LinuxVersionCode(2,3,43)
#define FC_NEW_EH   1
#endif

#endif /* __KERNEL__ */

#ifndef __KERNEL__
struct net_device_stats
{
    unsigned long   rx_packets;     /* total packets received   */
    unsigned long   tx_packets;     /* total packets transmitted    */
    unsigned long   rx_bytes;       /* total bytes received     */
    unsigned long   tx_bytes;       /* total bytes transmitted  */
    unsigned long   rx_errors;      /* bad packets received     */
    unsigned long   tx_errors;      /* packet transmit problems */
    unsigned long   rx_dropped;     /* no space in linux buffers    */
    unsigned long   tx_dropped;     /* no space available in linux  */
    unsigned long   multicast;      /* multicast packets received   */
    unsigned long   collisions;

    /* detailed rx_errors: */
    unsigned long   rx_length_errors;
    unsigned long   rx_over_errors;     /* receiver ring buff overflow  */
    unsigned long   rx_crc_errors;      /* recved pkt with crc error    */
    unsigned long   rx_frame_errors;    /* recv'd frame alignment error */
    unsigned long   rx_fifo_errors;     /* recv'r fifo overrun      */
    unsigned long   rx_missed_errors;   /* receiver missed packet   */

    /* detailed tx_errors */
    unsigned long   tx_aborted_errors;
    unsigned long   tx_carrier_errors;
    unsigned long   tx_fifo_errors;
    unsigned long   tx_heartbeat_errors;
    unsigned long   tx_window_errors;
    
    /* for cslip etc */
    unsigned long   rx_compressed;
    unsigned long   tx_compressed;
};
#define enet_statistics net_device_stats
#endif /* __KERNEL__ */

typedef unsigned char   uchar;
/* both ushort and ulong may be defined*/

#ifndef __KERNEL__
#ifndef _SYS_TYPES_H
typedef unsigned short  ushort;
typedef unsigned long   ulong; 
#endif
#endif /* __KERNEL__ */


#define SELTO_TIMEOUT p_dev_ctl->selto_timeout

#define _local_    static
#define _static_   
#define _forward_  extern

typedef unsigned short  uint16;
typedef unsigned int    uint32;
typedef long long       uint64;
#ifdef __KERNEL__
#if LINUX_VERSION_CODE < LinuxVersionCode(2,2,18)
typedef unsigned long   dma_addr_t;
#endif
#endif

#if BITS_PER_LONG > 32
/* These macros are for 64 bit support */
#define putPaddrLow(addr)    ((uint32) \
(0xffffffff & (unsigned long)(addr)))
#define putPaddrHigh(addr)   ((uint32) \
 (0xffffffff & (((unsigned long)(addr))>>32)))
#define getPaddr(high, low)  ((unsigned long) \
  ((((unsigned long) (high)) << 32)|((unsigned long)(low))))

#else
/* Macro's to support 32 bit addressing */
#define putPaddrLow(addr)       ((uint32)(addr))
#define putPaddrHigh(addr)      0
#define getPaddr(high, low)     ((uint32)(low))
#endif 

/* Macro to get from adapter number to ddi instance */
#define fc_brd_to_inst(brd)  fcinstance[brd]

#define DELAYMS(ms) lpfc_DELAYMS(p_dev_ctl, ms)
#define DELAYMSctx(ms) lpfc_DELAYMS(p_dev_ctl, ms)

#define EXPORT_LINUX 1

#ifdef CONFIG_PPC64
#define powerpc
#endif

#ifdef powerpc
#define LITTLE_ENDIAN_HOST 0  /* For fc.h */
#define BIG_ENDIAN_HW      1  /* For fc_hw.h */
#else
#define LITTLE_ENDIAN_HOST 1  /* For fc.h */
#define LITTLE_ENDIAN_HW   1  /* For fc_hw.h */
#endif  /* powerpc */

#define MACADDR_LEN     6               /* MAC network address length */
#define FC_LVL          0
#define CLK_LVL         0
#define EVENT_NULL      (-1)
#define DMA_READ        1         /* flag argument to D_MAP_LIST */
#ifndef NULL                     /* define NULL if not defined*/
#define NULL (0)
#endif
#define FALSE           0
#define TRUE            1
#define DFC_IOCTL       1

/* Return value for PCI interrupt routine */
#define INTR_SUCC       1  /* Claimed interrupt, detected work to do */
#define INTR_FAIL       0  /* Doesn't claim interrupt */


#define con_print(s, a, b)  \
 fc_print(s, (void *)((ulong)a), (void *)((ulong)b))


/* These calls are used before, and after, access to a shared memory
 * access to the adapter.
 */
#define FC_MAP_MEM(p1) (void *) (*(p1)) /* sigh     */
#define FC_MAP_IO(p1)  (void *) (*(p1)) /* sigh     */
#define FC_UNMAP_MEMIO(p1)      /* groan    */

#define fc_mpdata_outcopy(p, m, d, c)    fc_bcopy((m)->virt, d, c)
#define fc_mpdata_incopy(p, m, s, c)     fc_bcopy(s, (m)->virt, c)
#define fc_mpdata_sync(h, a, b, c)     lpfc_mpdata_sync(p_dev_ctl, h, a, b, c)

#define DDI_DMA_SYNC_FORKERNEL 1
#define DDI_DMA_SYNC_FORCPU    1
#define DDI_DMA_SYNC_FORDEV    2

/* This call is used to wakeup someone waiting to send a SCSI
 * administrative command to the drive, only one outstanding
 * command can be sent to each device.
 */
#define  fc_admin_wakeup(p, d, bp)

#define lpfc_restart_device(dev_ptr)
#define lpfc_handle_fcp_error(p_pkt, p_fcptr, p_cmd) \
        lpfc_fcp_error(p_fcptr, p_cmd)
#define STAT_ABORTED 0          
 
struct watchdog {
   void         (*func)(void *);      /* completion handler */
   uint32       restart;        /* restart time (in seconds) */
   uint32       count;          /* time remaining */
   ulong        timeout_id;
   struct       timer_list timer;
   int          stopping; 
};

#define ntimerisset(p1) (*(p1))
#define ntimerclear(p1) (*(p1) = 0)
#define ntimercmp(p1, p2, cmp) ((p1) cmp (p2))


/* This is the dio and d_iovec structures for the d_map_* services */
typedef struct d_iovec {
   void *stub;
} *d_iovec_t;

struct dio {
   void *stub;
};
typedef struct dio *   dio_t;

#ifdef __KERNEL__
#if LINUX_VERSION_CODE < LinuxVersionCode(2,3,43)
#define pci_map_single(dev, address, size, direction)       virt_to_bus(address)
#define pci_unmap_single(dev, address, size, direction)
#define pci_alloc_consistent(dev, s, h)   fc_pci_alloc_consistent(dev, s, h)
#define pci_free_consistent(dev, s, v, h) fc_pci_free_consistent(dev, s, v, h)
#define scsi_sg_dma_address(sc)         virt_to_bus((sc)->address)
#define scsi_sg_dma_len(sc)             ((sc)->length)
typedef struct wait_queue *WAIT_QUEUE;
#else
#define scsi_sg_dma_address(sc)         sg_dma_address(sc)
#define scsi_sg_dma_len(sc)             sg_dma_len(sc)
typedef wait_queue_head_t WAIT_QUEUE;
#endif

#if LINUX_VERSION_CODE >= LinuxVersionCode(2,3,17)
#define  NETDEVICE struct net_device
#else
#define  NETDEVICE struct device
#endif

#if LINUX_VERSION_CODE < LinuxVersionCode(2,3,43)
#define netif_start_queue(dev)  clear_bit(0, (void*)&dev->tbusy)
#define netif_stop_queue(dev)   set_bit(0, (void*)&dev->tbusy)
#define netdevice_start(dev)    dev->start = 1
#define netdevice_stop(dev) dev->start = 0
#define dev_kfree_skb_irq(a)    dev_kfree_skb(a)
#else
#define netdevice_start(dev)
#define netdevice_stop(dev)
#endif

#else
#define  NETDEVICE void
#endif

struct intr {
   int                  (*handler) (struct intr *);
   NETDEVICE    *   lpfn_dev;
   int              (*lpfn_handler) (void);
   int                          lpfn_mtu;
   int                          lpfn_rcv_buf_size;
};
typedef struct sk_buff fcipbuf_t;

#define fcnextpkt(x)    ((x)->prev) /* FOR Now */
#define fcnextdata(x)   ((x)->next)
#define fcpktlen(x) ((x)->len) /* Assume 1 skbuff per packet */
#define fcdata(x)   ((x)->data)
#define fcdatalen(x)    ((x)->len)
#define fcgethandle(x)  0

#define fcsetdatalen(x, l)  (((x)->len) = l)
#define fcincdatalen(x, l)  (((x)->len) += l)
#define fcsethandle(x, h)
#define fcfreehandle(p,x)

#define m_getclust(a,b)         lpfc_alloc_skb(p_dev_ctl->ihs.lpfn_rcv_buf_size)
#define m_getclustm(a,b,c)      lpfc_alloc_skb(c)
#define m_freem(x)              lpfc_kfree_skb(x);

#define FC_RCV_BUF_SIZE   lpfc_ip_rcvsz(p_dev_ctl)  /* rcv buf size for IP */

#define enet_statistics net_device_stats
/* Structure for generic statistics */
typedef struct ndd_genstats {
   struct enet_statistics ndd_enet; 
   uint32  ndd_elapsed_time;    /* time in seconds since last reset */
   uint32  ndd_ipackets_msw;    /* packets received on interface(msw) */
   uint32  ndd_ibytes_msw;      /* total # of octets received(msw) */
   uint32  ndd_recvintr_msw;    /* number of receive interrupts(msw) */
   uint32  ndd_recvintr_lsw;    /* number of receive interrupts(lsw) */
   uint32  ndd_opackets_msw;    /* packets sent on interface(msw) */
   uint32  ndd_obytes_msw;      /* total number of octets sent(msw) */
   uint32  ndd_xmitintr_msw;    /* number of transmit interrupts(msw) */
   uint32  ndd_xmitintr_lsw;    /* number of transmit interrupts(lsw) */
   uint32  ndd_nobufs;          /* no buffers available */
   uint32  ndd_xmitque_max;     /* max transmits ever queued */
   uint32  ndd_xmitque_ovf;     /* number of transmit queue overflows */
   uint32  ndd_ibadpackets;     /* # of bad pkts recv'd from adapter */
   uint32  ndd_xmitque_cur;        /* sum of driver+adapter xmit queues */
   uint32  ndd_ifOutUcastPkts_msw; /* outbound unicast pkts requested */
   uint32  ndd_ifOutUcastPkts_lsw; /* on interface (msw and lsw) */
   uint32  ndd_ifOutMcastPkts_msw; /* outbound multicast pkts requested */
   uint32  ndd_ifOutMcastPkts_lsw; /* on interface (msw and lsw) */
   uint32  ndd_ifOutBcastPkts_msw; /* outbound broadcast pkts requested */
   uint32  ndd_ifOutBcastPkts_lsw; /* on interface (msw and lsw) */
   uint32  ndd_ifInBcastPkts_msw; /* rcv'ed broadcast pkts requested */
   uint32  ndd_ifInBcastPkts_lsw; /* on interface (msw and lsw) */
} ndd_genstats_t;

#define  ndd_ipackets_lsw ndd_enet.rx_packets
#define  ndd_opackets_lsw ndd_enet.tx_packets
#define  ndd_ibytes_lsw ndd_enet.rx_bytes
#define  ndd_obytes_lsw ndd_enet.tx_bytes
#define  ndd_ipackets_drop ndd_enet.rx_dropped
#define  ndd_opackets_drop ndd_enet.tx_dropped
#define  ndd_ierrors ndd_enet.rx_errors
#define  ndd_oerrors ndd_enet.tx_errors

typedef struct ndd {
   char    *ndd_name;              /* name, e.g. ``en0'' or ``tr0'' */
   char    *ndd_alias;             /* alternate name */
   uint32  ndd_flags;              /* up/down, broadcast, etc. */
#define NDD_UP          (0x00000001)  /* NDD is opened */
#define NDD_BROADCAST   (0x00000002)  /* broadcast address valid */
#define NDD_RUNNING     (0x00000008)  /* NDD is operational */
#define NDD_SIMPLEX     (0x00000010)  /* can't hear own transmissions */
#define NDD_MULTICAST   (0x00000200)  /* receiving all multicasts */
   void    (*nd_receive)(void *, struct sk_buff *, void *);  /* DLPI streams receive function */
   struct ndd_genstats ndd_genstats;  /* generic network stats */
} ndd_t;

struct lpfn_probe {
    int         (*open)(NETDEVICE *dev);
    int         (*stop)(NETDEVICE *dev);
    int         (*hard_start_xmit) (struct sk_buff *skb, NETDEVICE *dev);
    int         (*hard_header) (struct sk_buff *skb,
                        NETDEVICE *dev,
                        unsigned short type,
                        void *daddr,
                        void *saddr,
                        unsigned len);
    int         (*rebuild_header)(struct sk_buff *skb);
    void            (*receive)(ndd_t *p_ndd, struct sk_buff *skb, void *p_dev_ctl);
    struct net_device_stats* (*get_stats)(NETDEVICE *dev);
    int             (*change_mtu)(NETDEVICE *dev, int new_mtu);
};
#define LPFN_PROBE  1
#define LPFN_DETACH 2
#define LPFN_DFC    3

struct buf {
        void    *av_forw;
        void    *av_back;
        int     b_bcount;               /* transfer count */
        int     b_error;                /* expanded error field */
        int     b_resid;                /* words not transferred after error */
        int     b_flags;                /* see defines below */
#define B_ERROR         0x0004  /* transaction aborted */
#define B_READ          0x0040  /* read when I/O occurs */
#define B_WRITE         0x0100  /* non-read pseudo-flag */
  Scsi_Cmnd *cmnd;
  int isdone;
};

/* refer to the SCSI ANSI X3.131-1986 standard for information */
struct sc_cmd {                 /* structure of the SCSI cmd block */
   uchar   scsi_op_code;   /* first byte of SCSI cmd block */
   uchar   lun;            /* second byte of SCSI cmd block */
   uchar   scsi_bytes[14]; /* other bytes of SCSI cmd block */
};
#define SCSI_RELEASE_UNIT                       0x17
#define SCSI_REQUEST_SENSE                      0x03
#define SCSI_RESERVE_UNIT                       0x16

struct scsi {
   uchar   scsi_length;    /* byte length of scsi cmd (6,10, or 12) */
   uchar   scsi_id;        /* the target SCSI ID */
   uchar   scsi_lun;       /* which LUN on the target */
   uchar   flags;          /* flags for use with the physical scsi command */
#define SC_NODISC       0x80    /* don't allow disconnections */
#define SC_ASYNC        0x08    /* asynchronous data xfer */
   struct sc_cmd scsi_cmd; /* the actual SCSI cmd */
};

struct sc_buf {
        struct buf   bufstruct;      /* buffer structure containing request
                                        for device -- MUST BE FIRST! */
        struct scsi  scsi_command;   /* the information relating strictly
                                          to the scsi command itself */
        uint32  timeout_value;       /* timeout value for the command,
                                              in units of seconds */
        uint32  cmd_flag;
#define FLAG_ABORT              0x01

        uchar   status_validity;   /* least significant bit - scsi_status
                                    * valid, next least significant bit -
                                    * card status valid */

#define SC_SCSI_ERROR           1  /* scsi status reflects error */
#define SC_ADAPTER_ERROR        2  /* general card status reflects err */
        uchar   scsi_status;            /* returned SCSI Bus status */
#define SCSI_STATUS_MASK        0x3e    /* mask for useful bits */
#define SC_GOOD_STATUS          0x00    /* target completed successfully */
#define SC_CHECK_CONDITION      0x02    /* target is reporting an error,
                                         * exception, or abnormal condition */ 
#define SC_BUSY_STATUS          0x08    /* target is busy and cannot accept
                                         * a command from initiator */ 
#define SC_INTMD_GOOD           0x10    /* intermediate status good when using
                                         * linked commands */ 
#define SC_RESERVATION_CONFLICT 0x18    /* attempted to access a LUN which is
                                         * reserved by another initiator */ 
#define SC_COMMAND_TERMINATED   0x22    /* Command has been terminated by
                                         * the device. */ 
#define SC_QUEUE_FULL           0x28    /* Device's command queue is full */

        uchar   general_card_status;    /* SCSI adapter card status byte */
#define SC_HOST_IO_BUS_ERR      0x01    /* Host I/O Bus error condition */
#define SC_SCSI_BUS_FAULT       0x02    /* failure of the SCSI Bus */
#define SC_CMD_TIMEOUT          0x04    /* cmd didn't complete before timeout */
#define SC_NO_DEVICE_RESPONSE   0x08    /* target device did not respond */
#define SC_ADAPTER_HDW_FAILURE  0x10    /* indicating a hardware failure */
#define SC_ADAPTER_SFW_FAILURE  0x20    /* indicating a microcode failure */
#define SC_FUSE_OR_TERMINAL_PWR 0x40    /* indicating bad fuse or termination */
#define SC_SCSI_BUS_RESET       0x80    /* detected external SCSI bus reset */

   uchar      adap_q_status;    /* adapter's device queue status. This*/
#define SC_DID_NOT_CLEAR_Q      0x1  /* SCSI adapter device driver has not */

   uchar        flags;                   /* flags to SCSI adapter driver */
#define SC_RESUME                0x01    /* resume transaction queueing for this
                              * id/lun beginning with this sc_buf */
#define SC_MAPPED                0x02     /* buffer is mapped */

  uint32 qfull_retry_count;
struct dev_info   *current_devp;
};
#define STAT_DEV_RESET          0x0

#define MAX_FCP_TARGET      0xff    /* max num of FCP targets supported */
#define MAX_FCP_LUN     0xff    /* max num of FCP LUNs supported */
/* When on, if a lun is detected to be not present, or 
 * not ready ... device structures related to that lun
 * will be freed to save memory.  Remove this define 
 * to turn off the feature */
#define FREE_LUN        1

#define INDEX(pan, target) (ushort)(((pan)<<8) | ((target) & 0x1ff))
#define DEV_SID(x) (uchar)(x & 0xff)      /* extract sid from device id */
#define DEV_PAN(x) (uchar)((x>>8) & 0x01) /* extract pan from device id */

#define GET_PAYLOAD_PHYS_ADDR(x) (x->phys_adr)

#define MAX_FCP_CMDS      4096          /* Max # of outstanding FCP cmds */
#define MAX_FC_BRDS       16            /* Max # boards per system */
#define MAX_FC_TARGETS    512           /* Max scsi target # per adapter */
#define MAX_FC_BINDINGS   64            /* Max # of persistent bindings */

#define LPFC_LOCK_UNOWNED   ((void *) -1)
#ifdef __KERNEL__
#define cpuid smp_processor_id()
#define maxCPU NR_CPUS
#else
#define cpuid 0
#define maxCPU 1
#endif /* __KERNEL__ */

typedef struct Simple_lock {
  spinlock_t    *sl_lock;
  int owner;
} Simple_lock;

#define disable_lock(p1, p2) 0
#define unlock_enable(p1, p2)

#define LPFC_INIT_LOCK_DRIVER   spin_lock_init(&lpfc_smp_lock)
#define LPFC_INIT_LOCK_DPCQ     spin_lock_init(&lpfc_dpc_request_lock)

#define LPFC_LOCK_DRIVER0      spin_lock_irqsave(&lpfc_smp_lock, iflg)
#define LPFC_LOCK_DRIVER(num)  spin_lock_irqsave(&lpfc_smp_lock, iflg); \
                               if(p_dev_ctl->fc_ipri != 0) {              \
                                  printk("LOCK %d failure %x %x\n",num,   \
                                  (uint32)p_dev_ctl->fc_ipri, (uint32)iflg);      \
                               }                                          \
                               p_dev_ctl->fc_ipri = num

#define LPFC_UNLOCK_DRIVER0     spin_unlock_irqrestore(&lpfc_smp_lock, iflg)
#define LPFC_UNLOCK_DRIVER      if(p_dev_ctl) p_dev_ctl->fc_ipri = 0;         \
                                spin_unlock_irqrestore(&lpfc_smp_lock, iflg)

#define LPFC_LOCK_SCSI_DONE     spin_lock_irqsave(&io_request_lock, siflg)
#define LPFC_UNLOCK_SCSI_DONE   spin_unlock_irqrestore(&io_request_lock, siflg)

#define LPFC_DPC_LOCK_Q     spin_lock_irqsave(&lpfc_dpc_request_lock, siflg)
#define LPFC_DPC_UNLOCK_Q   spin_unlock_irqrestore(&lpfc_dpc_request_lock, siflg)

#define EPERM   1       /* Not super-user                       */
#define ENOENT  2       /* No such file or directory            */
#define ESRCH   3       /* No such process                      */
#define EINTR   4       /* interrupted system call              */
#define EIO     5       /* I/O error                            */
#define ENXIO   6       /* No such device or address            */
#define E2BIG   7       /* Arg list too long                    */
#define ENOEXEC 8       /* Exec format error                    */
#define EBADF   9       /* Bad file number                      */
#define ECHILD  10      /* No children                          */
#ifndef EAGAIN
#define EAGAIN  11      /* Resource temporarily unavailable     */
#endif
#define ENOMEM  12      /* Not enough core                      */
#define EACCES  13      /* Permission denied                    */
#define EFAULT  14      /* Bad address                          */
#define ENOTBLK 15      /* Block device required                */
#define EBUSY   16      /* Mount device busy                    */
#define EEXIST  17      /* File exists                          */
#define EXDEV   18      /* Cross-device link                    */
#define ENODEV  19      /* No such device                       */
#define ENOTDIR 20      /* Not a directory                      */
#define EISDIR  21      /* Is a directory                       */
#define EINVAL  22      /* Invalid argument                     */
#define ENFILE  23      /* File table overflow                  */
#define EMFILE  24      /* Too many open files                  */
#define ENOTTY  25      /* Inappropriate ioctl for device       */
#define ETXTBSY 26      /* Text file busy                       */
#define EFBIG   27      /* File too large                       */
#define ENOSPC  28      /* No space left on device              */
#define ESPIPE  29      /* Illegal seek                         */
#define EROFS   30      /* Read only file system                */
#define EMLINK  31      /* Too many links                       */
#define EPIPE   32      /* Broken pipe                          */
#define EDOM    33      /* Math arg out of domain of func       */
#define ERANGE  34      /* Math result not representable        */
#ifndef ECONNABORTED
#define ECONNABORTED    103     /* Software caused connection abort */
#endif
#ifndef ETIMEDOUT
#define ETIMEDOUT       110     /* Connection timed out */
#endif

#endif /* LP6000 */

#ifdef __KERNEL__
#define EMULEX_REQ_QUEUE_LEN     2048   
#define EMULEX_MAX_SG(ql)   (4 + ((ql) > 0) ? 7*((ql) - 1) : 0)

int fc_detect(Scsi_Host_Template *);
#ifdef MODULE
int fc_release(struct Scsi_Host *);
#else
#define fc_release NULL
#endif
const char * fc_info(struct Scsi_Host *);
int fc_queuecommand(Scsi_Cmnd *, void (* done)(Scsi_Cmnd *));
#define FC_EXTEND_TRANS_A 1
int fc_biosparam(Disk *, kdev_t, int[]);
int fc_abort(Scsi_Cmnd *);
#ifdef FC_NEW_EH
int fc_reset_bus(Scsi_Cmnd *);
int fc_reset_host(Scsi_Cmnd *);
int fc_reset_device(Scsi_Cmnd *);
#else
int lpfc_reset(Scsi_Cmnd *, unsigned int);
int fc_proc_info( char *, char **, off_t, int, int, int);
#endif

#ifdef USE_HIMEM
#define HIGHMEM_ENTRY highmem_io:1 
#else
#define HIGHMEM_ENTRY
#endif

#ifdef FC_NEW_EH
#define LPFC_SG_SEGMENT   64
#define EMULEXFC {                                                 \
    next:               NULL,                              \
    module:             NULL,                              \
    proc_dir:           NULL,                              \
    proc_info:          NULL,                              \
    name:               "lpfc",                            \
    detect:             fc_detect,             \
    release:            fc_release,                \
    info:               fc_info,               \
    command:            NULL,                              \
    queuecommand:           fc_queuecommand,           \
        eh_strategy_handler:    NULL,                              \
    eh_abort_handler:       fc_abort,              \
    eh_device_reset_handler: fc_reset_device,          \
    eh_bus_reset_handler:   fc_reset_bus,              \
    eh_host_reset_handler:  fc_reset_host,             \
        abort:                  NULL,                              \
        reset:                  NULL,                              \
    slave_attach:           NULL,                              \
    bios_param:         fc_biosparam,                  \
    can_queue:          EMULEX_REQ_QUEUE_LEN,              \
    this_id:            -1,                \
    sg_tablesize:           LPFC_SG_SEGMENT,                   \
    cmd_per_lun:        30,                                \
    present:            0,                 \
    unchecked_isa_dma:      0,                 \
    use_clustering:         DISABLE_CLUSTERING,                \
        use_new_eh_code:        0,                                 \
        emulated:               0,                                 \
    HIGHMEM_ENTRY                                              \
}

#else 
#define LPFC_SG_SEGMENT   32
#define EMULEXFC {                                              \
    next:                   NULL,               \
    module:                 NULL,               \
    proc_dir:               NULL,               \
    proc_info:              fc_proc_info,           \
    name:               "lpfc",                         \
    detect:             fc_detect,          \
    release:            fc_release,             \
    info:               fc_info,            \
    ioctl:                  NULL,               \
    command:                NULL,               \
    queuecommand:           fc_queuecommand,        \
    eh_strategy_handler:    NULL,               \
    eh_abort_handler:       NULL,               \
    eh_device_reset_handler:NULL,               \
    eh_bus_reset_handler:   NULL,               \
    eh_host_reset_handler:  NULL,               \
    abort:                  fc_abort,           \
    reset:                  lpfc_reset,         \
    slave_attach:           NULL,               \
    bios_param:         fc_biosparam,               \
    can_queue:          EMULEX_REQ_QUEUE_LEN,           \
    sg_tablesize:           LPFC_SG_SEGMENT,                \
    cmd_per_lun:            30,             \
    present:                0,              \
    unchecked_isa_dma:      0,              \
    use_clustering:         DISABLE_CLUSTERING,             \
    use_new_eh_code:        0,              \
    emulated:               0               \
}
#endif
#endif  /* __KERNEL */

#endif  /* _H_FCOS */

