// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2018 MediaTek Inc.
 * Author: Zhiyong Tao <zhiyong.tao@mediatek.com>
 *
 */
#ifndef PINCTRL_MTK_MT2712_H
#define PINCTRL_MTK_MT2712_H

#include <linux/pinctrl/pinctrl.h>
#include "pinctrl-mtk-common.h"

static const struct mtk_desc_pin mtk_pins_mt2712[] = {
	MTK_PIN(PINCTRL_PIN(0, "EINT0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 6),
		MTK_FUNCTION(0, "GPIO0"),
		MTK_FUNCTION(1, "EINT0"),
		MTK_FUNCTION(2, "MBIST_DIAG_SCANOUT"),
		MTK_FUNCTION(3, "DSIA_TE"),
		MTK_FUNCTION(4, "DSIC_TE"),
		MTK_FUNCTION(5, "DIN_D3"),
		MTK_FUNCTION(6, "PURE_HW_PROTECT")
	),
	MTK_PIN(PINCTRL_PIN(1, "EINT1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 7),
		MTK_FUNCTION(0, "GPIO1"),
		MTK_FUNCTION(1, "EINT1"),
		MTK_FUNCTION(2, "IR_IN"),
		MTK_FUNCTION(3, "DSIB_TE"),
		MTK_FUNCTION(4, "DSID_TE"),
		MTK_FUNCTION(5, "DIN_D4")
	),
	MTK_PIN(PINCTRL_PIN(2, "EINT2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 8),
		MTK_FUNCTION(0, "GPIO2"),
		MTK_FUNCTION(1, "EINT2"),
		MTK_FUNCTION(2, "IR_IN"),
		MTK_FUNCTION(3, "LCM_RST1"),
		MTK_FUNCTION(5, "DIN_D5")
	),
	MTK_PIN(PINCTRL_PIN(3, "EINT3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 9),
		MTK_FUNCTION(0, "GPIO3"),
		MTK_FUNCTION(1, "EINT3"),
		MTK_FUNCTION(2, "IR_IN"),
		MTK_FUNCTION(3, "LCM_RST0"),
		MTK_FUNCTION(5, "DIN_D6")
	),
	MTK_PIN(PINCTRL_PIN(4, "PWM0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 10),
		MTK_FUNCTION(0, "GPIO4"),
		MTK_FUNCTION(1, "PWM0"),
		MTK_FUNCTION(2, "DISP0_PWM"),
		MTK_FUNCTION(3, "DISP1_PWM"),
		MTK_FUNCTION(5, "DIN_CLK")
	),
	MTK_PIN(PINCTRL_PIN(5, "PWM1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 11),
		MTK_FUNCTION(0, "GPIO5"),
		MTK_FUNCTION(1, "PWM1"),
		MTK_FUNCTION(2, "DISP1_PWM"),
		MTK_FUNCTION(3, "DISP0_PWM"),
		MTK_FUNCTION(5, "DIN_VSYNC")
	),
	MTK_PIN(PINCTRL_PIN(6, "PWM2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 12),
		MTK_FUNCTION(0, "GPIO6"),
		MTK_FUNCTION(1, "PWM2"),
		MTK_FUNCTION(2, "DISP0_PWM"),
		MTK_FUNCTION(3, "DISP1_PWM"),
		MTK_FUNCTION(4, "DISP2_PWM"),
		MTK_FUNCTION(5, "DIN_HSYNC")
	),
	MTK_PIN(PINCTRL_PIN(7, "PWM3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 13),
		MTK_FUNCTION(0, "GPIO7"),
		MTK_FUNCTION(1, "PWM3"),
		MTK_FUNCTION(2, "DISP1_PWM"),
		MTK_FUNCTION(3, "DISP0_PWM"),
		MTK_FUNCTION(4, "LCM_RST2"),
		MTK_FUNCTION(5, "DIN_D0")
	),
	MTK_PIN(PINCTRL_PIN(8, "PWM4"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 14),
		MTK_FUNCTION(0, "GPIO8"),
		MTK_FUNCTION(1, "PWM4"),
		MTK_FUNCTION(2, "DISP0_PWM"),
		MTK_FUNCTION(3, "DISP1_PWM"),
		MTK_FUNCTION(4, "DSIA_TE"),
		MTK_FUNCTION(5, "DIN_D1")
	),
	MTK_PIN(PINCTRL_PIN(9, "PWM5"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 15),
		MTK_FUNCTION(0, "GPIO9"),
		MTK_FUNCTION(1, "PWM5"),
		MTK_FUNCTION(2, "DISP1_PWM"),
		MTK_FUNCTION(3, "DISP0_PWM"),
		MTK_FUNCTION(4, "DSIB_TE"),
		MTK_FUNCTION(5, "DIN_D2")
	),
	MTK_PIN(PINCTRL_PIN(10, "PWM6"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 16),
		MTK_FUNCTION(0, "GPIO10"),
		MTK_FUNCTION(1, "PWM6"),
		MTK_FUNCTION(2, "DISP0_PWM"),
		MTK_FUNCTION(3, "DISP1_PWM"),
		MTK_FUNCTION(4, "LCM_RST0")
	),
	MTK_PIN(PINCTRL_PIN(11, "PWM7"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 17),
		MTK_FUNCTION(0, "GPIO11"),
		MTK_FUNCTION(1, "PWM7"),
		MTK_FUNCTION(2, "DISP1_PWM"),
		MTK_FUNCTION(3, "DISP0_PWM"),
		MTK_FUNCTION(4, "LCM_RST1")
	),
	MTK_PIN(PINCTRL_PIN(12, "IDDIG_P0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(1, 22),
		MTK_FUNCTION(0, "GPIO12"),
		MTK_FUNCTION(1, "IDDIG_A"),
		MTK_FUNCTION(5, "DIN_D7")
	),
	MTK_PIN(PINCTRL_PIN(13, "DRV_VBUS_P0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 43),
		MTK_FUNCTION(0, "GPIO13"),
		MTK_FUNCTION(1, "DRV_VBUS_A")
	),
	MTK_PIN(PINCTRL_PIN(14, "IDDIG_P1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(1, 44),
		MTK_FUNCTION(0, "GPIO14"),
		MTK_FUNCTION(1, "IDDIG_B")
	),
	MTK_PIN(PINCTRL_PIN(15, "DRV_VBUS_P1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 45),
		MTK_FUNCTION(0, "GPIO15"),
		MTK_FUNCTION(1, "DRV_VBUS_B")
	),
	MTK_PIN(PINCTRL_PIN(16, "DRV_VBUS_P2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 46),
		MTK_FUNCTION(0, "GPIO16"),
		MTK_FUNCTION(1, "DRV_VBUS_C")
	),
	MTK_PIN(PINCTRL_PIN(17, "DRV_VBUS_P3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 47),
		MTK_FUNCTION(0, "GPIO17"),
		MTK_FUNCTION(1, "DRV_VBUS_D")
	),
	MTK_PIN(PINCTRL_PIN(18, "KPROW0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 18),
		MTK_FUNCTION(0, "GPIO18"),
		MTK_FUNCTION(1, "KROW0")
	),
	MTK_PIN(PINCTRL_PIN(19, "KPCOL0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 19),
		MTK_FUNCTION(0, "GPIO19"),
		MTK_FUNCTION(1, "KCOL0")
	),
	MTK_PIN(PINCTRL_PIN(20, "KPROW1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 48),
		MTK_FUNCTION(0, "GPIO20"),
		MTK_FUNCTION(1, "KROW1")
	),
	MTK_PIN(PINCTRL_PIN(21, "KPCOL1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 49),
		MTK_FUNCTION(0, "GPIO21"),
		MTK_FUNCTION(1, "KCOL1")
	),
	MTK_PIN(PINCTRL_PIN(22, "KPROW2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 50),
		MTK_FUNCTION(0, "GPIO22"),
		MTK_FUNCTION(1, "KROW2"),
		MTK_FUNCTION(2, "DISP1_PWM")
	),
	MTK_PIN(PINCTRL_PIN(23, "KPCOL2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 51),
		MTK_FUNCTION(0, "GPIO23"),
		MTK_FUNCTION(1, "KCOL2"),
		MTK_FUNCTION(2, "DISP0_PWM")
	),
	MTK_PIN(PINCTRL_PIN(24, "CMMCLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 52),
		MTK_FUNCTION(0, "GPIO24"),
		MTK_FUNCTION(1, "CMMCLK"),
		MTK_FUNCTION(7, "DBG_MON_A_1_")
	),
	MTK_PIN(PINCTRL_PIN(25, "CM2MCLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 53),
		MTK_FUNCTION(0, "GPIO25"),
		MTK_FUNCTION(1, "CM2MCLK"),
		MTK_FUNCTION(7, "DBG_MON_A_2_")
	),
	MTK_PIN(PINCTRL_PIN(26, "PCM_TX"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 54),
		MTK_FUNCTION(0, "GPIO26"),
		MTK_FUNCTION(1, "PCM1_DO"),
		MTK_FUNCTION(2, "MRG_TX"),
		MTK_FUNCTION(3, "DAI_TX"),
		MTK_FUNCTION(4, "MRG_RX"),
		MTK_FUNCTION(5, "DAI_RX"),
		MTK_FUNCTION(6, "PCM1_DI"),
		MTK_FUNCTION(7, "DBG_MON_A_3_")
	),
	MTK_PIN(PINCTRL_PIN(27, "PCM_CLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 55),
		MTK_FUNCTION(0, "GPIO27"),
		MTK_FUNCTION(1, "PCM1_CLK"),
		MTK_FUNCTION(2, "MRG_CLK"),
		MTK_FUNCTION(3, "DAI_CLK"),
		MTK_FUNCTION(7, "DBG_MON_A_4_")
	),
	MTK_PIN(PINCTRL_PIN(28, "PCM_RX"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 56),
		MTK_FUNCTION(0, "GPIO28"),
		MTK_FUNCTION(1, "PCM1_DI"),
		MTK_FUNCTION(2, "MRG_RX"),
		MTK_FUNCTION(3, "DAI_RX"),
		MTK_FUNCTION(4, "MRG_TX"),
		MTK_FUNCTION(5, "DAI_TX"),
		MTK_FUNCTION(6, "PCM1_DO"),
		MTK_FUNCTION(7, "DBG_MON_A_5_")
	),
	MTK_PIN(PINCTRL_PIN(29, "PCM_SYNC"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 57),
		MTK_FUNCTION(0, "GPIO29"),
		MTK_FUNCTION(1, "PCM1_SYNC"),
		MTK_FUNCTION(2, "MRG_SYNC"),
		MTK_FUNCTION(3, "DAI_SYNC"),
		MTK_FUNCTION(7, "DBG_MON_A_6_")
	),
	MTK_PIN(PINCTRL_PIN(30, "NCEB0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 58),
		MTK_FUNCTION(0, "GPIO30"),
		MTK_FUNCTION(1, "NCEB0"),
		MTK_FUNCTION(2, "USB0_FT_SDA"),
		MTK_FUNCTION(7, "DBG_MON_A_7_")
	),
	MTK_PIN(PINCTRL_PIN(31, "NCEB1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 59),
		MTK_FUNCTION(0, "GPIO31"),
		MTK_FUNCTION(1, "NCEB1"),
		MTK_FUNCTION(2, "USB1_FT_SCL"),
		MTK_FUNCTION(7, "DBG_MON_A_8_")
	),
	MTK_PIN(PINCTRL_PIN(32, "NF_DQS"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 60),
		MTK_FUNCTION(0, "GPIO32"),
		MTK_FUNCTION(1, "NF_DQS"),
		MTK_FUNCTION(2, "USB1_FT_SDA"),
		MTK_FUNCTION(7, "DBG_MON_A_9_")
	),
	MTK_PIN(PINCTRL_PIN(33, "NWEB"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 61),
		MTK_FUNCTION(0, "GPIO33"),
		MTK_FUNCTION(1, "NWEB"),
		MTK_FUNCTION(2, "USB2_FT_SCL"),
		MTK_FUNCTION(7, "DBG_MON_A_10_")
	),
	MTK_PIN(PINCTRL_PIN(34, "NREB"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 62),
		MTK_FUNCTION(0, "GPIO34"),
		MTK_FUNCTION(1, "NREB"),
		MTK_FUNCTION(2, "USB2_FT_SDA"),
		MTK_FUNCTION(7, "DBG_MON_A_11_")
	),
	MTK_PIN(PINCTRL_PIN(35, "NCLE"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 63),
		MTK_FUNCTION(0, "GPIO35"),
		MTK_FUNCTION(1, "NCLE"),
		MTK_FUNCTION(2, "USB3_FT_SCL"),
		MTK_FUNCTION(7, "DBG_MON_A_12_")
	),
	MTK_PIN(PINCTRL_PIN(36, "NALE"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 64),
		MTK_FUNCTION(0, "GPIO36"),
		MTK_FUNCTION(1, "NALE"),
		MTK_FUNCTION(2, "USB3_FT_SDA"),
		MTK_FUNCTION(7, "DBG_MON_A_13_")
	),
	MTK_PIN(PINCTRL_PIN(37, "MSDC0E_CLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO37"),
		MTK_FUNCTION(1, "MSDC0_CLK"),
		MTK_FUNCTION(2, "USB0_FT_SCL"),
		MTK_FUNCTION(7, "DBG_MON_A_0_")
	),
	MTK_PIN(PINCTRL_PIN(38, "MSDC0E_DAT7"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO38"),
		MTK_FUNCTION(1, "MSDC0_DAT7"),
		MTK_FUNCTION(2, "NAND_ND7"),
		MTK_FUNCTION(7, "DBG_MON_A_14_")
	),
	MTK_PIN(PINCTRL_PIN(39, "MSDC0E_DAT6"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO39"),
		MTK_FUNCTION(1, "MSDC0_DAT6"),
		MTK_FUNCTION(2, "NAND_ND6"),
		MTK_FUNCTION(7, "DBG_MON_A_15_")
	),
	MTK_PIN(PINCTRL_PIN(40, "MSDC0E_DAT5"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO40"),
		MTK_FUNCTION(1, "MSDC0_DAT5"),
		MTK_FUNCTION(2, "NAND_ND5"),
		MTK_FUNCTION(7, "DBG_MON_A_16_")
	),
	MTK_PIN(PINCTRL_PIN(41, "MSDC0E_DAT4"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO41"),
		MTK_FUNCTION(1, "MSDC0_DAT4"),
		MTK_FUNCTION(2, "NAND_ND4"),
		MTK_FUNCTION(7, "DBG_MON_A_17_")
	),
	MTK_PIN(PINCTRL_PIN(42, "MSDC0E_DAT3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO42"),
		MTK_FUNCTION(1, "MSDC0_DAT3"),
		MTK_FUNCTION(2, "NAND_ND3"),
		MTK_FUNCTION(7, "DBG_MON_A_18_")
	),
	MTK_PIN(PINCTRL_PIN(43, "MSDC0E_DAT2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO43"),
		MTK_FUNCTION(1, "MSDC0_DAT2"),
		MTK_FUNCTION(2, "NAND_ND2"),
		MTK_FUNCTION(7, "DBG_MON_A_19_")
	),
	MTK_PIN(PINCTRL_PIN(44, "MSDC0E_DAT1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO44"),
		MTK_FUNCTION(1, "MSDC0_DAT1"),
		MTK_FUNCTION(2, "NAND_ND1"),
		MTK_FUNCTION(7, "DBG_MON_A_20_")
	),
	MTK_PIN(PINCTRL_PIN(45, "MSDC0E_DAT0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO45"),
		MTK_FUNCTION(1, "MSDC0_DAT0"),
		MTK_FUNCTION(2, "NAND_ND0"),
		MTK_FUNCTION(7, "DBG_MON_A_21_")
	),
	MTK_PIN(PINCTRL_PIN(46, "MSDC0E_CMD"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO46"),
		MTK_FUNCTION(1, "MSDC0_CMD"),
		MTK_FUNCTION(2, "NAND_NRNB"),
		MTK_FUNCTION(7, "DBG_MON_A_22_")
	),
	MTK_PIN(PINCTRL_PIN(47, "MSDC0E_DSL"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(NO_EINT_SUPPORT, NO_EINT_SUPPORT),
		MTK_FUNCTION(0, "GPIO47"),
		MTK_FUNCTION(1, "MSDC0_DSL"),
		MTK_FUNCTION(7, "DBG_MON_A_23_")
	),
	MTK_PIN(PINCTRL_PIN(48, "MSDC0E_RSTB"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 142),
		MTK_FUNCTION(0, "GPIO48"),
		MTK_FUNCTION(1, "MSDC0_RSTB"),
		MTK_FUNCTION(7, "DBG_MON_A_24_")
	),
	MTK_PIN(PINCTRL_PIN(49, "MSDC3_DAT3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 65),
		MTK_FUNCTION(0, "GPIO49"),
		MTK_FUNCTION(1, "MSDC3_DAT3"),
		MTK_FUNCTION(7, "DBG_MON_A_25_")
	),
	MTK_PIN(PINCTRL_PIN(50, "MSDC3_DAT2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 66),
		MTK_FUNCTION(0, "GPIO50"),
		MTK_FUNCTION(1, "MSDC3_DAT2"),
		MTK_FUNCTION(7, "DBG_MON_A_26_")
	),
	MTK_PIN(PINCTRL_PIN(51, "MSDC3_DAT1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 67),
		MTK_FUNCTION(0, "GPIO51"),
		MTK_FUNCTION(1, "MSDC3_DAT1"),
		MTK_FUNCTION(7, "DBG_MON_A_27_")
	),
	MTK_PIN(PINCTRL_PIN(52, "MSDC3_DAT0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 68),
		MTK_FUNCTION(0, "GPIO52"),
		MTK_FUNCTION(1, "MSDC3_DAT0"),
		MTK_FUNCTION(7, "DBG_MON_A_28_")
	),
	MTK_PIN(PINCTRL_PIN(53, "MSDC3_CMD"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 69),
		MTK_FUNCTION(0, "GPIO53"),
		MTK_FUNCTION(1, "MSDC3_CMD"),
		MTK_FUNCTION(7, "DBG_MON_A_29_")
	),
	MTK_PIN(PINCTRL_PIN(54, "MSDC3_INS"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 20),
		MTK_FUNCTION(0, "GPIO54"),
		MTK_FUNCTION(1, "MSDC3_INS"),
		MTK_FUNCTION(7, "DBG_MON_A_30_")
	),
	MTK_PIN(PINCTRL_PIN(55, "MSDC3_DSL"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 70),
		MTK_FUNCTION(0, "GPIO55"),
		MTK_FUNCTION(1, "MSDC3_DSL"),
		MTK_FUNCTION(7, "DBG_MON_A_31_")
	),
	MTK_PIN(PINCTRL_PIN(56, "MSDC3_CLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 71),
		MTK_FUNCTION(0, "GPIO56"),
		MTK_FUNCTION(1, "MSDC3_CLK"),
		MTK_FUNCTION(7, "DBG_MON_A_32_")
	),
	MTK_PIN(PINCTRL_PIN(57, "NOR_CS"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 72),
		MTK_FUNCTION(0, "GPIO57"),
		MTK_FUNCTION(1, "NOR_CS")
	),
	MTK_PIN(PINCTRL_PIN(58, "NOR_CK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 73),
		MTK_FUNCTION(0, "GPIO58"),
		MTK_FUNCTION(1, "NOR_CK")
	),
	MTK_PIN(PINCTRL_PIN(59, "NOR_IO0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 74),
		MTK_FUNCTION(0, "GPIO59"),
		MTK_FUNCTION(1, "NOR_IO0")
	),
	MTK_PIN(PINCTRL_PIN(60, "NOR_IO1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 75),
		MTK_FUNCTION(0, "GPIO60"),
		MTK_FUNCTION(1, "NOR_IO1")
	),
	MTK_PIN(PINCTRL_PIN(61, "NOR_IO2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 76),
		MTK_FUNCTION(0, "GPIO61"),
		MTK_FUNCTION(1, "NOR_IO2")
	),
	MTK_PIN(PINCTRL_PIN(62, "NOR_IO3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 77),
		MTK_FUNCTION(0, "GPIO62"),
		MTK_FUNCTION(1, "NOR_IO3")
	),
	MTK_PIN(PINCTRL_PIN(63, "MSDC1_CLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 78),
		MTK_FUNCTION(0, "GPIO63"),
		MTK_FUNCTION(1, "MSDC1_CLK"),
		MTK_FUNCTION(2, "UDI_TCK")
	),
	MTK_PIN(PINCTRL_PIN(64, "MSDC1_DAT3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 79),
		MTK_FUNCTION(0, "GPIO64"),
		MTK_FUNCTION(1, "MSDC1_DAT3"),
		MTK_FUNCTION(2, "UDI_TDI")
	),
	MTK_PIN(PINCTRL_PIN(65, "MSDC1_DAT1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 80),
		MTK_FUNCTION(0, "GPIO65"),
		MTK_FUNCTION(1, "MSDC1_DAT1"),
		MTK_FUNCTION(2, "UDI_TMS")
	),
	MTK_PIN(PINCTRL_PIN(66, "MSDC1_DAT2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 81),
		MTK_FUNCTION(0, "GPIO66"),
		MTK_FUNCTION(1, "MSDC1_DAT2"),
		MTK_FUNCTION(2, "UDI_TDO")
	),
	MTK_PIN(PINCTRL_PIN(67, "MSDC1_PSW"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 82),
		MTK_FUNCTION(0, "GPIO67"),
		MTK_FUNCTION(2, "UDI_NTRST")
	),
	MTK_PIN(PINCTRL_PIN(68, "MSDC1_DAT0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 83),
		MTK_FUNCTION(0, "GPIO68"),
		MTK_FUNCTION(1, "MSDC1_DAT0")
	),
	MTK_PIN(PINCTRL_PIN(69, "MSDC1_CMD"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 84),
		MTK_FUNCTION(0, "GPIO69"),
		MTK_FUNCTION(1, "MSDC1_CMD")
	),
	MTK_PIN(PINCTRL_PIN(70, "MSDC1_INS"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 85),
		MTK_FUNCTION(0, "GPIO70")
	),
	MTK_PIN(PINCTRL_PIN(71, "GBE_TXD3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 86),
		MTK_FUNCTION(0, "GPIO71"),
		MTK_FUNCTION(1, "GBE_TXD3"),
		MTK_FUNCTION(7, "DBG_MON_B_0_")
	),
	MTK_PIN(PINCTRL_PIN(72, "GBE_TXD2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 87),
		MTK_FUNCTION(0, "GPIO72"),
		MTK_FUNCTION(1, "GBE_TXD2"),
		MTK_FUNCTION(7, "DBG_MON_B_1_")
	),
	MTK_PIN(PINCTRL_PIN(73, "GBE_TXD1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 88),
		MTK_FUNCTION(0, "GPIO73"),
		MTK_FUNCTION(1, "GBE_TXD1"),
		MTK_FUNCTION(7, "DBG_MON_B_2_")
	),
	MTK_PIN(PINCTRL_PIN(74, "GBE_TXD0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 89),
		MTK_FUNCTION(0, "GPIO74"),
		MTK_FUNCTION(1, "GBE_TXD0"),
		MTK_FUNCTION(7, "DBG_MON_B_3_")
	),
	MTK_PIN(PINCTRL_PIN(75, "GBE_TXC"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 90),
		MTK_FUNCTION(0, "GPIO75"),
		MTK_FUNCTION(1, "GBE_TXC"),
		MTK_FUNCTION(7, "DBG_MON_B_4_")
	),
	MTK_PIN(PINCTRL_PIN(76, "GBE_TXEN"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 91),
		MTK_FUNCTION(0, "GPIO76"),
		MTK_FUNCTION(1, "GBE_TXEN"),
		MTK_FUNCTION(7, "DBG_MON_B_5_")
	),
	MTK_PIN(PINCTRL_PIN(77, "GBE_TXER"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 92),
		MTK_FUNCTION(0, "GPIO77"),
		MTK_FUNCTION(1, "GBE_TXER"),
		MTK_FUNCTION(7, "DBG_MON_B_6_")
	),
	MTK_PIN(PINCTRL_PIN(78, "GBE_RXD3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 93),
		MTK_FUNCTION(0, "GPIO78"),
		MTK_FUNCTION(1, "GBE_RXD3"),
		MTK_FUNCTION(7, "DBG_MON_B_7_")
	),
	MTK_PIN(PINCTRL_PIN(79, "GBE_RXD2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 94),
		MTK_FUNCTION(0, "GPIO79"),
		MTK_FUNCTION(1, "GBE_RXD2"),
		MTK_FUNCTION(7, "DBG_MON_B_8_")
	),
	MTK_PIN(PINCTRL_PIN(80, "GBE_RXD1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 95),
		MTK_FUNCTION(0, "GPIO80"),
		MTK_FUNCTION(1, "GBE_RXD1"),
		MTK_FUNCTION(7, "DBG_MON_B_9_")
	),
	MTK_PIN(PINCTRL_PIN(81, "GBE_RXD0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 96),
		MTK_FUNCTION(0, "GPIO81"),
		MTK_FUNCTION(1, "GBE_RXD0"),
		MTK_FUNCTION(7, "DBG_MON_B_10_")
	),
	MTK_PIN(PINCTRL_PIN(82, "GBE_RXDV"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 97),
		MTK_FUNCTION(0, "GPIO82"),
		MTK_FUNCTION(1, "GBE_RXDV"),
		MTK_FUNCTION(7, "DBG_MON_B_11_")
	),
	MTK_PIN(PINCTRL_PIN(83, "GBE_RXER"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 98),
		MTK_FUNCTION(0, "GPIO83"),
		MTK_FUNCTION(1, "GBE_RXER"),
		MTK_FUNCTION(7, "DBG_MON_B_12_")
	),
	MTK_PIN(PINCTRL_PIN(84, "GBE_RXC"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 99),
		MTK_FUNCTION(0, "GPIO84"),
		MTK_FUNCTION(1, "GBE_RXC"),
		MTK_FUNCTION(7, "DBG_MON_B_13_")
	),
	MTK_PIN(PINCTRL_PIN(85, "GBE_MDC"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 100),
		MTK_FUNCTION(0, "GPIO85"),
		MTK_FUNCTION(1, "GBE_MDC"),
		MTK_FUNCTION(7, "DBG_MON_B_14_")
	),
	MTK_PIN(PINCTRL_PIN(86, "GBE_MDIO"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 101),
		MTK_FUNCTION(0, "GPIO86"),
		MTK_FUNCTION(1, "GBE_MDIO"),
		MTK_FUNCTION(7, "DBG_MON_B_15_")
	),
	MTK_PIN(PINCTRL_PIN(87, "GBE_COL"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 102),
		MTK_FUNCTION(0, "GPIO87"),
		MTK_FUNCTION(1, "GBE_COL"),
		MTK_FUNCTION(7, "DBG_MON_B_16_")
	),
	MTK_PIN(PINCTRL_PIN(88, "GBE_INTR"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 21),
		MTK_FUNCTION(0, "GPIO88"),
		MTK_FUNCTION(1, "GBE_INTR"),
		MTK_FUNCTION(2, "GBE_CRS"),
		MTK_FUNCTION(7, "DBG_MON_B_17_")
	),
	MTK_PIN(PINCTRL_PIN(89, "MSDC2_CLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 103),
		MTK_FUNCTION(0, "GPIO89"),
		MTK_FUNCTION(1, "MSDC2_CLK"),
		MTK_FUNCTION(7, "DBG_MON_B_18_")
	),
	MTK_PIN(PINCTRL_PIN(90, "MSDC2_DAT3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 104),
		MTK_FUNCTION(0, "GPIO90"),
		MTK_FUNCTION(1, "MSDC2_DAT3"),
		MTK_FUNCTION(7, "DBG_MON_B_19_")
	),
	MTK_PIN(PINCTRL_PIN(91, "MSDC2_DAT2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 105),
		MTK_FUNCTION(0, "GPIO91"),
		MTK_FUNCTION(1, "MSDC2_DAT2"),
		MTK_FUNCTION(7, "DBG_MON_B_20_")
	),
	MTK_PIN(PINCTRL_PIN(92, "MSDC2_DAT1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 106),
		MTK_FUNCTION(0, "GPIO92"),
		MTK_FUNCTION(1, "MSDC2_DAT1"),
		MTK_FUNCTION(7, "DBG_MON_B_21_")
	),
	MTK_PIN(PINCTRL_PIN(93, "MSDC2_DAT0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 107),
		MTK_FUNCTION(0, "GPIO93"),
		MTK_FUNCTION(1, "MSDC2_DAT0"),
		MTK_FUNCTION(7, "DBG_MON_B_22_")
	),
	MTK_PIN(PINCTRL_PIN(94, "MSDC2_INS"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 108),
		MTK_FUNCTION(0, "GPIO94"),
		MTK_FUNCTION(7, "DBG_MON_B_23_")
	),
	MTK_PIN(PINCTRL_PIN(95, "MSDC2_CMD"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 109),
		MTK_FUNCTION(0, "GPIO95"),
		MTK_FUNCTION(1, "MSDC2_CMD"),
		MTK_FUNCTION(7, "DBG_MON_B_24_")
	),
	MTK_PIN(PINCTRL_PIN(96, "MSDC2_PSW"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 110),
		MTK_FUNCTION(0, "GPIO96"),
		MTK_FUNCTION(7, "DBG_MON_B_25_")
	),
	MTK_PIN(PINCTRL_PIN(97, "URXD4"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 111),
		MTK_FUNCTION(0, "GPIO97"),
		MTK_FUNCTION(1, "URXD4"),
		MTK_FUNCTION(2, "UTXD4"),
		MTK_FUNCTION(3, "MRG_CLK"),
		MTK_FUNCTION(4, "PCM1_CLK"),
		MTK_FUNCTION(5, "I2S_IQ2_SDQB"),
		MTK_FUNCTION(6, "I2SO1_WS"),
		MTK_FUNCTION(7, "DBG_MON_B_26_")
	),
	MTK_PIN(PINCTRL_PIN(98, "URTS4"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 112),
		MTK_FUNCTION(0, "GPIO98"),
		MTK_FUNCTION(1, "URTS4"),
		MTK_FUNCTION(2, "UCTS4"),
		MTK_FUNCTION(3, "MRG_RX"),
		MTK_FUNCTION(4, "PCM1_DI"),
		MTK_FUNCTION(5, "I2S_IQ1_SDIB"),
		MTK_FUNCTION(6, "I2SO1_MCK"),
		MTK_FUNCTION(7, "DBG_MON_B_27_")
	),
	MTK_PIN(PINCTRL_PIN(99, "UTXD4"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 113),
		MTK_FUNCTION(0, "GPIO99"),
		MTK_FUNCTION(1, "UTXD4"),
		MTK_FUNCTION(2, "URXD4"),
		MTK_FUNCTION(3, "MRG_SYNC"),
		MTK_FUNCTION(4, "PCM1_SYNC"),
		MTK_FUNCTION(5, "I2S_IQ0_SDQB"),
		MTK_FUNCTION(6, "I2SO1_BCK"),
		MTK_FUNCTION(7, "DBG_MON_B_28_")
	),
	MTK_PIN(PINCTRL_PIN(100, "UCTS4"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 114),
		MTK_FUNCTION(0, "GPIO100"),
		MTK_FUNCTION(1, "UCTS4"),
		MTK_FUNCTION(2, "URTS4"),
		MTK_FUNCTION(3, "MRG_TX"),
		MTK_FUNCTION(4, "PCM1_DO"),
		MTK_FUNCTION(5, "I2S_IQ0_SDIB"),
		MTK_FUNCTION(6, "I2SO1_DO"),
		MTK_FUNCTION(7, "DBG_MON_B_29_")
	),
	MTK_PIN(PINCTRL_PIN(101, "URXD5"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 30),
		MTK_FUNCTION(0, "GPIO101"),
		MTK_FUNCTION(1, "URXD5"),
		MTK_FUNCTION(2, "UTXD5"),
		MTK_FUNCTION(3, "I2SO3_WS"),
		MTK_FUNCTION(4, "TDMIN_LRCK"),
		MTK_FUNCTION(6, "I2SO0_WS"),
		MTK_FUNCTION(7, "DBG_MON_B_30_")
	),
	MTK_PIN(PINCTRL_PIN(102, "URTS5"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 31),
		MTK_FUNCTION(0, "GPIO102"),
		MTK_FUNCTION(1, "URTS5"),
		MTK_FUNCTION(2, "UCTS5"),
		MTK_FUNCTION(3, "I2SO3_MCK"),
		MTK_FUNCTION(4, "TDMIN_MCLK"),
		MTK_FUNCTION(5, "IR_IN"),
		MTK_FUNCTION(6, "I2SO0_MCK"),
		MTK_FUNCTION(7, "DBG_MON_B_31_")
	),
	MTK_PIN(PINCTRL_PIN(103, "UTXD5"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 32),
		MTK_FUNCTION(0, "GPIO103"),
		MTK_FUNCTION(1, "UTXD5"),
		MTK_FUNCTION(2, "URXD5"),
		MTK_FUNCTION(3, "I2SO3_BCK"),
		MTK_FUNCTION(4, "TDMIN_BCK"),
		MTK_FUNCTION(6, "I2SO0_BCK"),
		MTK_FUNCTION(7, "DBG_MON_B_32_")
	),
	MTK_PIN(PINCTRL_PIN(104, "UCTS5"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 33),
		MTK_FUNCTION(0, "GPIO104"),
		MTK_FUNCTION(1, "UCTS5"),
		MTK_FUNCTION(2, "URTS5"),
		MTK_FUNCTION(3, "I2SO0_DO1"),
		MTK_FUNCTION(4, "TDMIN_DI"),
		MTK_FUNCTION(5, "IR_IN"),
		MTK_FUNCTION(6, "I2SO0_DO0")
	),
	MTK_PIN(PINCTRL_PIN(105, "I2C_SDA0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 115),
		MTK_FUNCTION(0, "GPIO105"),
		MTK_FUNCTION(1, "SDA0")
	),
	MTK_PIN(PINCTRL_PIN(106, "I2C_SDA1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 116),
		MTK_FUNCTION(0, "GPIO106"),
		MTK_FUNCTION(1, "SDA1")
	),
	MTK_PIN(PINCTRL_PIN(107, "I2C_SDA2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 117),
		MTK_FUNCTION(0, "GPIO107"),
		MTK_FUNCTION(1, "SDA2")
	),
	MTK_PIN(PINCTRL_PIN(108, "I2C_SDA3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 118),
		MTK_FUNCTION(0, "GPIO108"),
		MTK_FUNCTION(1, "SDA3")
	),
	MTK_PIN(PINCTRL_PIN(109, "I2C_SDA4"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 119),
		MTK_FUNCTION(0, "GPIO109"),
		MTK_FUNCTION(1, "SDA4")
	),
	MTK_PIN(PINCTRL_PIN(110, "I2C_SDA5"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 34),
		MTK_FUNCTION(0, "GPIO110"),
		MTK_FUNCTION(1, "SDA5")
	),
	MTK_PIN(PINCTRL_PIN(111, "I2C_SCL0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 120),
		MTK_FUNCTION(0, "GPIO111"),
		MTK_FUNCTION(1, "SCL0")
	),
	MTK_PIN(PINCTRL_PIN(112, "I2C_SCL1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 121),
		MTK_FUNCTION(0, "GPIO112"),
		MTK_FUNCTION(1, "SCL1")
	),
	MTK_PIN(PINCTRL_PIN(113, "I2C_SCL2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 122),
		MTK_FUNCTION(0, "GPIO113"),
		MTK_FUNCTION(1, "SCL2")
	),
	MTK_PIN(PINCTRL_PIN(114, "I2C_SCL3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 123),
		MTK_FUNCTION(0, "GPIO114"),
		MTK_FUNCTION(1, "SCL3")
	),
	MTK_PIN(PINCTRL_PIN(115, "I2C_SCL4"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 124),
		MTK_FUNCTION(0, "GPIO115"),
		MTK_FUNCTION(1, "SCL4")
	),
	MTK_PIN(PINCTRL_PIN(116, "I2C_SCL5"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 35),
		MTK_FUNCTION(0, "GPIO116"),
		MTK_FUNCTION(1, "SCL5")
	),
	MTK_PIN(PINCTRL_PIN(117, "URXD0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 125),
		MTK_FUNCTION(0, "GPIO117"),
		MTK_FUNCTION(1, "URXD0"),
		MTK_FUNCTION(2, "UTXD0")
	),
	MTK_PIN(PINCTRL_PIN(118, "URXD1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 126),
		MTK_FUNCTION(0, "GPIO118"),
		MTK_FUNCTION(1, "URXD1"),
		MTK_FUNCTION(2, "UTXD1")
	),
	MTK_PIN(PINCTRL_PIN(119, "URXD2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 127),
		MTK_FUNCTION(0, "GPIO119"),
		MTK_FUNCTION(1, "URXD2"),
		MTK_FUNCTION(2, "UTXD2")
	),
	MTK_PIN(PINCTRL_PIN(120, "UTXD0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 128),
		MTK_FUNCTION(0, "GPIO120"),
		MTK_FUNCTION(1, "UTXD0"),
		MTK_FUNCTION(2, "URXD0")
	),
	MTK_PIN(PINCTRL_PIN(121, "UTXD1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 129),
		MTK_FUNCTION(0, "GPIO121"),
		MTK_FUNCTION(1, "UTXD1"),
		MTK_FUNCTION(2, "URXD1")
	),
	MTK_PIN(PINCTRL_PIN(122, "UTXD2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 130),
		MTK_FUNCTION(0, "GPIO122"),
		MTK_FUNCTION(1, "UTXD2"),
		MTK_FUNCTION(2, "URXD2")
	),
	MTK_PIN(PINCTRL_PIN(123, "URXD3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 131),
		MTK_FUNCTION(0, "GPIO123"),
		MTK_FUNCTION(1, "URXD3"),
		MTK_FUNCTION(2, "UTXD3"),
		MTK_FUNCTION(3, "PURE_HW_PROTECT")
	),
	MTK_PIN(PINCTRL_PIN(124, "UTXD3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 132),
		MTK_FUNCTION(0, "GPIO124"),
		MTK_FUNCTION(1, "UTXD3"),
		MTK_FUNCTION(2, "URXD3"),
		MTK_FUNCTION(3, "PURE_HW_PROTECT")
	),
	MTK_PIN(PINCTRL_PIN(125, "URTS3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 133),
		MTK_FUNCTION(0, "GPIO125"),
		MTK_FUNCTION(1, "URTS3"),
		MTK_FUNCTION(2, "UCTS3"),
		MTK_FUNCTION(3, "WATCH_DOG")
	),
	MTK_PIN(PINCTRL_PIN(126, "UCTS3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 134),
		MTK_FUNCTION(0, "GPIO126"),
		MTK_FUNCTION(1, "UCTS3"),
		MTK_FUNCTION(2, "URTS3"),
		MTK_FUNCTION(3, "SRCLKENA0")
	),
	MTK_PIN(PINCTRL_PIN(127, "SPI2_CSN"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 135),
		MTK_FUNCTION(0, "GPIO127"),
		MTK_FUNCTION(1, "SPI_CS_2_"),
		MTK_FUNCTION(2, "SPI_CS_1_")
	),
	MTK_PIN(PINCTRL_PIN(128, "SPI2_MO"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 136),
		MTK_FUNCTION(0, "GPIO128"),
		MTK_FUNCTION(1, "SPI_MO_2_"),
		MTK_FUNCTION(2, "SPI_SO_1_")
	),
	MTK_PIN(PINCTRL_PIN(129, "SPI2_MI"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 137),
		MTK_FUNCTION(0, "GPIO129"),
		MTK_FUNCTION(1, "SPI_MI_2_"),
		MTK_FUNCTION(2, "SPI_SI_1_")
	),
	MTK_PIN(PINCTRL_PIN(130, "SPI2_CK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 138),
		MTK_FUNCTION(0, "GPIO130"),
		MTK_FUNCTION(1, "SPI_CK_2_"),
		MTK_FUNCTION(2, "SPI_CK_1_")
	),
	MTK_PIN(PINCTRL_PIN(131, "SPI3_CSN"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 139),
		MTK_FUNCTION(0, "GPIO131"),
		MTK_FUNCTION(1, "SPI_CS_3_")
	),
	MTK_PIN(PINCTRL_PIN(132, "SPI3_MO"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 143),
		MTK_FUNCTION(0, "GPIO132"),
		MTK_FUNCTION(1, "SPI_MO_3_")
	),
	MTK_PIN(PINCTRL_PIN(133, "SPI3_MI"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 144),
		MTK_FUNCTION(0, "GPIO133"),
		MTK_FUNCTION(1, "SPI_MI_3_")
	),
	MTK_PIN(PINCTRL_PIN(134, "SPI3_CK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 145),
		MTK_FUNCTION(0, "GPIO134"),
		MTK_FUNCTION(1, "SPI_CK_3_")
	),
	MTK_PIN(PINCTRL_PIN(135, "KPROW3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 146),
		MTK_FUNCTION(0, "GPIO135"),
		MTK_FUNCTION(1, "KROW3"),
		MTK_FUNCTION(2, "DSIC_TE")
	),
	MTK_PIN(PINCTRL_PIN(136, "KPROW4"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 36),
		MTK_FUNCTION(0, "GPIO136"),
		MTK_FUNCTION(1, "KROW4"),
		MTK_FUNCTION(2, "DSID_TE")
	),
	MTK_PIN(PINCTRL_PIN(137, "KPCOL3"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 147),
		MTK_FUNCTION(0, "GPIO137"),
		MTK_FUNCTION(1, "KCOL3"),
		MTK_FUNCTION(2, "DISP2_PWM")
	),
	MTK_PIN(PINCTRL_PIN(138, "KPCOL4"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 37),
		MTK_FUNCTION(0, "GPIO138"),
		MTK_FUNCTION(1, "KCOL4"),
		MTK_FUNCTION(2, "LCM_RST2")
	),
	MTK_PIN(PINCTRL_PIN(139, "KPCOL5"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 38),
		MTK_FUNCTION(0, "GPIO139"),
		MTK_FUNCTION(1, "KCOL5"),
		MTK_FUNCTION(3, "DSIA_TE"),
		MTK_FUNCTION(4, "PURE_HW_PROTECT")
	),
	MTK_PIN(PINCTRL_PIN(140, "KPCOL6"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 39),
		MTK_FUNCTION(0, "GPIO140"),
		MTK_FUNCTION(1, "KCOL6"),
		MTK_FUNCTION(2, "WATCH_DOG"),
		MTK_FUNCTION(3, "LCM_RST1")
	),
	MTK_PIN(PINCTRL_PIN(141, "KPROW5"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 40),
		MTK_FUNCTION(0, "GPIO141"),
		MTK_FUNCTION(1, "KROW5"),
		MTK_FUNCTION(3, "LCM_RST0"),
		MTK_FUNCTION(4, "PURE_HW_PROTECT")
	),
	MTK_PIN(PINCTRL_PIN(142, "KPROW6"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 41),
		MTK_FUNCTION(0, "GPIO142"),
		MTK_FUNCTION(1, "KROW6"),
		MTK_FUNCTION(2, "SRCLKENA0"),
		MTK_FUNCTION(3, "DSIB_TE")
	),
	MTK_PIN(PINCTRL_PIN(143, "JTDO_ICE"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 148),
		MTK_FUNCTION(0, "GPIO143"),
		MTK_FUNCTION(1, "JTDO_ICE"),
		MTK_FUNCTION(3, "DFD_TDO")
	),
	MTK_PIN(PINCTRL_PIN(144, "JTCK_ICE"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 149),
		MTK_FUNCTION(0, "GPIO144"),
		MTK_FUNCTION(1, "JTCK_ICE"),
		MTK_FUNCTION(3, "DFD_TCK")
	),
	MTK_PIN(PINCTRL_PIN(145, "JTDI_ICE"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 150),
		MTK_FUNCTION(0, "GPIO145"),
		MTK_FUNCTION(1, "JTDI_ICE"),
		MTK_FUNCTION(3, "DFD_TDI")
	),
	MTK_PIN(PINCTRL_PIN(146, "JTMS_ICE"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 151),
		MTK_FUNCTION(0, "GPIO146"),
		MTK_FUNCTION(1, "JTMS_ICE"),
		MTK_FUNCTION(3, "DFD_TMS")
	),
	MTK_PIN(PINCTRL_PIN(147, "JTRSTB_ICE"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 152),
		MTK_FUNCTION(0, "GPIO147"),
		MTK_FUNCTION(1, "JTRST_B_ICE"),
		MTK_FUNCTION(3, "DFD_NTRST")
	),
	MTK_PIN(PINCTRL_PIN(148, "GPIO148"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 153),
		MTK_FUNCTION(0, "GPIO148"),
		MTK_FUNCTION(1, "JTRSTB_CM4"),
		MTK_FUNCTION(3, "DFD_NTRST")
	),
	MTK_PIN(PINCTRL_PIN(149, "GPIO149"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 154),
		MTK_FUNCTION(0, "GPIO149"),
		MTK_FUNCTION(1, "JTCK_CM4"),
		MTK_FUNCTION(3, "DFD_TCK")
	),
	MTK_PIN(PINCTRL_PIN(150, "GPIO150"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 155),
		MTK_FUNCTION(0, "GPIO150"),
		MTK_FUNCTION(1, "JTMS_CM4"),
		MTK_FUNCTION(3, "DFD_TMS")
	),
	MTK_PIN(PINCTRL_PIN(151, "GPIO151"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 156),
		MTK_FUNCTION(0, "GPIO151"),
		MTK_FUNCTION(1, "JTDI_CM4"),
		MTK_FUNCTION(3, "DFD_TDI")
	),
	MTK_PIN(PINCTRL_PIN(152, "GPIO152"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 157),
		MTK_FUNCTION(0, "GPIO152"),
		MTK_FUNCTION(1, "JTDO_CM4"),
		MTK_FUNCTION(3, "DFD_TDO")
	),
	MTK_PIN(PINCTRL_PIN(153, "SPI0_CSN"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 158),
		MTK_FUNCTION(0, "GPIO153"),
		MTK_FUNCTION(1, "SPI_CS_0_"),
		MTK_FUNCTION(2, "SRCLKENA0"),
		MTK_FUNCTION(3, "UTXD0"),
		MTK_FUNCTION(4, "I2SO0_DO1"),
		MTK_FUNCTION(6, "TDMO0_DATA1"),
		MTK_FUNCTION(7, "I2S_IQ2_SDQB")
	),
	MTK_PIN(PINCTRL_PIN(154, "SPI0_MI"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 159),
		MTK_FUNCTION(0, "GPIO154"),
		MTK_FUNCTION(1, "SPI_MI_0_"),
		MTK_FUNCTION(2, "SRCLKENA0"),
		MTK_FUNCTION(3, "URXD0"),
		MTK_FUNCTION(4, "I2SO0_DO0"),
		MTK_FUNCTION(5, "I2SO1_DO"),
		MTK_FUNCTION(6, "TDMO0_DATA"),
		MTK_FUNCTION(7, "I2S_IQ1_SDIB")
	),
	MTK_PIN(PINCTRL_PIN(155, "SPI0_CK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 160),
		MTK_FUNCTION(0, "GPIO155"),
		MTK_FUNCTION(1, "SPI_CK_0_"),
		MTK_FUNCTION(2, "SC_APBIAS_OFF"),
		MTK_FUNCTION(3, "UTXD1"),
		MTK_FUNCTION(4, "I2SO0_BCK"),
		MTK_FUNCTION(5, "I2SO1_BCK"),
		MTK_FUNCTION(6, "TDMO0_BCK"),
		MTK_FUNCTION(7, "I2S_IQ0_SDQB")
	),
	MTK_PIN(PINCTRL_PIN(156, "SPI0_MO"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 161),
		MTK_FUNCTION(0, "GPIO156"),
		MTK_FUNCTION(1, "SPI_MO_0_"),
		MTK_FUNCTION(2, "SC_APBIAS_OFF"),
		MTK_FUNCTION(3, "URXD1"),
		MTK_FUNCTION(4, "I2SO0_WS"),
		MTK_FUNCTION(5, "I2SO1_WS"),
		MTK_FUNCTION(6, "TDMO0_LRCK"),
		MTK_FUNCTION(7, "I2S_IQ0_SDIB")
	),
	MTK_PIN(PINCTRL_PIN(157, "SPI5_CSN"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 162),
		MTK_FUNCTION(0, "GPIO157"),
		MTK_FUNCTION(1, "SPI_CS_5_"),
		MTK_FUNCTION(2, "LCM_RST0"),
		MTK_FUNCTION(3, "UTXD2"),
		MTK_FUNCTION(4, "I2SO0_MCK"),
		MTK_FUNCTION(5, "I2SO1_MCK"),
		MTK_FUNCTION(6, "TDMO0_MCLK")
	),
	MTK_PIN(PINCTRL_PIN(158, "SPI5_MI"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 163),
		MTK_FUNCTION(0, "GPIO158"),
		MTK_FUNCTION(1, "SPI_MI_5_"),
		MTK_FUNCTION(2, "DSIA_TE"),
		MTK_FUNCTION(3, "URXD2")
	),
	MTK_PIN(PINCTRL_PIN(159, "SPI5_MO"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 164),
		MTK_FUNCTION(0, "GPIO159"),
		MTK_FUNCTION(1, "SPI_MO_5_"),
		MTK_FUNCTION(2, "DSIB_TE"),
		MTK_FUNCTION(3, "UTXD3")
	),
	MTK_PIN(PINCTRL_PIN(160, "SPI5_CK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 165),
		MTK_FUNCTION(0, "GPIO160"),
		MTK_FUNCTION(1, "SPI_CK_5_"),
		MTK_FUNCTION(2, "LCM_RST1"),
		MTK_FUNCTION(3, "URXD3")
	),
	MTK_PIN(PINCTRL_PIN(161, "SPI1_CSN"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 166),
		MTK_FUNCTION(0, "GPIO161"),
		MTK_FUNCTION(1, "SPI_CS_1_"),
		MTK_FUNCTION(2, "SPI_CS_4_"),
		MTK_FUNCTION(4, "I2S_IQ2_SDQB"),
		MTK_FUNCTION(5, "I2SO2_DO"),
		MTK_FUNCTION(6, "TDMO0_DATA1"),
		MTK_FUNCTION(7, "I2SO0_DO1")
	),
	MTK_PIN(PINCTRL_PIN(162, "SPI1_SI"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 167),
		MTK_FUNCTION(0, "GPIO162"),
		MTK_FUNCTION(1, "SPI_SI_1_"),
		MTK_FUNCTION(2, "SPI_MI_4_"),
		MTK_FUNCTION(4, "I2S_IQ1_SDIB"),
		MTK_FUNCTION(5, "I2SO2_BCK"),
		MTK_FUNCTION(6, "TDMO0_DATA"),
		MTK_FUNCTION(7, "I2SO0_DO0")
	),
	MTK_PIN(PINCTRL_PIN(163, "SPI1_CK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 168),
		MTK_FUNCTION(0, "GPIO163"),
		MTK_FUNCTION(1, "SPI_CK_1_"),
		MTK_FUNCTION(2, "SPI_CK_4_"),
		MTK_FUNCTION(4, "I2S_IQ0_SDQB"),
		MTK_FUNCTION(5, "I2SO2_WS"),
		MTK_FUNCTION(6, "TDMO0_BCK"),
		MTK_FUNCTION(7, "I2SO0_BCK")
	),
	MTK_PIN(PINCTRL_PIN(164, "SPI1_SO"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 169),
		MTK_FUNCTION(0, "GPIO164"),
		MTK_FUNCTION(1, "SPI_SO_1_"),
		MTK_FUNCTION(2, "SPI_MO_4_"),
		MTK_FUNCTION(4, "I2S_IQ0_SDIB"),
		MTK_FUNCTION(5, "I2SO2_MCK"),
		MTK_FUNCTION(6, "TDMO0_LRCK"),
		MTK_FUNCTION(7, "I2SO0_WS")
	),
	MTK_PIN(PINCTRL_PIN(165, "SPI4_CSN"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 170),
		MTK_FUNCTION(0, "GPIO165"),
		MTK_FUNCTION(1, "SPI_CS_4_"),
		MTK_FUNCTION(2, "LCM_RST0"),
		MTK_FUNCTION(3, "SPI_CS_1_"),
		MTK_FUNCTION(4, "UTXD4"),
		MTK_FUNCTION(5, "I2SO1_DO"),
		MTK_FUNCTION(6, "TDMO0_MCLK"),
		MTK_FUNCTION(7, "I2SO0_MCK")
	),
	MTK_PIN(PINCTRL_PIN(166, "SPI4_MI"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 171),
		MTK_FUNCTION(0, "GPIO166"),
		MTK_FUNCTION(1, "SPI_MI_4_"),
		MTK_FUNCTION(2, "DSIA_TE"),
		MTK_FUNCTION(3, "SPI_SI_1_"),
		MTK_FUNCTION(4, "URXD4"),
		MTK_FUNCTION(5, "I2SO1_BCK")
	),
	MTK_PIN(PINCTRL_PIN(167, "SPI4_MO"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 172),
		MTK_FUNCTION(0, "GPIO167"),
		MTK_FUNCTION(1, "SPI_MO_4_"),
		MTK_FUNCTION(2, "DSIB_TE"),
		MTK_FUNCTION(3, "SPI_SO_1_"),
		MTK_FUNCTION(4, "UTXD5"),
		MTK_FUNCTION(5, "I2SO1_WS")
	),
	MTK_PIN(PINCTRL_PIN(168, "SPI4_CK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 173),
		MTK_FUNCTION(0, "GPIO168"),
		MTK_FUNCTION(1, "SPI_CK_4_"),
		MTK_FUNCTION(2, "LCM_RST1"),
		MTK_FUNCTION(3, "SPI_CK_1_"),
		MTK_FUNCTION(4, "URXD5"),
		MTK_FUNCTION(5, "I2SO1_MCK")
	),
	MTK_PIN(PINCTRL_PIN(169, "I2SI0_DATA"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 174),
		MTK_FUNCTION(0, "GPIO169"),
		MTK_FUNCTION(1, "I2SI0_DI"),
		MTK_FUNCTION(2, "I2SI1_DI"),
		MTK_FUNCTION(3, "I2SI2_DI"),
		MTK_FUNCTION(4, "TDMIN_DI")
	),
	MTK_PIN(PINCTRL_PIN(170, "I2SI0_LRCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 175),
		MTK_FUNCTION(0, "GPIO170"),
		MTK_FUNCTION(1, "I2SI0_WS"),
		MTK_FUNCTION(2, "I2SI1_WS"),
		MTK_FUNCTION(3, "I2SI2_WS"),
		MTK_FUNCTION(4, "TDMIN_LRCK"),
		MTK_FUNCTION(5, "TDMO0_DATA3"),
		MTK_FUNCTION(6, "TDMO1_DATA3")
	),
	MTK_PIN(PINCTRL_PIN(171, "I2SI0_MCLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 176),
		MTK_FUNCTION(0, "GPIO171"),
		MTK_FUNCTION(1, "I2SI0_MCK"),
		MTK_FUNCTION(2, "I2SI1_MCK"),
		MTK_FUNCTION(3, "I2SI2_MCK"),
		MTK_FUNCTION(4, "TDMIN_MCLK"),
		MTK_FUNCTION(5, "TDMO0_DATA2"),
		MTK_FUNCTION(6, "TDMO1_DATA2")
	),
	MTK_PIN(PINCTRL_PIN(172, "I2SI0_BCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 177),
		MTK_FUNCTION(0, "GPIO172"),
		MTK_FUNCTION(1, "I2SI0_BCK"),
		MTK_FUNCTION(2, "I2SI1_BCK"),
		MTK_FUNCTION(3, "I2SI2_BCK"),
		MTK_FUNCTION(4, "TDMIN_BCK"),
		MTK_FUNCTION(5, "TDMO0_DATA1"),
		MTK_FUNCTION(6, "TDMO1_DATA1")
	),
	MTK_PIN(PINCTRL_PIN(173, "I2SI2_DATA"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 178),
		MTK_FUNCTION(0, "GPIO173"),
		MTK_FUNCTION(1, "I2SI2_DI"),
		MTK_FUNCTION(2, "I2SI0_DI"),
		MTK_FUNCTION(3, "I2SI1_DI"),
		MTK_FUNCTION(4, "PCM1_DI"),
		MTK_FUNCTION(5, "TDMIN_DI"),
		MTK_FUNCTION(6, "PCM1_DO")
	),
	MTK_PIN(PINCTRL_PIN(174, "I2SI2_MCLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 179),
		MTK_FUNCTION(0, "GPIO174"),
		MTK_FUNCTION(1, "I2SI2_MCK"),
		MTK_FUNCTION(2, "I2SI0_MCK"),
		MTK_FUNCTION(3, "I2SI1_MCK"),
		MTK_FUNCTION(4, "PCM1_DO"),
		MTK_FUNCTION(5, "TDMIN_MCLK"),
		MTK_FUNCTION(6, "PCM1_DI"),
		MTK_FUNCTION(7, "I2S_IQ2_SDQB")
	),
	MTK_PIN(PINCTRL_PIN(175, "I2SI2_BCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 180),
		MTK_FUNCTION(0, "GPIO175"),
		MTK_FUNCTION(1, "I2SI2_BCK"),
		MTK_FUNCTION(2, "I2SI0_BCK"),
		MTK_FUNCTION(3, "I2SI1_BCK"),
		MTK_FUNCTION(4, "PCM1_CLK"),
		MTK_FUNCTION(5, "TDMIN_BCK")
	),
	MTK_PIN(PINCTRL_PIN(176, "I2SI2_LRCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 181),
		MTK_FUNCTION(0, "GPIO176"),
		MTK_FUNCTION(1, "I2SI2_WS"),
		MTK_FUNCTION(2, "I2SI0_WS"),
		MTK_FUNCTION(3, "I2SI1_WS"),
		MTK_FUNCTION(4, "PCM1_SYNC"),
		MTK_FUNCTION(5, "TDMIN_LRCK")
	),
	MTK_PIN(PINCTRL_PIN(177, "I2SI1_DATA"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 182),
		MTK_FUNCTION(0, "GPIO177"),
		MTK_FUNCTION(1, "I2SI1_DI"),
		MTK_FUNCTION(2, "I2SI0_DI"),
		MTK_FUNCTION(3, "I2SI2_DI"),
		MTK_FUNCTION(4, "TDMIN_DI")
	),
	MTK_PIN(PINCTRL_PIN(178, "I2SI1_BCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 183),
		MTK_FUNCTION(0, "GPIO178"),
		MTK_FUNCTION(1, "I2SI1_BCK"),
		MTK_FUNCTION(2, "I2SI0_BCK"),
		MTK_FUNCTION(3, "I2SI2_BCK"),
		MTK_FUNCTION(4, "TDMIN_BCK"),
		MTK_FUNCTION(5, "TDMO0_DATA3"),
		MTK_FUNCTION(6, "TDMO1_DATA3")
	),
	MTK_PIN(PINCTRL_PIN(179, "I2SI1_LRCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 184),
		MTK_FUNCTION(0, "GPIO179"),
		MTK_FUNCTION(1, "I2SI1_WS"),
		MTK_FUNCTION(2, "I2SI0_WS"),
		MTK_FUNCTION(3, "I2SI2_WS"),
		MTK_FUNCTION(4, "TDMIN_LRCK"),
		MTK_FUNCTION(5, "TDMO0_DATA2"),
		MTK_FUNCTION(6, "TDMO1_DATA2")
	),
	MTK_PIN(PINCTRL_PIN(180, "I2SI1_MCLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 185),
		MTK_FUNCTION(0, "GPIO180"),
		MTK_FUNCTION(1, "I2SI1_MCK"),
		MTK_FUNCTION(2, "I2SI0_MCK"),
		MTK_FUNCTION(3, "I2SI2_MCK"),
		MTK_FUNCTION(4, "TDMIN_MCLK"),
		MTK_FUNCTION(5, "TDMO0_DATA1"),
		MTK_FUNCTION(6, "TDMO1_DATA1"),
		MTK_FUNCTION(7, "I2S_IQ2_SDIB")
	),
	MTK_PIN(PINCTRL_PIN(181, "I2SO1_DATA0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 186),
		MTK_FUNCTION(0, "GPIO181"),
		MTK_FUNCTION(1, "I2SO1_DO"),
		MTK_FUNCTION(2, "I2SO0_DO0"),
		MTK_FUNCTION(3, "I2SO2_DO"),
		MTK_FUNCTION(4, "DAI_TX"),
		MTK_FUNCTION(5, "TDMIN_MCLK"),
		MTK_FUNCTION(7, "I2S_IQ2_SDIA")
	),
	MTK_PIN(PINCTRL_PIN(182, "I2SO1_BCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 187),
		MTK_FUNCTION(0, "GPIO182"),
		MTK_FUNCTION(1, "I2SO1_BCK"),
		MTK_FUNCTION(2, "I2SO0_BCK"),
		MTK_FUNCTION(3, "I2SO2_BCK"),
		MTK_FUNCTION(4, "DAI_SYNC"),
		MTK_FUNCTION(5, "TDMIN_BCK"),
		MTK_FUNCTION(6, "TDMO0_DATA3"),
		MTK_FUNCTION(7, "I2S_IQ2_BCK")
	),
	MTK_PIN(PINCTRL_PIN(183, "I2SO1_LRCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 188),
		MTK_FUNCTION(0, "GPIO183"),
		MTK_FUNCTION(1, "I2SO1_WS"),
		MTK_FUNCTION(2, "I2SO0_WS"),
		MTK_FUNCTION(3, "I2SO2_WS"),
		MTK_FUNCTION(4, "DAI_CLK"),
		MTK_FUNCTION(5, "TDMIN_DI"),
		MTK_FUNCTION(6, "TDMO0_DATA2"),
		MTK_FUNCTION(7, "I2S_IQ2_WS")
	),
	MTK_PIN(PINCTRL_PIN(184, "I2SO1_MCLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 189),
		MTK_FUNCTION(0, "GPIO184"),
		MTK_FUNCTION(1, "I2SO1_MCK"),
		MTK_FUNCTION(2, "I2SO0_MCK"),
		MTK_FUNCTION(3, "I2SO2_MCK"),
		MTK_FUNCTION(4, "DAI_RX"),
		MTK_FUNCTION(5, "TDMIN_LRCK"),
		MTK_FUNCTION(6, "TDMO0_DATA1"),
		MTK_FUNCTION(7, "I2S_IQ2_SDQA")
	),
	MTK_PIN(PINCTRL_PIN(185, "AUD_EXT_CK2"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 190),
		MTK_FUNCTION(0, "GPIO185"),
		MTK_FUNCTION(1, "AUD_EXT_CK2"),
		MTK_FUNCTION(2, "AUD_EXT_CK1"),
		MTK_FUNCTION(3, "I2SO1_DO"),
		MTK_FUNCTION(4, "I2SI2_DI"),
		MTK_FUNCTION(5, "MRG_RX"),
		MTK_FUNCTION(6, "PCM1_DI"),
		MTK_FUNCTION(7, "I2S_IQ0_SDQB")
	),
	MTK_PIN(PINCTRL_PIN(186, "AUD_EXT_CK1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 191),
		MTK_FUNCTION(0, "GPIO186"),
		MTK_FUNCTION(1, "AUD_EXT_CK1"),
		MTK_FUNCTION(2, "AUD_EXT_CK2"),
		MTK_FUNCTION(3, "I2SO0_DO1"),
		MTK_FUNCTION(4, "I2SI1_DI"),
		MTK_FUNCTION(5, "MRG_TX"),
		MTK_FUNCTION(6, "PCM1_DO"),
		MTK_FUNCTION(7, "I2S_IQ0_SDIB")
	),
	MTK_PIN(PINCTRL_PIN(187, "I2SO2_BCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 192),
		MTK_FUNCTION(0, "GPIO187"),
		MTK_FUNCTION(1, "I2SO2_BCK"),
		MTK_FUNCTION(2, "I2SO0_BCK"),
		MTK_FUNCTION(3, "I2SO1_BCK"),
		MTK_FUNCTION(4, "PCM1_CLK"),
		MTK_FUNCTION(5, "MRG_SYNC"),
		MTK_FUNCTION(6, "TDMO1_DATA3"),
		MTK_FUNCTION(7, "I2S_IQ0_BCK")
	),
	MTK_PIN(PINCTRL_PIN(188, "I2SO2_LRCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 193),
		MTK_FUNCTION(0, "GPIO188"),
		MTK_FUNCTION(1, "I2SO2_WS"),
		MTK_FUNCTION(2, "I2SO0_WS"),
		MTK_FUNCTION(3, "I2SO1_WS"),
		MTK_FUNCTION(4, "PCM1_SYNC"),
		MTK_FUNCTION(5, "MRG_CLK"),
		MTK_FUNCTION(6, "TDMO1_DATA2"),
		MTK_FUNCTION(7, "I2S_IQ0_WS")
	),
	MTK_PIN(PINCTRL_PIN(189, "I2SO2_MCLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 194),
		MTK_FUNCTION(0, "GPIO189"),
		MTK_FUNCTION(1, "I2SO2_MCK"),
		MTK_FUNCTION(2, "I2SO0_MCK"),
		MTK_FUNCTION(3, "I2SO1_MCK"),
		MTK_FUNCTION(4, "PCM1_DO"),
		MTK_FUNCTION(5, "MRG_RX"),
		MTK_FUNCTION(6, "TDMO1_DATA1"),
		MTK_FUNCTION(7, "I2S_IQ0_SDQA")
	),
	MTK_PIN(PINCTRL_PIN(190, "I2SO2_DATA0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 195),
		MTK_FUNCTION(0, "GPIO190"),
		MTK_FUNCTION(1, "I2SO2_DO"),
		MTK_FUNCTION(2, "I2SO0_DO0"),
		MTK_FUNCTION(3, "I2SO1_DO"),
		MTK_FUNCTION(4, "PCM1_DI"),
		MTK_FUNCTION(5, "MRG_TX"),
		MTK_FUNCTION(6, "PCM1_DO"),
		MTK_FUNCTION(7, "I2S_IQ0_SDIA")
	),
	MTK_PIN(PINCTRL_PIN(191, "I2SO0_DATA1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 196),
		MTK_FUNCTION(0, "GPIO191"),
		MTK_FUNCTION(1, "I2SO0_DO1"),
		MTK_FUNCTION(2, "I2SI0_DI"),
		MTK_FUNCTION(3, "I2SI1_DI"),
		MTK_FUNCTION(4, "I2SI2_DI"),
		MTK_FUNCTION(5, "DAI_TX"),
		MTK_FUNCTION(6, "I2S_IQ0_SDQB"),
		MTK_FUNCTION(7, "I2S_IQ1_SDQB")
	),
	MTK_PIN(PINCTRL_PIN(192, "I2SO0_MCLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 197),
		MTK_FUNCTION(0, "GPIO192"),
		MTK_FUNCTION(1, "I2SO0_MCK"),
		MTK_FUNCTION(2, "I2SO1_MCK"),
		MTK_FUNCTION(3, "I2SO2_MCK"),
		MTK_FUNCTION(4, "USB4_FT_SCL"),
		MTK_FUNCTION(5, "TDMO1_DATA3"),
		MTK_FUNCTION(6, "I2S_IQ0_SDIB"),
		MTK_FUNCTION(7, "I2S_IQ1_SDQA")
	),
	MTK_PIN(PINCTRL_PIN(193, "I2SO0_DATA0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 198),
		MTK_FUNCTION(0, "GPIO193"),
		MTK_FUNCTION(1, "I2SO0_DO0"),
		MTK_FUNCTION(2, "I2SO1_DO"),
		MTK_FUNCTION(3, "I2SO2_DO"),
		MTK_FUNCTION(4, "USB4_FT_SDA"),
		MTK_FUNCTION(7, "I2S_IQ1_SDIA")
	),
	MTK_PIN(PINCTRL_PIN(194, "I2SO0_LRCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 199),
		MTK_FUNCTION(0, "GPIO194"),
		MTK_FUNCTION(1, "I2SO0_WS"),
		MTK_FUNCTION(2, "I2SO1_WS"),
		MTK_FUNCTION(3, "I2SO2_WS"),
		MTK_FUNCTION(4, "USB5_FT_SCL"),
		MTK_FUNCTION(5, "TDMO1_DATA2"),
		MTK_FUNCTION(7, "I2S_IQ1_WS")
	),
	MTK_PIN(PINCTRL_PIN(195, "I2SO0_BCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 200),
		MTK_FUNCTION(0, "GPIO195"),
		MTK_FUNCTION(1, "I2SO0_BCK"),
		MTK_FUNCTION(2, "I2SO1_BCK"),
		MTK_FUNCTION(3, "I2SO2_BCK"),
		MTK_FUNCTION(4, "USB5_FT_SDA"),
		MTK_FUNCTION(5, "TDMO1_DATA1"),
		MTK_FUNCTION(7, "I2S_IQ1_BCK")
	),
	MTK_PIN(PINCTRL_PIN(196, "TDMO1_MCLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 201),
		MTK_FUNCTION(0, "GPIO196"),
		MTK_FUNCTION(1, "TDMO1_MCLK"),
		MTK_FUNCTION(2, "TDMO0_MCLK"),
		MTK_FUNCTION(3, "TDMIN_MCLK"),
		MTK_FUNCTION(6, "I2SO0_DO1"),
		MTK_FUNCTION(7, "I2S_IQ1_SDIB")
	),
	MTK_PIN(PINCTRL_PIN(197, "TDMO1_LRCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 202),
		MTK_FUNCTION(0, "GPIO197"),
		MTK_FUNCTION(1, "TDMO1_LRCK"),
		MTK_FUNCTION(2, "TDMO0_LRCK"),
		MTK_FUNCTION(3, "TDMIN_LRCK"),
		MTK_FUNCTION(4, "TDMO0_DATA3"),
		MTK_FUNCTION(5, "TDMO1_DATA3"),
		MTK_FUNCTION(6, "I2SO3_MCK"),
		MTK_FUNCTION(7, "TDMO1_DATA2")
	),
	MTK_PIN(PINCTRL_PIN(198, "TDMO1_BCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 203),
		MTK_FUNCTION(0, "GPIO198"),
		MTK_FUNCTION(1, "TDMO1_BCK"),
		MTK_FUNCTION(2, "TDMO0_BCK"),
		MTK_FUNCTION(3, "TDMIN_BCK"),
		MTK_FUNCTION(4, "TDMO0_DATA2"),
		MTK_FUNCTION(5, "TDMO1_DATA2"),
		MTK_FUNCTION(6, "I2SO3_BCK"),
		MTK_FUNCTION(7, "TDMO1_DATA1")
	),
	MTK_PIN(PINCTRL_PIN(199, "TDMO1_DATA"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 204),
		MTK_FUNCTION(0, "GPIO199"),
		MTK_FUNCTION(1, "TDMO1_DATA"),
		MTK_FUNCTION(2, "TDMO0_DATA"),
		MTK_FUNCTION(3, "TDMIN_DI"),
		MTK_FUNCTION(4, "TDMO0_DATA1"),
		MTK_FUNCTION(5, "TDMO1_DATA1"),
		MTK_FUNCTION(6, "I2SO3_WS")
	),
	MTK_PIN(PINCTRL_PIN(200, "TDMO0_MCLK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 205),
		MTK_FUNCTION(0, "GPIO200"),
		MTK_FUNCTION(1, "TDMO0_MCLK"),
		MTK_FUNCTION(2, "TDMO1_MCLK"),
		MTK_FUNCTION(3, "PCM1_DI"),
		MTK_FUNCTION(4, "TDMO0_MCLK"),
		MTK_FUNCTION(5, "TDMO1_MCLK"),
		MTK_FUNCTION(6, "MRG_TX"),
		MTK_FUNCTION(7, "I2SO2_MCK")
	),
	MTK_PIN(PINCTRL_PIN(201, "TDMO0_LRCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 206),
		MTK_FUNCTION(0, "GPIO201"),
		MTK_FUNCTION(1, "TDMO0_LRCK"),
		MTK_FUNCTION(2, "TDMO1_LRCK"),
		MTK_FUNCTION(3, "PCM1_SYNC"),
		MTK_FUNCTION(4, "TDMO0_LRCK"),
		MTK_FUNCTION(5, "TDMO1_LRCK"),
		MTK_FUNCTION(6, "MRG_RX"),
		MTK_FUNCTION(7, "I2SO2_WS")
	),
	MTK_PIN(PINCTRL_PIN(202, "TDMO0_BCK"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 207),
		MTK_FUNCTION(0, "GPIO202"),
		MTK_FUNCTION(1, "TDMO0_BCK"),
		MTK_FUNCTION(2, "TDMO1_BCK"),
		MTK_FUNCTION(3, "PCM1_CLK"),
		MTK_FUNCTION(4, "TDMO0_BCK"),
		MTK_FUNCTION(5, "TDMO1_BCK"),
		MTK_FUNCTION(6, "MRG_SYNC"),
		MTK_FUNCTION(7, "I2SO2_BCK")
	),
	MTK_PIN(PINCTRL_PIN(203, "TDMO0_DATA"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 208),
		MTK_FUNCTION(0, "GPIO203"),
		MTK_FUNCTION(1, "TDMO0_DATA"),
		MTK_FUNCTION(2, "TDMO1_DATA"),
		MTK_FUNCTION(3, "PCM1_DO"),
		MTK_FUNCTION(4, "TDMO0_DATA"),
		MTK_FUNCTION(5, "TDMO1_DATA"),
		MTK_FUNCTION(6, "MRG_CLK"),
		MTK_FUNCTION(7, "I2SO2_DO")
	),
	MTK_PIN(PINCTRL_PIN(204, "PERSTB_P0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 209),
		MTK_FUNCTION(0, "GPIO204"),
		MTK_FUNCTION(1, "PERST_B_P0")
	),
	MTK_PIN(PINCTRL_PIN(205, "CLKREQN_P0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 210),
		MTK_FUNCTION(0, "GPIO205"),
		MTK_FUNCTION(1, "CLKREQ_N_P0")
	),
	MTK_PIN(PINCTRL_PIN(206, "WAKEEN_P0"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 211),
		MTK_FUNCTION(0, "GPIO206"),
		MTK_FUNCTION(1, "WAKE_EN_P0")
	),
	MTK_PIN(PINCTRL_PIN(207, "PERSTB_P1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 212),
		MTK_FUNCTION(0, "GPIO207"),
		MTK_FUNCTION(1, "PERST_B_P1")
	),
	MTK_PIN(PINCTRL_PIN(208, "CLKREQN_P1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 213),
		MTK_FUNCTION(0, "GPIO208"),
		MTK_FUNCTION(1, "CLKREQ_N_P1")
	),
	MTK_PIN(PINCTRL_PIN(209, "WAKEEN_P1"),
		NULL, "mt2712",
		MTK_EINT_FUNCTION(0, 214),
		MTK_FUNCTION(0, "GPIO209"),
		MTK_FUNCTION(1, "WAKE_EN_P1")
	),
};

#endif /* __PINCTRL_MTK_MT2712_H */
