/* pam_login_alert module */

/* 
 * read_conf.c - Parse the pam_alert configuration file.
 * 
 * Configuration file format is:
 * # comment
 * option value # comment
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <syslog.h>
#include "pam_login_alert.h"

static int getword(char *line, char *word, int i, int n);

/* 
 * read_conf() - read and parse the configuration file
 * does not preset parms to anything not defined in the configuration file
 */

extern
int read_conf(char *fname, alert_parms_t *parms)
{
	FILE *fp;
	char buf[MAX_LINE];

	/* open the configuration file */
	fp = fopen(fname, "r");
	if (fp == NULL)
	{
		printerr("cannot open %s", fname);
		return 0;
	}

	/* parse and act on each line */
	while (getline(buf, MAX_LINE, fp))
	{
		/* check if we don't have a comment/empty line */
		if (strlen(buf) > 0)
		{
			char option[MAX_WORD], value[MAX_WORD];

			getword(buf, option, 1, MAX_WORD);
			getword(buf, value, 2, MAX_WORD);

			/* we should always have both an option and value */
			if (strlen(option) < 1 || strlen(value) < 1)
				printerr("incorrect syntax on '%s'", buf);
			/* mail on|off */
			else if (!strcasecmp(option, "mail"))
			{
				if (!strcasecmp(value, "on"))
					parms->mail = ON;
				else if (!strcasecmp(value, "off"))
					parms->mail = OFF;
				else 
					printerr("invalid mail value specified");
			}
			/* email email_addy*/
			else if (!strcasecmp(option, "email"))
				strncpy(parms->email, value, MAX_EMAIL);
			/* syslog on|off */
			else if (!strcasecmp(option, "syslog"))
			{
				if (!strcasecmp(value, "on"))
					parms->syslog = ON;
				else if (!strcasecmp(value, "off"))
					parms->syslog = OFF;
				else
					printerr("invalid syslog value specified");
			}
			/* syslog_facility facility */
			else if (!strcasecmp(option, "syslog_facility"))
			{
				if (!strcasecmp(value, "LOG_AUTH"))
					parms->syslog_facility = LOG_AUTH;
				else if (!strcasecmp(value, "LOG_AUTHPRIV"))
					parms->syslog_facility = LOG_AUTHPRIV;
				else if (!strcasecmp(value, "LOG_DAEMON"))
					parms->syslog_facility = LOG_DAEMON;
				else if (!strcasecmp(value, "LOG_LOCAL0"))
					parms->syslog_facility = LOG_LOCAL0;
				else if (!strcasecmp(value, "LOG_LOCAL1"))
					parms->syslog_facility = LOG_LOCAL1;
				else if (!strcasecmp(value, "LOG_LOCAL2"))
					parms->syslog_facility = LOG_LOCAL2;
				else if (!strcasecmp(value, "LOG_LOCAL3"))
					parms->syslog_facility = LOG_LOCAL3;
				else if (!strcasecmp(value, "LOG_LOCAL4"))
					parms->syslog_facility = LOG_LOCAL4;
				else if (!strcasecmp(value, "LOG_LOCAL5"))
					parms->syslog_facility = LOG_LOCAL5;
				else if (!strcasecmp(value, "LOG_LOCAL6"))
					parms->syslog_facility = LOG_LOCAL6;
				else if (!strcasecmp(value, "LOG_LOCAL7"))
					parms->syslog_facility = LOG_LOCAL7;
				else
					printerr("invalid syslog facility specified");
			}
			/* syslog_priority priority */
			else if (!strcasecmp(option, "syslog_priority"))
			{
				if (!strcasecmp(value, "LOG_INFO"))
					parms->syslog_priority = LOG_INFO;
				else if (!strcasecmp(value, "LOG_NOTICE"))
					parms->syslog_priority = LOG_NOTICE;
				else if (!strcasecmp(value, "LOG_WARNING"))
					parms->syslog_priority = LOG_WARNING;
				else if (!strcasecmp(value, "LOG_ERR"))
					parms->syslog_priority = LOG_ERR;
				else if (!strcasecmp(value, "LOG_CRIT"))
					parms->syslog_priority = LOG_CRIT;
				else if (!strcasecmp(value, "LOG_ALERT"))
					parms->syslog_priority = LOG_ALERT;
				else if (!strcasecmp(value, "LOG_EMERG"))
					parms->syslog_priority = LOG_EMERG;
				else
					printerr("invalid syslog priority specified");
			}
			/* user_list fname */
			else if (!strcasecmp(option, "user_list"))
				strncpy(parms->users_fname, value, MAX_FILENAME);
			/* unknown */
			else
				printerr("incorect syntax on '%s'", buf);
		}
	}

	fclose(fp);
	return 1;
}

/*
 * getword() - get word i of maxsize n from a line of text
 * guarantees that word is always a valid string to make things simple
 */

static
int getword(char *line, char *word, int i, int n)
{
	char nline[MAX_LINE], *nword;
	char *delim = " \t";
	int flag;

	/* make a copy of line since strtok() modifies it's arguments */
	strncpy(nline, line, MAX_LINE);

	flag = 0;
	word[0] = '\0';

	/* we need the first word */
	if (i == 1)
	{
		nword = strtok(nline, delim);
		if (nword != NULL)
			flag = 1;
	}
	/* we need the 2nd or greater word */
	else if (i > 1)
	{
		int cur;

		strtok(nline, delim);
		for (cur = 2; cur <= i; cur++)
			nword = strtok(NULL, delim);

		if (nword != NULL)
			flag = 1;
	}

	if (flag)
		strncpy(word, nword, n);

	return flag;
}

