/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef CAMERA_H
#define CAMERA_H

#include <epoxy/gl.h>
#include <glm/glm.hpp>

namespace libgltf
{

class CPhysicalCamera
{
public:
    double fSensitivity;
    double flength;
    glm::vec3 vModelCenterPos;

    void setViewMatrix(const glm::mat4& rViewMatrix);
    const glm::mat4& getViewMatrix() const;

    void setAerialView( bool bAerialView );
    void getCameraPosVectors(glm::vec3* pEye, glm::vec3* pView, glm::vec3* pUp) const;

    void setPerspective(const glm::mat4& Perspective);
    const glm::mat4& getPerspective() const;

    void moveCamera(double x, double y, double z, double time);

    void updateViewMatrix();

    void rotateObjectMouse(double horizontal, double vertical,
                           double planar);
    void rotateCamera(double horizontal, double vertical,
                      double planar);

    CPhysicalCamera();
private:
    glm::mat4 mViewMatrix;
    glm::mat4 mProjection;

    bool mbAerialView;

    glm::vec3 vSpeed;
    bool bMove_camera_flag;
    float mMoveTime;
    double mLastTimeStamp;
};

} // namespace libgltf

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
