/*
   Copyright (C) 2019-2020 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "snippetcustomfileattachmentnamewidgettest.h"
#include "snippets/snippetcustomfileattachmentnamewidget.h"
#include <QLineEdit>
#include <QPushButton>
#include <QTest>
#include <QVBoxLayout>
QTEST_MAIN(SnippetCustomFileAttachmentNameWidgetTest)

SnippetCustomFileAttachmentNameWidgetTest::SnippetCustomFileAttachmentNameWidgetTest(QObject *parent)
    : QObject(parent)
{
}

void SnippetCustomFileAttachmentNameWidgetTest::shouldHaveDefaultValues()
{
    MailCommon::SnippetCustomFileAttachmentNameWidget w;
    QVBoxLayout *mainLayout = w.findChild<QVBoxLayout *>(QStringLiteral("mainLayout"));
    QVERIFY(mainLayout);
    QCOMPARE(mainLayout->contentsMargins(), QMargins(0, 0, 0, 0));

    QLineEdit *mLineEdit = w.findChild<QLineEdit *>(QStringLiteral("mLineEdit"));
    QVERIFY(mLineEdit);
    QVERIFY(mLineEdit->text().isEmpty());

    QPushButton *selectVariable = w.findChild<QPushButton *>(QStringLiteral("selectVariable"));
    QVERIFY(selectVariable);
    QVERIFY(!selectVariable->text().isEmpty());
    QVERIFY(selectVariable->menu());
}
