## Usage

```js
var getter = require('{%= name %}');
```

{%= name %} works like [set-value][] by adding a property to an object or an object hierarchy using dot notation. The main difference is that the property is added using `Object.defineProperty` and is expected to be a getter function that returns a value.

**Example**

```js
var obj = {};

// root level property
getter(obj, 'foo', function() {
  return 'bar';
});
console.log(obj.foo);
//=> 'bar'

// property dot notation
getter(obj, 'bar.baz', function() {
  return 'qux';
});
console.log(obj.bar.baz);
//=> 'qux'

// property array notation
getter(obj, ['beep', 'boop'], function() {
  return 'bop';
});
console.log(obj.beep.boop);
//=> 'bop'
```

## API
{%= apidocs("index.js") %}
