# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import SecurityInsightsConfiguration
from .operations import (
    ActionsOperations,
    AlertRuleTemplatesOperations,
    AlertRulesOperations,
    AutomationRulesOperations,
    BookmarkOperations,
    BookmarkRelationsOperations,
    BookmarksOperations,
    DataConnectorsCheckRequirementsOperations,
    DataConnectorsOperations,
    DomainWhoisOperations,
    EntitiesGetTimelineOperations,
    EntitiesOperations,
    EntitiesRelationsOperations,
    EntityQueriesOperations,
    EntityQueryTemplatesOperations,
    EntityRelationsOperations,
    FileImportsOperations,
    GetOperations,
    GetRecommendationsOperations,
    IPGeodataOperations,
    IncidentCommentsOperations,
    IncidentRelationsOperations,
    IncidentTasksOperations,
    IncidentsOperations,
    MetadataOperations,
    OfficeConsentsOperations,
    Operations,
    ProductSettingsOperations,
    SecurityMLAnalyticsSettingsOperations,
    SentinelOnboardingStatesOperations,
    SourceControlOperations,
    SourceControlsOperations,
    ThreatIntelligenceIndicatorMetricsOperations,
    ThreatIntelligenceIndicatorOperations,
    ThreatIntelligenceIndicatorsOperations,
    UpdateOperations,
    WatchlistItemsOperations,
    WatchlistsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class SecurityInsights:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """API spec for Microsoft.SecurityInsights (Azure Security Insights) resource provider.

    :ivar alert_rules: AlertRulesOperations operations
    :vartype alert_rules: azure.mgmt.securityinsight.aio.operations.AlertRulesOperations
    :ivar actions: ActionsOperations operations
    :vartype actions: azure.mgmt.securityinsight.aio.operations.ActionsOperations
    :ivar alert_rule_templates: AlertRuleTemplatesOperations operations
    :vartype alert_rule_templates:
     azure.mgmt.securityinsight.aio.operations.AlertRuleTemplatesOperations
    :ivar automation_rules: AutomationRulesOperations operations
    :vartype automation_rules: azure.mgmt.securityinsight.aio.operations.AutomationRulesOperations
    :ivar incidents: IncidentsOperations operations
    :vartype incidents: azure.mgmt.securityinsight.aio.operations.IncidentsOperations
    :ivar bookmarks: BookmarksOperations operations
    :vartype bookmarks: azure.mgmt.securityinsight.aio.operations.BookmarksOperations
    :ivar bookmark_relations: BookmarkRelationsOperations operations
    :vartype bookmark_relations:
     azure.mgmt.securityinsight.aio.operations.BookmarkRelationsOperations
    :ivar bookmark: BookmarkOperations operations
    :vartype bookmark: azure.mgmt.securityinsight.aio.operations.BookmarkOperations
    :ivar ip_geodata: IPGeodataOperations operations
    :vartype ip_geodata: azure.mgmt.securityinsight.aio.operations.IPGeodataOperations
    :ivar domain_whois: DomainWhoisOperations operations
    :vartype domain_whois: azure.mgmt.securityinsight.aio.operations.DomainWhoisOperations
    :ivar entities: EntitiesOperations operations
    :vartype entities: azure.mgmt.securityinsight.aio.operations.EntitiesOperations
    :ivar entities_get_timeline: EntitiesGetTimelineOperations operations
    :vartype entities_get_timeline:
     azure.mgmt.securityinsight.aio.operations.EntitiesGetTimelineOperations
    :ivar entities_relations: EntitiesRelationsOperations operations
    :vartype entities_relations:
     azure.mgmt.securityinsight.aio.operations.EntitiesRelationsOperations
    :ivar entity_relations: EntityRelationsOperations operations
    :vartype entity_relations: azure.mgmt.securityinsight.aio.operations.EntityRelationsOperations
    :ivar entity_queries: EntityQueriesOperations operations
    :vartype entity_queries: azure.mgmt.securityinsight.aio.operations.EntityQueriesOperations
    :ivar entity_query_templates: EntityQueryTemplatesOperations operations
    :vartype entity_query_templates:
     azure.mgmt.securityinsight.aio.operations.EntityQueryTemplatesOperations
    :ivar file_imports: FileImportsOperations operations
    :vartype file_imports: azure.mgmt.securityinsight.aio.operations.FileImportsOperations
    :ivar incident_comments: IncidentCommentsOperations operations
    :vartype incident_comments:
     azure.mgmt.securityinsight.aio.operations.IncidentCommentsOperations
    :ivar incident_relations: IncidentRelationsOperations operations
    :vartype incident_relations:
     azure.mgmt.securityinsight.aio.operations.IncidentRelationsOperations
    :ivar incident_tasks: IncidentTasksOperations operations
    :vartype incident_tasks: azure.mgmt.securityinsight.aio.operations.IncidentTasksOperations
    :ivar metadata: MetadataOperations operations
    :vartype metadata: azure.mgmt.securityinsight.aio.operations.MetadataOperations
    :ivar office_consents: OfficeConsentsOperations operations
    :vartype office_consents: azure.mgmt.securityinsight.aio.operations.OfficeConsentsOperations
    :ivar sentinel_onboarding_states: SentinelOnboardingStatesOperations operations
    :vartype sentinel_onboarding_states:
     azure.mgmt.securityinsight.aio.operations.SentinelOnboardingStatesOperations
    :ivar get_recommendations: GetRecommendationsOperations operations
    :vartype get_recommendations:
     azure.mgmt.securityinsight.aio.operations.GetRecommendationsOperations
    :ivar get: GetOperations operations
    :vartype get: azure.mgmt.securityinsight.aio.operations.GetOperations
    :ivar update: UpdateOperations operations
    :vartype update: azure.mgmt.securityinsight.aio.operations.UpdateOperations
    :ivar security_ml_analytics_settings: SecurityMLAnalyticsSettingsOperations operations
    :vartype security_ml_analytics_settings:
     azure.mgmt.securityinsight.aio.operations.SecurityMLAnalyticsSettingsOperations
    :ivar product_settings: ProductSettingsOperations operations
    :vartype product_settings: azure.mgmt.securityinsight.aio.operations.ProductSettingsOperations
    :ivar source_control: SourceControlOperations operations
    :vartype source_control: azure.mgmt.securityinsight.aio.operations.SourceControlOperations
    :ivar source_controls: SourceControlsOperations operations
    :vartype source_controls: azure.mgmt.securityinsight.aio.operations.SourceControlsOperations
    :ivar threat_intelligence_indicator: ThreatIntelligenceIndicatorOperations operations
    :vartype threat_intelligence_indicator:
     azure.mgmt.securityinsight.aio.operations.ThreatIntelligenceIndicatorOperations
    :ivar threat_intelligence_indicators: ThreatIntelligenceIndicatorsOperations operations
    :vartype threat_intelligence_indicators:
     azure.mgmt.securityinsight.aio.operations.ThreatIntelligenceIndicatorsOperations
    :ivar threat_intelligence_indicator_metrics: ThreatIntelligenceIndicatorMetricsOperations
     operations
    :vartype threat_intelligence_indicator_metrics:
     azure.mgmt.securityinsight.aio.operations.ThreatIntelligenceIndicatorMetricsOperations
    :ivar watchlists: WatchlistsOperations operations
    :vartype watchlists: azure.mgmt.securityinsight.aio.operations.WatchlistsOperations
    :ivar watchlist_items: WatchlistItemsOperations operations
    :vartype watchlist_items: azure.mgmt.securityinsight.aio.operations.WatchlistItemsOperations
    :ivar data_connectors: DataConnectorsOperations operations
    :vartype data_connectors: azure.mgmt.securityinsight.aio.operations.DataConnectorsOperations
    :ivar data_connectors_check_requirements: DataConnectorsCheckRequirementsOperations operations
    :vartype data_connectors_check_requirements:
     azure.mgmt.securityinsight.aio.operations.DataConnectorsCheckRequirementsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.securityinsight.aio.operations.Operations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-12-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = SecurityInsightsConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.alert_rules = AlertRulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.actions = ActionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.alert_rule_templates = AlertRuleTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.automation_rules = AutomationRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.incidents = IncidentsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.bookmarks = BookmarksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.bookmark_relations = BookmarkRelationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.bookmark = BookmarkOperations(self._client, self._config, self._serialize, self._deserialize)
        self.ip_geodata = IPGeodataOperations(self._client, self._config, self._serialize, self._deserialize)
        self.domain_whois = DomainWhoisOperations(self._client, self._config, self._serialize, self._deserialize)
        self.entities = EntitiesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.entities_get_timeline = EntitiesGetTimelineOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.entities_relations = EntitiesRelationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.entity_relations = EntityRelationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.entity_queries = EntityQueriesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.entity_query_templates = EntityQueryTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.file_imports = FileImportsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.incident_comments = IncidentCommentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.incident_relations = IncidentRelationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.incident_tasks = IncidentTasksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.metadata = MetadataOperations(self._client, self._config, self._serialize, self._deserialize)
        self.office_consents = OfficeConsentsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.sentinel_onboarding_states = SentinelOnboardingStatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.get_recommendations = GetRecommendationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.get = GetOperations(self._client, self._config, self._serialize, self._deserialize)
        self.update = UpdateOperations(self._client, self._config, self._serialize, self._deserialize)
        self.security_ml_analytics_settings = SecurityMLAnalyticsSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.product_settings = ProductSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.source_control = SourceControlOperations(self._client, self._config, self._serialize, self._deserialize)
        self.source_controls = SourceControlsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.threat_intelligence_indicator = ThreatIntelligenceIndicatorOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.threat_intelligence_indicators = ThreatIntelligenceIndicatorsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.threat_intelligence_indicator_metrics = ThreatIntelligenceIndicatorMetricsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.watchlists = WatchlistsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.watchlist_items = WatchlistItemsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.data_connectors = DataConnectorsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.data_connectors_check_requirements = DataConnectorsCheckRequirementsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "SecurityInsights":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
