
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Bnd_Box.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TopoDS_Edge.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TopoDS_Vertex.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <TopoDS_Vertex.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Shape.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <BRepExtrema_DistanceSS.hxx>
#include <BRepExtrema_DistShapeShape.hxx>
#include <BRepExtrema_ElementFilter.hxx>
#include <BRepExtrema_ExtCC.hxx>
#include <BRepExtrema_ExtCF.hxx>
#include <BRepExtrema_ExtFF.hxx>
#include <BRepExtrema_ExtPC.hxx>
#include <BRepExtrema_ExtPF.hxx>
#include <BRepExtrema_MapOfIntegerPackedMapOfInteger.hxx>
#include <BRepExtrema_OverlapTool.hxx>
#include <BRepExtrema_Poly.hxx>
#include <BRepExtrema_ProximityDistTool.hxx>
#include <BRepExtrema_ProximityValueTool.hxx>
#include <BRepExtrema_SelfIntersection.hxx>
#include <BRepExtrema_SeqOfSolution.hxx>
#include <BRepExtrema_ShapeProximity.hxx>
#include <BRepExtrema_SolutionElem.hxx>
#include <BRepExtrema_SupportType.hxx>
#include <BRepExtrema_TriangleSet.hxx>
#include <BRepExtrema_UnCompatibleShape.hxx>

// template related includes

#include "NCollection_tmpl.hxx"

#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_BRepExtrema_enums(py::module &main_module) {


py::module m = main_module.def_submodule("BRepExtrema", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums
    py::enum_<BRepExtrema_SupportType>(m, "BRepExtrema_SupportType",R"#()#")
        .value("BRepExtrema_IsVertex",BRepExtrema_SupportType::BRepExtrema_IsVertex)
        .value("BRepExtrema_IsOnEdge",BRepExtrema_SupportType::BRepExtrema_IsOnEdge)
        .value("BRepExtrema_IsInFace",BRepExtrema_SupportType::BRepExtrema_IsInFace).export_values();

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<BRepExtrema_DistShapeShape , shared_ptr<BRepExtrema_DistShapeShape>  >(m,"BRepExtrema_DistShapeShape",R"#(This class provides tools to compute minimum distance between two Shapes (Compound,CompSolid, Solid, Shell, Face, Wire, Edge, Vertex).)#");
    py::class_<BRepExtrema_DistanceSS , shared_ptr<BRepExtrema_DistanceSS>  >(m,"BRepExtrema_DistanceSS",R"#(This class allows to compute minimum distance between two brep shapes (face edge vertex) and is used in DistShapeShape class.)#");
    py::class_<BRepExtrema_ElementFilter , shared_ptr<BRepExtrema_ElementFilter>  >(m,"BRepExtrema_ElementFilter",R"#(Filtering tool used to detect if two given mesh elements should be tested for overlapping/intersection or not.)#");
    py::class_<BRepExtrema_ExtCC , shared_ptr<BRepExtrema_ExtCC>  >(m,"BRepExtrema_ExtCC",R"#()#");
    py::class_<BRepExtrema_ExtCF , shared_ptr<BRepExtrema_ExtCF>  >(m,"BRepExtrema_ExtCF",R"#()#");
    py::class_<BRepExtrema_ExtFF , shared_ptr<BRepExtrema_ExtFF>  >(m,"BRepExtrema_ExtFF",R"#()#");
    py::class_<BRepExtrema_ExtPC , shared_ptr<BRepExtrema_ExtPC>  >(m,"BRepExtrema_ExtPC",R"#()#");
    py::class_<BRepExtrema_ExtPF , shared_ptr<BRepExtrema_ExtPF>  >(m,"BRepExtrema_ExtPF",R"#()#");
    py::class_<BRepExtrema_Poly , shared_ptr<BRepExtrema_Poly>  >(m,"BRepExtrema_Poly",R"#()#");
    py::class_<BRepExtrema_ProximityValueTool , shared_ptr<BRepExtrema_ProximityValueTool>  >(m,"BRepExtrema_ProximityValueTool",R"#(Tool class for computation of the proximity value from one BVH primitive set to another, solving max(min) problem. Handles only edge/edge or face/face cases. This tool is not intended to be used independently, and is integrated in other classes, implementing algorithms based on shape tessellation (BRepExtrema_ShapeProximity and BRepExtrema_SelfIntersection).)#");
    py::class_<BRepExtrema_ShapeProximity , shared_ptr<BRepExtrema_ShapeProximity>  >(m,"BRepExtrema_ShapeProximity",R"#(Tool class for shape proximity detection.)#");
    py::class_<BRepExtrema_SolutionElem , shared_ptr<BRepExtrema_SolutionElem>  >(m,"BRepExtrema_SolutionElem",R"#(This class is used to store information relative to the minimum distance between two shapes.)#");
    py::class_<BRepExtrema_OverlapTool , shared_ptr<BRepExtrema_OverlapTool>  >(m,"BRepExtrema_OverlapTool",R"#(Tool class for for detection of overlapping of two BVH primitive sets. This tool is not intended to be used independently, and is integrated in other classes, implementing algorithms based on shape tessellation (BRepExtrema_ShapeProximity and BRepExtrema_SelfIntersection).)#");
    py::class_<BRepExtrema_ProximityDistTool , shared_ptr<BRepExtrema_ProximityDistTool>  >(m,"BRepExtrema_ProximityDistTool",R"#(Tool class for computation the proximity distance from first primitive set to second one that is the maximal from minimum perpendicular distances. If no perpendicular distance is found, the minimum distance will be returned. This tool is not intended to be used independently, and is integrated in other classes, implementing algorithms based on shape tessellation (BRepExtrema_ProximityValueTool).)#");
    py::class_<BRepExtrema_SelfIntersection , shared_ptr<BRepExtrema_SelfIntersection>  , BRepExtrema_ElementFilter >(m,"BRepExtrema_SelfIntersection",R"#(Tool class for detection of self-sections in the given shape. This class is based on BRepExtrema_OverlapTool and thus uses shape tessellation to detect incorrect mesh fragments (pairs of overlapped triangles belonging to different faces). Thus, a result depends critically on the quality of mesh generator (e.g., BREP mesh is not always a good choice, because it can contain gaps between adjacent face triangulations, which may not share vertices on common edge; thus false overlap can be detected). As a result, this tool can be used for relatively fast approximated test which provides sub-set of potentially overlapped faces.)#");
    preregister_template_NCollection_Sequence<BRepExtrema_SolutionElem>(m,"BRepExtrema_SeqOfSolution");
    preregister_template_NCollection_Vector<TopoDS_Shape>(m,"BRepExtrema_ShapeList");
    py::class_<BRepExtrema_TriangleSet , shared_ptr<BRepExtrema_TriangleSet>  >(m,"BRepExtrema_TriangleSet",R"#(Triangle set corresponding to specific face.Triangle set corresponding to specific face.)#");
    py::class_<BRepExtrema_VertexInspector , shared_ptr<BRepExtrema_VertexInspector>  , NCollection_CellFilter_InspectorXYZ >(m,"BRepExtrema_VertexInspector",R"#(Class BRepExtrema_VertexInspector derived from NCollection_CellFilter_InspectorXYZ This class define the Inspector interface for CellFilter algorithm, working with gp_XYZ points in 3d space. Used in search of coincidence points with a certain tolerance.)#");

};

// user-defined post-inclusion per module

// user-defined post
