# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class NetworkAccessProfileTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.supersim.v1.network_access_profiles.create()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://supersim.twilio.com/v1/NetworkAccessProfiles',
        ))

    def test_create_minimal_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "unique_name": null,
                "sid": "HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2020-05-01T20:00:00Z",
                "date_updated": "2020-05-01T20:00:00Z",
                "url": "https://supersim.twilio.com/v1/NetworkAccessProfiles/HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "links": {
                    "networks": "https://supersim.twilio.com/v1/NetworkAccessProfiles/HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Networks"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.network_access_profiles.create()

        self.assertIsNotNone(actual)

    def test_create_with_name_and_networks_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "unique_name": "My Network Access Profile",
                "sid": "HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2020-05-01T20:00:00Z",
                "date_updated": "2020-05-01T20:00:00Z",
                "url": "https://supersim.twilio.com/v1/NetworkAccessProfiles/HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "links": {
                    "networks": "https://supersim.twilio.com/v1/NetworkAccessProfiles/HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Networks"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.network_access_profiles.create()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.supersim.v1.network_access_profiles("HAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://supersim.twilio.com/v1/NetworkAccessProfiles/HAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "unique_name": "My Network Access Profile",
                "sid": "HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2020-05-01T20:00:00Z",
                "date_updated": "2020-05-01T20:00:00Z",
                "url": "https://supersim.twilio.com/v1/NetworkAccessProfiles/HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "links": {
                    "networks": "https://supersim.twilio.com/v1/NetworkAccessProfiles/HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Networks"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.network_access_profiles("HAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.supersim.v1.network_access_profiles("HAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://supersim.twilio.com/v1/NetworkAccessProfiles/HAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_update_unique_name_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "unique_name": "My Network Access Profile",
                "sid": "HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2020-05-01T20:00:00Z",
                "date_updated": "2020-05-01T20:00:00Z",
                "url": "https://supersim.twilio.com/v1/NetworkAccessProfiles/HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "links": {
                    "networks": "https://supersim.twilio.com/v1/NetworkAccessProfiles/HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Networks"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.network_access_profiles("HAXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.supersim.v1.network_access_profiles.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://supersim.twilio.com/v1/NetworkAccessProfiles',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "network_access_profiles": [],
                "meta": {
                    "first_page_url": "https://supersim.twilio.com/v1/NetworkAccessProfiles?PageSize=50&Page=0",
                    "key": "network_access_profiles",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/NetworkAccessProfiles?PageSize=50&Page=0"
                }
            }
            '''
        ))

        actual = self.client.supersim.v1.network_access_profiles.list()

        self.assertIsNotNone(actual)

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "first_page_url": "https://supersim.twilio.com/v1/NetworkAccessProfiles?PageSize=50&Page=0",
                    "key": "network_access_profiles",
                    "next_page_url": null,
                    "page": 0,
                    "page_size": 50,
                    "previous_page_url": null,
                    "url": "https://supersim.twilio.com/v1/NetworkAccessProfiles?PageSize=50&Page=0"
                },
                "network_access_profiles": [
                    {
                        "unique_name": "My Network Access Profile",
                        "sid": "HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "date_created": "2020-05-01T20:00:00Z",
                        "date_updated": "2020-05-01T20:00:00Z",
                        "url": "https://supersim.twilio.com/v1/NetworkAccessProfiles/HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "links": {
                            "networks": "https://supersim.twilio.com/v1/NetworkAccessProfiles/HAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Networks"
                        }
                    }
                ]
            }
            '''
        ))

        actual = self.client.supersim.v1.network_access_profiles.list()

        self.assertIsNotNone(actual)
