% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential.R
\name{cred_user_pass}
\alias{cred_user_pass}
\title{Create a new plain-text username and password credential object}
\usage{
cred_user_pass(username = NULL, password = NULL)
}
\arguments{
\item{username}{The username of the credential}

\item{password}{The password of the credential. If getPass is installed
and the only input is username, \code{getPass::getPass()} will be
called to allow for interactive and obfuscated interactive
input of the password.}
}
\value{
A list of class \code{cred_user_pass} with entries:
\describe{
  \item{username}{
    The username of the credential
  }
  \item{password}{
    The password of the credential
  }
}
}
\description{
Create a new plain-text username and password credential object
}
\examples{
\dontrun{
## Create a plain-text username and password credential object
cred_user_pass("Random Developer", "SecretPassword")
}
}
\seealso{
Other git credential functions: 
\code{\link{cred_env}()},
\code{\link{cred_ssh_key}()},
\code{\link{cred_token}()}
}
\concept{git credential functions}
