### WARNING: This file is auto-generated by our OpenAPI spec. Do not
### edit it manually.

require_relative '../../resource_includes/response_helper'

module Asana
  module Resources
    class TypeaheadBase < Resource

      def self.inherited(base)
        Registry.register(base)
      end

      class << self
        # Get objects via typeahead
        #
        # workspace_gid - [str]  (required) Globally unique identifier for the workspace or organization.
        # resource_type - [str]  (required) The type of values the typeahead should return. You can choose from one of the following: `custom_field`, `project`, `project_template`, `portfolio`, `tag`, `task`, and `user`. Note that unlike in the names of endpoints, the types listed here are in singular form (e.g. `task`). Using multiple types is not yet supported.
        # type - [str]  *Deprecated: new integrations should prefer the resource_type field.*
        # query - [str]  The string that will be used to search for relevant objects. If an empty string is passed in, the API will return results.
        # count - [int]  The number of results to return. The default is 20 if this parameter is omitted, with a minimum of 1 and a maximum of 100. If there are fewer results found than requested, all will be returned.
        # options - [Hash] the request I/O options
        # > opt_fields - [list[str]]  Defines fields to return. Some requests return *compact* representations of objects in order to conserve resources and complete the request more efficiently. Other times requests return more information than you may need. This option allows you to list the exact set of fields that the API should be sure to return for the objects. The field names should be provided as paths, described below. The id of included objects will always be returned, regardless of the field options.
        # > opt_pretty - [bool]  Provides “pretty” output. Provides the response in a “pretty” format. In the case of JSON this means doing proper line breaking and indentation to make it readable. This will take extra time and increase the response size so it is advisable only to use this during debugging.
        def typeahead_for_workspace(client, workspace_gid: required("workspace_gid"), resource_type: nil, type: nil, query: nil, count: nil, options: {})
          path = "/workspaces/{workspace_gid}/typeahead"
          path["{workspace_gid}"] = workspace_gid
          params = { resource_type: resource_type, type: type, query: query, count: count }.reject { |_,v| v.nil? || Array(v).empty? }
          Collection.new(parse(client.get(path, params: params, options: options)), type: Resource, client: client)
        end

      end
    end
  end
end
