/*
    The WebDruid - a web server log analysis program

    Copyright (C) 2003-2004  Fabien Chevalier (fabien@juliana-multimedia.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/

#ifndef _LOGS_MGMT_H
#define _LOGS_MGMT_H

//TODO : these variables delaration is duplicated : fix this!!
extern unsigned long total_rec    ;                /* Total Records Processed     */
extern unsigned long total_ignore ;                /* Total Records Ignored       */
extern unsigned long total_bad    ;                /* Total Bad Records           */

/*
  This module is here to manage a pool of log files (either flat or gzip'ed),
  and give their records, starting with the oldest first, and then giving
  them in order until the youngest is given.
  The pool is stored internally as a linked list, with the file containing the
  oldest record on to of the list.
*/

/*******************************************/
/* LOGS_ADD_FILE - add file to the pool    */
/*******************************************/

extern int logs_add_file(const char * filename);

/*******************************************/
/* LOGS_ADD_STDIN - adds STDIN to the pool */
/*******************************************/

extern int logs_add_stdin();

/*******************************************/
/* LOGS_NR_FILES - # of files in the pool  */
/*******************************************/

extern int logs_nr_files();

/*******************************************/
/* LOGS_REWIND                             */
/*******************************************/

/*
 * Once all files in the pool have been read,
 * rewind them all, so that a call to
 * logs_next_record gives us the first record
 * again.
 */

extern void logs_rewind();


/*******************************************/
/* LOGS_NEXT_RECORD                        */
/*******************************************/

/*
 * Fills log_struct with the oldest record in
 * the pool.
 * This function moves the file from the main pool
 * to the read files pool when there is no more
 * records to read.
 */

extern int logs_next_record(struct log_struct *precord);

/*******************************************/
/* LOGS_NEXT_RECORD                        */
/*******************************************/

/*
 * Close log files, free internal data structs
 */

extern void logs_close();

#endif /* _LOGS_MGMT_H */
