/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : NFILE1
    Description : Native File. Inherints from STREAM1
                  We'll use this class for testing dynamic
		  inheritance new features in GNU EDMA
    Author      : David Martnez Oliveira
    Date        : December, 6th, 2001
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class NFILE1
***************************************************
*/
 
typedef struct
{
  FILE                *handler;
  EDMAT_BUFFER	buffer;
}DtNFILE1;
/*
***************************************************
  Method Declaration for class buffer
***************************************************
*/
 
ESint32 EDMAPROC 
NFILEopenZZrS32 (OBJID IdObj, EPChar name, EPChar mode)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  if ((m->handler = fopen (name, mode)) == NULL) 
    {
      edma_printf_obj (IdObj, "Can't open file %s:", name);
      return -1;
    }
  
  return 0;
}


ESint32 EDMAPROC 
NFILEcloserS32 (OBJID IdObj)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  
  return fclose (m->handler);
}


ESint32 EDMAPROC 
NFILEreadsAsS32rS32 (OBJID IdObj, EDMAT_BUFFER *buf, EPSint32 len)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  if (buf)
    if (buf->Size < *len) 
      {
	edma_printf_obj (IdObj, "%s", "Not enough allocated space to read data.");
	edma_printf_obj (IdObj, "Using Buffer size: %ld", buf->Size);
	*len = buf->Size;
      }
  *len = (size_t) fread (buf->dat, 1, *len, m->handler);

  return *len;
}


ESint32 EDMAPROC 
NFILEwriteAsS32rS32 (OBJID IdObj, EDMAT_BUFFER buf, EPSint32 len)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  *len = fwrite (buf.dat, 1, *len, m->handler);

  return *len;
}


ESint32 EDMAPROC 
NFILEputsZS32rS32 (OBJID IdObj, EPChar s,ESint32 len)
{
  DtNFILE1	*m;
  EPChar        s1;
  ESint32       l;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  s1 = strdup(s);

  l = len;
  if (l > strlen (s1))
    l = strlen(s1);
  else
    s1[l] = 0;

  fputs (s1, m->handler);
  free (s1);

  return l;
}


ESint32 EDMAPROC 
NFILEputcCS32rS32 (OBJID IdObj, EChar c)
{
  DtNFILE1	*m;

  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  return putc (c, m->handler);
}


EPChar EDMAPROC 
NFILEgetssZsS32rS32 (OBJID IdObj, EPChar s, EPSint32 len)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  return fgets (s, *len, m->handler);

}


ESint32 EDMAPROC 
NFILEgetcsCrS32 (OBJID IdObj, EPChar c)
{
  DtNFILE1	*m;
  int           r;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  r = fgetc (m->handler);
  *c = (char)r;

  return r;
}


ESint32 EDMAPROC 
NFILEflushrS32 (OBJID IdObj)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  return fflush (m->handler);

}


ESint32 EDMAPROC 
NFILEseekS32ZrS32 (OBJID IdObj, ESint32 off, EPChar where)
{
  DtNFILE1	*m;
  int           w;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);

  if (strncmp (where, "SEEK_SET", 8) == 0)
    w = SEEK_SET;
  else 
    { 
      if (strncmp (where, "SEEK_END", 8) == 0)
	w = SEEK_END;
      else
	w = SEEK_CUR;
    }
  return fseek (m->handler, off, w);
	
}


ESint32 EDMAPROC 
NFILEtellsS32rS32 (OBJID IdObj, EPSint32 off)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  *off = ftell (m->handler);
  return *off;
}


ESint32 EDMAPROC 
NFILErewindrS32 (OBJID IdObj)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  fseek (m->handler, 0, SEEK_SET);
  return 0;
}


ESint32 EDMAPROC 
NFILEeofrS32 (OBJID IdObj)
{
  DtNFILE1	*m;
 
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  return feof (m->handler);
}


ESint32 EDMAPROC 
NFILEerrorrS32 (OBJID IdObj)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "Method still not implemented");
  return 0;
}


ESint32 EDMAPROC 
NFILELoadZsArS32 (OBJID IdObj, EPChar Name, EDMAT_BUFFER *buf)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "Method still not implemented");

  return 0;
}


ESint32 EDMAPROC 
NFILESaveZArS32 (OBJID IdObj, EPChar Name, EDMAT_BUFFER buf)
{
  DtNFILE1	*m;
  
  m = (DtNFILE1*) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "Method still not implemented");
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
