/*
 * Electric(tm) VLSI Design Systems
 *
 * File: graphqtdlg.h
 * Dialogs header file
 * Written by: Dmitry Nadezhin, Instutute for Design Problems in Microelectronics, Russian Academy of Sciences
 *
 * Copyright (c) 2001 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#ifndef GRAPHQTDLG_H
#define GRAPHQTDLG_H

#include "global.h"
#include "edialogs.h"

#define QT_CLEAN_NAMESPACE
#include <qcheckbox.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlistbox.h>

#ifndef Q_ASSERT
#define Q_ASSERT(x) ASSERT(x)
#endif
#ifndef Q_CHECK_PTR
#define Q_CHECK_PTR(p) CHECK_PTR(p)
#endif

class QSignalMapper;

class EDialog: public QDialog
{
    Q_OBJECT
public:
    EDialog(QWidget *parent, DIALOG *dialog);
    ~EDialog();
    void showMe();
    static char *localize (QString qstr);

    /* API routines */
    INTBIG nextHit(void);
    INTSML getNextCharacter(INTBIG *itemHit);
    void setText(INTBIG item, char *msg);
    char *getText(INTBIG item);
    void setControl(INTBIG item, INTBIG value);
    INTBIG getControl(INTBIG item);
    BOOLEAN validEntry(INTBIG item);
    void dimItem(INTBIG item);
    void unDimItem(INTBIG item);
    void noEditControl(INTBIG item);
    void editControl(INTBIG item);
    void opaqueEdit(INTBIG item);
    void characterEdit(INTBIG item);
    void defaultButton(INTBIG item);
    void setPopup(INTBIG item, INTBIG count, char **names);
    void setPopupEntry(INTBIG item, INTBIG entry);
    INTBIG getPopupEntry(INTBIG item);
    void initTextDialog(INTBIG item, BOOLEAN (*toplist)(char **), char *(*nextinlist)(void),
			void (*donelist)(void), INTBIG sortpos, INTBIG flags);
    void loadTextDialog(INTBIG item, BOOLEAN (*toplist)(char **), char *(*nextinlist)(void),
			void (*donelist)(void), INTBIG sortpos);
    void stuffLine(INTBIG item, char *line);
    void selectLine(INTBIG item, INTBIG line);
    void selectLines(INTBIG item, INTBIG count, INTBIG *lines);
    INTBIG getCurLine(INTBIG item);
    INTBIG *getCurLines(INTBIG item);
    char *getScrollLine(INTBIG item, INTBIG line);
    void setScrollLine(INTBIG item, INTBIG line, char *msg);
    void itemRect(INTBIG item, RECTAREA *rect);
    void percent(INTBIG item, INTBIG percent);
    void redispRoutine(INTBIG item, void (*routine)(RECTAREA*)); 
    void invertRect(INTBIG item, RECTAREA *r);
    void frameRect(INTBIG item, RECTAREA *r);
    void drawLine(INTBIG item, INTBIG fx, INTBIG fy, INTBIG tx, INTBIG ty, INTBIG mode);
    void fillPoly(INTBIG item, INTBIG *xv, INTBIG *yv, INTBIG count, INTBIG r, INTBIG g, INTBIG b);
    void allowUserDoubleClick(void);
    void drawRect(INTBIG item, RECTAREA *rect, INTBIG r, INTBIG g, INTBIG b);
    void putText(INTBIG item, char *msg, INTBIG x, INTBIG y);
    void setTextSize(INTBIG size);
    void getTextInfo(char *msg, INTBIG *wid, INTBIG *hei);
    void trackCursor(void (*eachdown)(INTBIG x, INTBIG y));
    void getMouse(INTBIG *x, INTBIG *y);

private:
    DIALOG *itemdesc;
    QWidget *items[100];
    QSignalMapper *mapper;
    QPoint iniPos;
    int editline;
    QString lastedittext;
public slots:
    void action(int id);
protected:
    void closeEvent( QCloseEvent *e );
    void keyPressEvent( QKeyEvent *e );
private:
    static void getdialogcoordinates(RECTAREA *rect, INTBIG *x, INTBIG *y, INTBIG *wid, INTBIG *hei);
    static INTBIG scaledialogcoordinate(INTBIG x);
};

class ECheckField: public QCheckBox
{
    Q_OBJECT
public:
    ECheckField( QString &text, QWidget *parent );
    ~ECheckField();
    bool isChecked();
public slots:
    void setChecked( bool value );
private:
    bool checked;
};

class EScrollField: public QListBox
{
    Q_OBJECT
public:
    EScrollField( QWidget *parent );
protected:
    void keyPressEvent( QKeyEvent *e );
};

class EIconField: public QLabel
{
    Q_OBJECT
public:
    EIconField( QWidget *parent, DIALOGITEM *item );
signals:
    void clicked();
protected:
    void mousePressEvent( QMouseEvent *e );
};

class EUserDrawnField: public QWidget
{
    Q_OBJECT
public:
    EUserDrawnField( QWidget *parent, DIALOGITEM *item );
signals:
    void clicked();
protected:
    void mouseMoveEvent( QMouseEvent *e );
    void mousePressEvent( QMouseEvent *e );
    void mouseReleaseEvent( QMouseEvent *e );
    void paintEvent( QPaintEvent *e );
public:
    DIALOGITEM *it;
    void (*redispRoutine)(RECTAREA*);
    bool buttonPressed;
    void (*eachdown)(INTBIG x, INTBIG y);
};

#endif
