// 2004-12-09  Paolo Carlini  <pcarlini@suse.de>
//
// Copyright (C) 2004 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
// USA.

// 4.7.3 Array modifications

#include <tr1/type_traits>
#include <testsuite_hooks.h>
#include <testsuite_tr1.h>

void test01()
{
  bool test __attribute__((unused)) = true;
  using std::tr1::remove_all_extents;
  using std::tr1::is_same;
  using namespace __gnu_test;

  VERIFY( (is_same<remove_all_extents<int>::type, int>::value) );
  VERIFY( (is_same<remove_all_extents<int[2]>::type, int>::value) );
  VERIFY( (is_same<remove_all_extents<int[2][3]>::type, int>::value) );
  VERIFY( (is_same<remove_all_extents<int[][3]>::type, int>::value) );
  VERIFY( (is_same<remove_all_extents<const int[2][3]>::type,
	   const int>::value) );
  VERIFY( (is_same<remove_all_extents<ClassType>::type, ClassType>::value) );
  VERIFY( (is_same<remove_all_extents<ClassType[2]>::type, ClassType>::value) );
  VERIFY( (is_same<remove_all_extents<ClassType[2][3]>::type,
	   ClassType>::value) );
  VERIFY( (is_same<remove_all_extents<ClassType[][3]>::type,
	   ClassType>::value) );
  VERIFY( (is_same<remove_all_extents<const ClassType[2][3]>::type,
	   const ClassType>::value) );
}

int main()
{
  test01();
  return 0;
}
