/*
  File autogenerated by gengetopt version 2.3  
  generated with the following command:
  ../src/gengetopt --input=cmdline.ggo --no-handle-version --no-handle-help 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
"Purpose:\n"
"  This program generates a C function that uses getopt_long function\n"
"  to parse the command line options, validate them and fill a struct.\n"
"\n"
"Usage: %s [OPTIONS]...\n\
   -h         --help                Print help and exit\n\
   -V         --version             Print version and exit\n\
   -iSTRING   --input=STRING        input file (default std input)\n\
   -fSTRING   --func-name=STRING    name of generated function\n\
   -FSTRING   --file-name=STRING    name of generated file (default cmdline)\n\
   -l         --long-help           long usage line in help\n\
   -u         --unamed-opts         accept filenames\n\
              --no-handle-help      do not handle --help|-h automatically\n\
              --no-handle-version   do not handle --version|-V automatically\n\
", PACKAGE);
}


static char *
gengetopt_strdup (char * s)
{
  char * n, * pn, * ps = s;
  while (*ps) ps++;
  n = (char *) malloc (1 + ps - s);
  if (n != NULL)
    {
      for (ps=s,pn=n; *ps; ps++,pn++)
        *pn = *ps;
      *pn = 0;
    }
  return n;
}


int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;	

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->input_given = 0 ;
  args_info->func_name_given = 0 ;
  args_info->file_name_given = 0 ;
  args_info->long_help_given = 0 ;
  args_info->unamed_opts_given = 0 ;
  args_info->no_handle_help_given = 0 ;
  args_info->no_handle_version_given = 0 ;
#define clear_args() { \
  args_info->input_arg = NULL; \
  args_info->func_name_arg = NULL; \
  args_info->file_name_arg = NULL; \
}

  clear_args();

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "input",	1, NULL, 'i' },
        { "func-name",	1, NULL, 'f' },
        { "file-name",	1, NULL, 'F' },
        { "long-help",	0, NULL, 'l' },
        { "unamed-opts",	0, NULL, 'u' },
        { "no-handle-help",	0, NULL, 0 },
        { "no-handle-version",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVi:f:F:lu", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (args_info->help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once\n", PACKAGE);
              clear_args ();
              cmdline_parser_print_help ();
              exit (1);
            }
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          if (args_info->version_given)
            {
              fprintf (stderr, "%s: `--version' (`-V') option given more than once\n", PACKAGE);
              clear_args ();
              cmdline_parser_print_help ();
              exit (1);
            }
          args_info->version_given = 1;
          return 0;

        case 'i':	/* input file (default std input).  */
          if (args_info->input_given)
            {
              fprintf (stderr, "%s: `--input' (`-i') option given more than once\n", PACKAGE);
              clear_args ();
              cmdline_parser_print_help ();
              exit (1);
            }
          args_info->input_given = 1;
          args_info->input_arg = gengetopt_strdup (optarg);
          break;

        case 'f':	/* name of generated function.  */
          if (args_info->func_name_given)
            {
              fprintf (stderr, "%s: `--func-name' (`-f') option given more than once\n", PACKAGE);
              clear_args ();
              cmdline_parser_print_help ();
              exit (1);
            }
          args_info->func_name_given = 1;
          args_info->func_name_arg = gengetopt_strdup (optarg);
          break;

        case 'F':	/* name of generated file (default cmdline).  */
          if (args_info->file_name_given)
            {
              fprintf (stderr, "%s: `--file-name' (`-F') option given more than once\n", PACKAGE);
              clear_args ();
              cmdline_parser_print_help ();
              exit (1);
            }
          args_info->file_name_given = 1;
          args_info->file_name_arg = gengetopt_strdup (optarg);
          break;

        case 'l':	/* long usage line in help.  */
          if (args_info->long_help_given)
            {
              fprintf (stderr, "%s: `--long-help' (`-l') option given more than once\n", PACKAGE);
              clear_args ();
              cmdline_parser_print_help ();
              exit (1);
            }
          args_info->long_help_given = 1;
          break;

        case 'u':	/* accept filenames.  */
          if (args_info->unamed_opts_given)
            {
              fprintf (stderr, "%s: `--unamed-opts' (`-u') option given more than once\n", PACKAGE);
              clear_args ();
              cmdline_parser_print_help ();
              exit (1);
            }
          args_info->unamed_opts_given = 1;
          break;

        
        
        case 0:	/* Long option with no short option */
          /* do not handle --help|-h automatically.  */
          if (strcmp (long_options[option_index].name, "no-handle-help") == 0)
          {
            if (args_info->no_handle_help_given)
              {
                fprintf (stderr, "%s: `--no-handle-help' option given more than once\n", PACKAGE);
                clear_args ();
                cmdline_parser_print_help ();
                exit (1);
              }
            args_info->no_handle_help_given = 1;
            break;
          }
          /* do not handle --version|-V automatically.  */
          else if (strcmp (long_options[option_index].name, "no-handle-version") == 0)
          {
            if (args_info->no_handle_version_given)
              {
                fprintf (stderr, "%s: `--no-handle-version' option given more than once\n", PACKAGE);
                clear_args ();
                cmdline_parser_print_help ();
                exit (1);
              }
            args_info->no_handle_version_given = 1;
            break;
          }

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (1);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if ( missing_required_options )
    exit (1);


  return 0;
}
