/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gr_count_bits.h>

/*
 * these are slow and obvious.  If you need something faster, fix these
 */

// return number of set bits in the low  8 bits of x
int 
gr_count_bits8 (int x)
{
  int	count = 0;

  for (int i = 0; i < 8; i++)
    if (x & (1 << i))
      count++;

  return count;
}

// return number of set bits in the low 16 bits of x
int 
gr_count_bits16 (int x)
{
  int	count = 0;

  for (int i = 0; i < 16; i++)
    if (x & (1 << i))
      count++;

  return count;

}

// return number of set bits in the low 32 bits of x
int 
gr_count_bits32 (int x)
{
  int	count = 0;

  for (int i = 0; i < 32; i++)
    if (x & (1 << i))
      count++;

  return count;
}
