/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

const types = require("js_checker/constant_types");
const scriptsCached = require("script_entries/scripts_cache").scriptsCached;
const xhr = require('html_script_finder/dom_handler/dom_checker').xhr;
const timers = require("sdk/timers");

exports.addToCache = function (lic, delay, jsWebLabelsURL) {
  //console.log("jslicenseURL is", jsWebLabelsURL);
  if (delay == undefined) {
    delay = 0;
  }
  // get file hash and store as cached.
  //console.log('performing xhr for', lic.fileUrl);
  timers.setTimeout(function() {
    xhr({'url': lic.fileUrl}, 
        function (script, contents) { 
          // add a cache entry.
          //console.log('performed xhr for', lic.fileUrl, "with delay", delay);
          scriptsCached.addEntryIfNotCached(contents, 
                                            types.freeWithComment('This script is free according to a JS Web Labels page visited recently (at ' + jsWebLabelsURL.replace("librejs=true", "") + ' )'),
                                            {},
                                            true);
        });}, delay);
};