
;;; d-begin-end.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-begin-end.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: begin end code
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun d-beginning-of-defun ()
  (interactive)
  (push-mark (point) 'no-msg)
  (beginning-of-defun))

(defun d-end-of-defun ()
  (interactive)
  (push-mark (point) 'no-msg)
  (end-of-defun))

(if emacs-dialect--xemacs-p
    (progn
      (global-set-key [(control meta up)]
                      (function
                       (lambda () (interactive)
                         (d-scroll-up (- (window-height) 2)))))
      (global-set-key [(control meta down)]
                      (function
                       (lambda () (interactive)
                         (d-scroll-down (- (window-height) 2)))))
      )
  ;;(global-set-key [(control up)] 'd-beginning-of-defun)
  ;;(global-set-key [(control down)] 'd-end-of-defun)
  (global-set-key [(meta up)] 'd-beginning-of-defun)
  (global-set-key [(meta down)] 'd-end-of-defun)
  )

(provide 'd-begin-end)
;;; d-begin-end.el ends here
