/*  GNU Moe - My Own Editor
    Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010, 2011
    Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace ISO_8859 {

// `seq[i]' begins a escape sequence (the characters following a '\').
// Returns the corresponding code and, in *lenp, the characters read.
// Returns -1 if error.
//
int escape( const std::string & seq, const unsigned int i, int *lenp = 0 ) throw();


// Replace special characters with escape sequences; '\n' --> "\n"
//
void escapize( std::string & s ) throw();


// Replace escape sequences with special characters; "\n" --> '\n'
//
void deescapize( std::string & s ) throw();


bool islower( const unsigned char ch ) throw();
bool isupper( const unsigned char ch ) throw();
bool isalpha_( const unsigned char ch ) throw();
bool isalnum_( const unsigned char ch ) throw();
inline bool isblank_( const unsigned char ch ) throw()
  { return ( ch == ' ' || ch == '\t' ); }

inline bool iscntrl( const unsigned char ch ) throw()
  { return ( ch < 32 || ( ch >= 0x7f && ch < 0xA0 ) ); }

bool isodigit( const unsigned char ch ) throw();  // is `ch' an octal digit?

inline bool isprint( const unsigned char ch ) throw()
  { return !iscntrl( ch ); }

const char * control_name( const unsigned char ch ) throw();  // '^A' --> "^A"
int controlize( int code ) throw();	// converts 'A' or 'a' into '^A'
int decontrolize( int code ) throw();	// converts '^A' or 'a' into 'A'
unsigned char tolower( const unsigned char ch ) throw();
unsigned char toupper( const unsigned char ch ) throw();
unsigned char xdigit( const int value ) throw();  // hex digit for `value'
int xtoi( const unsigned char ch ) throw();	// value of hex digit `ch'

} // end namespace ISO_8859
