## Copyright (C) 2007 Sylvain Pelissier <sylvain.pelissier@gmail.com>
##
## This program is free software; you can redistribute it and/or modify it under
## the terms of the GNU General Public License as published by the Free Software
## Foundation; either version 3 of the License, or (at your option) any later
## version.
##
## This program is distributed in the hope that it will be useful, but WITHOUT
## ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
## FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
## details.
##
## You should have received a copy of the GNU General Public License along with
## this program; if not, see <http://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @deftypefn {Function File} {@var{y} =} qfunc (@var{x})
## Compute the Q function.
## @seealso{erfc, erf}
## @end deftypefn

function y = qfunc (x)

  if (nargin != 1)
    print_usage ();
  endif

  y = erfc (x / sqrt(2)) / 2;

endfunction

%!assert (qfunc ([-Inf 0 Inf]), [1 0.5 0])

%% Test input validation
%!error qfunc ()
%!error qfunc (1, 2)
