# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000-2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk, gnome, gu
from htmlwidget import HtmlWidget
from i18n import _

class SelectLessonfileWidget(gtk.GtkFrame):
    """
    The class will parse call the teacher to parse the
    lessonfile because the widget need some data from the
    lessonfile header.
    """
    def __init__(self, teacher, win, change_cb):
        gtk.GtkFrame.__init__(self, _("Lesson file"))
        self.m_t = teacher
        self.change_cb = change_cb
        vbox = gtk.GtkVBox()
        vbox.set_border_width(gnome.uiconsts.PAD)
        vbox.set_spacing(gnome.uiconsts.PAD)
        self.add(vbox)
        # the box the combos go into
        hbox = gu.bHBox(vbox, gtk.FALSE)

        self.g_collection_combo = gtk.GtkCombo()
        self.g_collection_combo.entry.set_editable(gtk.FALSE)
        hbox.pack_start(self.g_collection_combo)

        self.g_file_combo = gtk.GtkCombo()
        self.g_file_combo.entry.set_editable(gtk.FALSE)
        hbox.pack_start(self.g_file_combo)

        # descriptions
        hbox = gu.bHBox(vbox, gtk.FALSE)
        gu.bLabel(hbox, _("Title")+": ", gtk.FALSE)
        self.g_title = gu.bLabel(hbox, "", gtk.FALSE)

        #details
        self.g_toggle_description = gtk.GtkToggleButton(_("Details"))
        self.g_toggle_description.connect('clicked', self.toggle_lessonfile_details)
        hbox.pack_end(self.g_toggle_description, gtk.FALSE, gtk.FALSE)
        self.g_description_frame = gtk.GtkFrame()
        self.g_lessonfile_details = HtmlWidget(self.m_t.m_app.handle_href, None)
        self.g_description_frame.add(self.g_lessonfile_details)
        vbox.pack_start(self.g_description_frame)
        self.m_lock = 0
        self.update()
        self.g_collection_combo.entry.connect('changed', self.change_collection)
        self.g_file_combo.entry.connect('changed', self.change_file)
        self._fw = self.m_t.add_watch('lessonfile', self._lessonfilewatch)
        self._cw = self.m_t.add_watch('lessoncollection', self._lessoncollectionwatch)
    def _lessonfilewatch(self, s):
        self.m_t.remove_watch('lessonfile', self._fw)
        self._fw = self.m_t.add_watch('lessonfile', self._lessonfilewatch)
    def _lessoncollectionwatch(self, s):
        self.m_t.remove_watch('lessoncollection', self._cw)
        self.m_lock = self.m_lock + 1
        self.g_collection_combo.entry.set_text(self.m_t.get_string(s))
        self.m_lock = self.m_lock - 1
        self._cw = self.m_t.add_watch('lessoncollection', self._lessoncollectionwatch)
    def change_collection(self, widget):
        self.m_t.set_lessoncollection(widget.get_text())
        self.update(1)
        self.change_cb()
    def change_file(self, widget):
        if self.m_lock > 0:
            return
        self.m_t.set_lessonfile(widget.get_text())
        self.update(2)
        self.change_cb()
    def update(self, level=0):
        """0: everything
           1: don't include collection combo
           2: only information label
        """
        if self.m_lock > 0:
            return
        self.m_lock = self.m_lock + 1
        if level == 0:
            self.g_collection_combo.set_popdown_strings(
                    self.m_t.m_app.lessonfile_manager.get_collections())
            self.g_collection_combo.entry.set_text(
                    self.m_t.get_string('lessoncollection'))
        if level <= 1:
            F = self.m_t.m_app.lessonfile_manager.get_filenames( \
                    self.m_t.get_string('lessoncollection'), self.m_t.m_content_type)
            if F:
                self.g_file_combo.set_popdown_strings(F)
                self.g_file_combo.entry.set_text(self.m_t.get_string('lessonfile'))
                self.g_file_combo.set_sensitive(gtk.TRUE)
            else:
                self.g_file_combo.entry.set_text('')
                self.g_file_combo.set_sensitive(gtk.FALSE)
                self.g_title.set_text('')
                self.g_description_frame.hide()
                #self.g_lessonfile_details.source("<html></html>")
                self.g_toggle_description.set_active(gtk.FALSE)
                self.g_toggle_description.set_sensitive(gtk.FALSE)
        if not self.m_t.m_P:
            self.m_lock = self.m_lock - 1
            return
        # the info labels
        if self.m_t.m_P:
            self.g_title.set_text(self.m_t.m_P.header.title)
        else:
            self.g_title.set_text('')
        s = self.m_t.m_P.header.description
        if s:
            self.g_lessonfile_details.source("<html><body bgcolor=white>%s</body></html>" % s)
            self.g_toggle_description.set_sensitive(gtk.TRUE)
        else:
           self.g_lessonfile_details.source("<html></html>")
           self.g_toggle_description.set_active(gtk.FALSE)
           self.g_toggle_description.set_sensitive(gtk.FALSE)
        self.m_lock = self.m_lock - 1
    def toggle_lessonfile_details(self, widget=None):
        if widget.active:
            self.g_description_frame.show()
        else:
            self.g_description_frame.hide()
    def show(self):
        self.show_all()
        self.g_description_frame.hide()
