# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import utils, gtk, gu, widgets
from i18n import _
import gnome
import os


class MatrixTable(gtk.GtkVBox):
    def __init__(self, label_style, heading, keys, key_to_pretty_name, dict):
        gtk.GtkVBox.__init__(self)
        label = gtk.GtkLabel(heading)
        label.set_name("Heading2")
        label.set_alignment(0.0, 0.0)
        self.pack_start(label, gtk.FALSE)
        hbox = gu.bHBox(self, gtk.FALSE)
        frame = gtk.GtkFrame()
        hbox.pack_start(frame, gtk.FALSE)
        t = gtk.GtkTable()
        frame.add(t)
        for x in range(len(keys)):
            t.attach(gtk.GtkVSeparator(), x*2+1, x*2+2, 0, len(keys)*2)
        for x in range(len(keys)-1):
            t.attach(gtk.GtkHSeparator(), 0, len(keys)*2+1, x*2+1, x*2+2)
        for y in range(len(keys)):
            if label_style == 'progression':
                l = widgets.HarmonicProgressionLabel(
                                     key_to_pretty_name(keys[y]), 'left')
            else:
                l = gtk.GtkLabel(_(key_to_pretty_name(keys[y])))
                l.set_alignment(0.0, 0.5)
            t.attach(l, 0, 1, y*2, y*2+1, xpadding=gnome.uiconsts.PAD)
            for x in range(len(keys)):
                if dict.has_key(keys[x]) and dict[keys[x]].has_key(keys[y]):
                    s = str(dict[keys[x]][keys[y]])
                else:
                    s = "0"
                l = gtk.GtkLabel(s)
                if x == y:
                    l.set_name('StatisticsViewerDiagonal')
                t.attach(l, x*2+2, x*2+3, y*2, y*2+1, xpadding=gnome.uiconsts.PAD)
        self.show_all()


class PercentagesTable(gtk.GtkFrame):
    def __init__(self):
        gtk.GtkFrame.__init__(self)
        table = gtk.GtkTable()
        self.add(table)

        self.boxdict = {}
        for k, l, x in (('session', _("Session"), 2), ('today', _("Today"), 5),
                     ('last7', _("Last 7 days"), 8), ('total', _("Total"), 11)):
            table.attach(gtk.GtkLabel(l), x, x+2, 0, 1)
            b = gtk.GtkVBox()
            table.attach(b, x, x+1, 4, 5)
            self.boxdict[k+'percent'] = b
            b = gtk.GtkVBox()
            table.attach(b, x+1, x+2, 4, 5)
            self.boxdict[k+'count'] = b
        for x in (2, 5, 8, 11):
            table.attach(gtk.GtkLabel(_("Percent")), x, x+1, 2, 3)
            table.attach(gtk.GtkLabel(_("Count")), x+1, x+2, 2, 3)
        table.attach(gtk.GtkHSeparator(), 0, 13, 1, 2)
        table.attach(gtk.GtkHSeparator(), 0, 13, 3, 4)
        table.attach(gtk.GtkVSeparator(), 1, 2, 0, 6)
        table.attach(gtk.GtkVSeparator(), 4, 5, 0, 6)
        table.attach(gtk.GtkVSeparator(), 7, 8, 0, 6)
        table.attach(gtk.GtkVSeparator(), 10, 11, 0, 6)
        self.boxdict['keys'] = key_box = gtk.GtkVBox()
        table.attach(key_box, 0, 1, 4, 5)
        for box in self.boxdict.values():
            box.set_border_width(gnome.uiconsts.PAD_SMALL)
        self.show_all()
    def clear(self):
        for box in self.boxdict.values():
            for o in box.children():
                o.destroy()
    def update(self, statistics):
        self.clear()
        for box in self.boxdict.values():
            for o in box.children():
                o.destroy()
        for k in statistics.get_keys():
            # FIXME  Has this bug been fixed? This should NEVER happen.
            if k == None:
                print "WARNING: statistics: key==None. Please, please report to"
                print "bug-solfege@gnu.org if you get this message. Preferably,"
                print "make a copy ~/.solfege and ~/.gnome/solfegeX.Y so I can"
                print "debug this."
            if statistics.get_label_style() == 'progression':
                l = widgets.HarmonicProgressionLabel(statistics.key_to_pretty_name(k), 'left')
            else:
                l = gtk.GtkLabel(_(statistics.key_to_pretty_name(k)))
                l.set_alignment(0.0, 0.5)
            self.boxdict['keys'].pack_start(l)
            for sk, st in (('session', statistics.m_session_stat),
                       ('today', statistics.m_today_stat),
                       ('last7', statistics.m_last7_stat),
                       ('total', statistics.m_total_stat)):

                self.boxdict[sk+'percent'].pack_start(
                    gtk.GtkLabel("%.0f" % statistics.get_percentage_correct(st, k)))
                self.boxdict[sk+'count'].pack_start(
                    gtk.GtkLabel(str(statistics.get_num_guess(st, k))))
        self.show_all()

class NewAbstractStatisticsViewer(gtk.GtkScrolledWindow):
    def __init__(self, statistics, heading):
        gtk.GtkScrolledWindow.__init__(self)
        self.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.vbox = gtk.GtkVBox()
        self.vbox.set_spacing(gnome.uiconsts.PAD)
        self.vbox.set_border_width(gnome.uiconsts.PAD)
        self.add_with_viewport(self.vbox)
        label = gtk.GtkLabel(heading)
        label.set_alignment(0.0, 0.5)
        label.set_name("Heading1")
        self.vbox.pack_start(label, gtk.FALSE)
        self.m_statistics = statistics
        self.g_p = PercentagesTable()
        self.g_p.show_all()
        hbox = gtk.GtkHBox()
        self.vbox.pack_start(hbox, gtk.FALSE)
        hbox.pack_start(self.g_p, gtk.FALSE)
        self.show_all()

class SingIntervallStatisticsViewer(NewAbstractStatisticsViewer):
    def __init__(self, statistics, heading):
        NewAbstractStatisticsViewer.__init__(self, statistics, heading)
        self.clear = self.g_p.clear
    def update(self):
        self.g_p.update(self.m_statistics)


class GtkStatisticsViewer(NewAbstractStatisticsViewer):
    def __init__(self, statistics, heading):
        NewAbstractStatisticsViewer.__init__(self, statistics, heading)
        self.matrix_dict = {}
    def clear(self):
        self.g_p.clear()
        for k in ('session', 'today', 'last7', 'total'):
            if self.matrix_dict.has_key(k):
                self.matrix_dict[k].destroy()
    def update(self):
        self.clear()
        self.g_p.update(self.m_statistics)
        self.matrix_dict['session'] = MatrixTable(
                                           self.m_statistics.get_label_style(), 
                                           _("Session"),
                                           self.m_statistics.get_keys(1),
                                           self.m_statistics.key_to_pretty_name,
                                           self.m_statistics.m_session_stat)
        self.matrix_dict['today'] = MatrixTable(
                                           self.m_statistics.get_label_style(),
                                           _("Today"),
                                           self.m_statistics.get_keys(1),
                                           self.m_statistics.key_to_pretty_name,
                                           self.m_statistics.m_today_stat)
        self.matrix_dict['last7'] = MatrixTable(
                                           self.m_statistics.get_label_style(),
                                           _("Last 7 days"),
                                           self.m_statistics.get_keys(1),
                                           self.m_statistics.key_to_pretty_name,
                                           self.m_statistics.m_last7_stat)
        self.matrix_dict['total'] = MatrixTable(
                                           self.m_statistics.get_label_style(),
                                           _("Total"),
                                           self.m_statistics.get_keys(1),
                                           self.m_statistics.key_to_pretty_name,
                                           self.m_statistics.m_total_stat)

        for k in ('session', 'today', 'last7', 'total'):
            self.vbox.pack_start(self.matrix_dict[k], gtk.FALSE)
    #def transform_key(self, k):
    #    return utils.int_to_intervallname(k, 0, 0)

StatisticsViewer = GtkStatisticsViewer
