/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _GENFUN_H
#define _GENFUN_H

#include <iostream>

using std::ostream;

extern char *inputFileName ; /* what we're reading  */
extern ostream* sout ;

void processFile( const char *source_language, const char *output_format,
                  const char *inputFileName, const char *outputFileName,
                  short entire_doc, bool gen_version) ;
char *getCodeLine( void ) ;
void generate( const char *s ) ;
void generate( const char *s, int start, int end ) ;
void generateln( const char *s ) ;
void generate_preproc(const char *s);
void generate_normal(const char *s);
void generateNewLine(const char *s = 0) ;
void generateTab() ;
void generateComment( const char *s ) ;
void generateString( const char *s ) ;
void generateKeyWord( const char *s ) ;
void generatePreProc( const char *s ) ;
void generateBaseType( const char *s ) ;
void generateNumber( const char *s ) ;
void generateSymbol( const char *s ) ;
void generateFunction( const char *s ) ;
void generateCBracket( const char *s ) ;

void startComment( const char *s ) ;
void endComment( const char *s = 0 ) ; // 0 for // comments
void startString( const char *s ) ;
void endString( const char *s ) ;

#endif // _GENFUN_H
