// VQF 902.12 Foundations (S) Template
// Pass JSON data as content dictionary

#let form(data) = {
  set page(
    paper: "a4",
    margin: (left: 2cm, right: 2cm, top: 2cm, bottom: 2.5cm),
    footer: context [
      #grid(
        columns: (1fr, 1fr),
        align: (left, right),
        text(size: 8pt)[
          VQF doc. Nr. 902.12#linebreak()
          Version of 1 December 2015
        ],
        text(size: 8pt)[
          Page #here().page() of #counter(page).final().first()
        ]
      )
    ]
  )

  set text(font: "Liberation Sans", size: 10pt)
  set par(justify: false, leading: 0.65em)

  let get(key, default: "") = {
    data.at(key, default: default)
  }

  let checkbox(checked) = {
    box(
      width: 3mm,
      height: 3mm,
      stroke: 0.5pt + black,
      inset: 0.3mm,
      if checked == true or checked == "true" {
        place(center + horizon, text(size: 8pt, sym.checkmark))
      }
    )
  }

  // Header
  align(center, text(size: 11pt, weight: "bold")[CONFIDENTIAL])

  v(0.5em)

  grid(
    columns: (50%, 50%),
    gutter: 1em,
    image("vss_vqf_verein.png", width: 80%),
    align(right)[
      #table(
        columns: (1fr, 1fr),
        stroke: 0.5pt + black,
        inset: 5pt,
        align: (left, left),
        [VQF member no.], [AMLA File No.],
        [#get("VQF_MEMBER_NUMBER")], [#get("FILE_NUMBER")]
      )
    ]
  )

  v(1em)

  align(left, text(size: 14pt, weight: "bold")[Foundations (as well as similar constructs) (S)])

  v(-1em)
  line(length:100%)

  v(1em)

  text(weight: "bold")[Contracting partner:]

  v(0.5em)

  table(
    columns: (1fr),
    stroke: 0.5pt + black,
    inset: 5pt,
    [#get("IDENTITY_CONTRACTING_PARTNER")]
  )

  v(1em)

  text()[The undersigned hereby declare(s) that as board member of the foundation, or of the highest supervisory body of an underlying company of a foundation, known as:]

  v(0.5em)

  table(
    columns: (1fr),
    stroke: 0.5pt + black,
    inset: 5pt,
    [#get("ENTITY_NAME")]
  )

  v(1em)

  text()[and, such capacity, provide(s) to the best of his/her/their knowledge the following:]

  v(1.5em)

  // Section 1: Foundation Information
[= 1. Name and information pertaining to the foundation (tick the two boxes applicable):]

  v(0.5em)

  let entity_type = get("ENTITY_TYPE")
  let entity_revoc = get("ENTITY_REVOCABILITY")

  block(breakable: false)[
    #grid(
      columns: (auto, 1fr, auto, 1fr),
      gutter: 1em,
      row-gutter: 0.8em,
      [Type of foundation:],
      [#checkbox(entity_type == "DISCRETIONARY") Discretionary foundation],
      [or],
      [#checkbox(entity_type == "NON_DISCRETIONARY") Non-discretionary foundation],
      [and], [], [], [],
      [Revocability:],
      [#checkbox(entity_revoc == "REVOCABLE") Revocable foundation],
      [or],
      [#checkbox(entity_revoc == "IRREVOCABLE") Irrevocable foundation],
    )
  ]

  v(1.5em)

  // Section 2: Founder Information
[= 2. Information pertaining to the (ultimate economic, not fiduciary) founder (individual(s) or entity/ies):]

  v(0.5em)

  let founders = get("FOUNDER_LIST", default: ())
  let has_founders = type(founders) == array and founders.len() > 0

  for founder in (if has_founders {founders} else {((:),)}) {
    let get_founder(key) = {
      if founder != (:) {
        founder.at(key, default: "")
      } else {
        ""
      }
    }

    block(breakable: false)[
      #table(
        columns: (35%, 65%),
        stroke: 0.5pt + black,
        inset: 5pt,
        [Last name(s), first name(s)/entity:], [#get_founder("PERSON_ENTITY_NAME")],
        [Actual address of domicile/registered office:], [#get_founder("PERSON_DOMICILE_REGISTERED_OFFICE")],
        [Country:], [#get_founder("PERSON_COUNTRY")],
        [Date(s) of birth:], [#get_founder("PERSON_DATE_OF_BIRTH")],
        [Nationality:], [#get_founder("PERSON_NATIONALITY")],
        [Date of death (if deceased):], [#get_founder("PERSON_DATE_OF_DEATH")]
      )
    ]
    v(0.5em)
  }

  let founder_revoc = get("FOUNDER_HAS_REVOCATION_RIGHT")
  if entity_revoc == "REVOCABLE" [
    #table(
      columns: (70%, 30%),
      stroke: 0.5pt + black,
      inset: 5pt,
      [In case of a revocable foundation: does the founder have the right to revoke the foundation?],
      [#grid(
        columns: (auto, 1fr),
        gutter: 0.5em,
        checkbox(founder_revoc), [Yes],
        checkbox(not founder_revoc), [No],
      )]
    )
  ]

  pagebreak()

  // Section 3: Pre-existing Foundation
[= 3. If the foundation results from the restructuring of pre-existing foundation (re-settlement) or the merger of pre-existing foundations, the following information pertaining to the (actual) founder(s) of the pre-existing foundation(s) has to be given:]

  v(0.5em)

  let has_pred = get("HAS_PREDECESSOR_ENTITY")
  let pred_founders = get("PREDECESSOR_FOUNDER_LIST", default: ())
  let has_pred_founders = has_pred and type(pred_founders) == array and pred_founders.len() > 0

  if has_pred_founders {
    for pred in pred_founders {
      let get_pred(key) = {
        pred.at(key, default: "")
      }

      block(breakable: false)[
        #table(
          columns: (35%, 65%),
          stroke: 0.5pt + black,
          inset: 5pt,
          [Last name(s), first name(s)/entity:], [#get_pred("PERSON_ENTITY_NAME")],
          [Actual address of domicile/registered office:], [#get_pred("PERSON_DOMICILE_REGISTERED_OFFICE")],
          [Country:], [#get_pred("PERSON_COUNTRY")],
          [Date(s) of birth:], [#get_pred("PERSON_DATE_OF_BIRTH")],
          [Nationality:], [#get_pred("PERSON_NATIONALITY")],
          [Date of death (if deceased):], [#get_pred("PERSON_DATE_OF_DEATH")]
        )
      ]
      v(0.5em)
    }
  } else {
    table(
      columns: (35%, 65%),
      stroke: 0.5pt + black,
      inset: 5pt,
      [Last name(s), first name(s)/entity:], [],
      [Actual address of domicile/registered office:], [],
      [Country:], [],
      [Date(s) of birth:], [],
      [Nationality:], [],
      [Date of death (if deceased):], []
    )
  }

  // Section 4: Beneficiary Information
[= 4. Information]

  v(0.5em)

[== a) pertaining to the beneficiary/ies at the time of the signing of this form:]

  v(0.5em)

  let beneficiaries = get("BENEFICIARY_LIST", default: ())
  let has_benef = type(beneficiaries) == array and beneficiaries.len() > 0

  if has_benef {
    for benef in beneficiaries {
      let get_benef(key) = {
        benef.at(key, default: "")
      }
      let has_claim = get_benef("BENEFICIARY_HAS_CLAIM_RIGHT")

      block(breakable: false)[
        #table(
          columns: (35%, 65%),
          stroke: 0.5pt + black,
          inset: 5pt,
          [Full name/entity:], [#get_benef("PERSON_ENTITY_NAME")],
          [Actual address of domicile/registered office:], [#get_benef("PERSON_DOMICILE_REGISTERED_OFFICE")],
          [Country:], [#get_benef("PERSON_COUNTRY")],
          [Date of birth:], [#get_benef("PERSON_DATE_OF_BIRTH")],
          [Nationality:], [#get_benef("PERSON_NATIONALITY")],
          [Has the beneficiary an actual right to claim distribution?],
          [#grid(
            columns: (auto, auto),
            stroke: 0.5pt + black,
            inset: 5pt,
            [#checkbox(has_claim) Yes],
            [#checkbox(not has_claim) No],
          )]
        )
      ]
      v(0.5em)
    }
  } else {
    table(
      columns: (35%, 65%),
      stroke: 0.5pt + black,
      inset: 5pt,
      [Full name/entity:], [],
      [Actual address of domicile/registered office:], [],
      [Country:], [],
      [Date of birth:], [],
      [Nationality:], [],
      [Has the beneficiary an actual right to claim distribution?],
      [#grid(
        columns: (auto, auto),
        stroke: 0.5pt + black,
        inset: 5pt,
        [#checkbox(false) Yes],
        [#checkbox(false) No],
      )]
    )
  }

  v(1em)

[== b) and in addition to certain beneficiaries or if there is/are no defined beneficiary/ies pertaining to (a) group(s) of beneficiaries (e.g. descendants of the founder) known at the time of the signing of this form:]

  v(0.5em)

  table(
    columns: (1fr),
    stroke: 0.5pt + black,
    inset: 5pt,
    [#get("BENEFICIARY_GROUP_DESCRIPTION")]
  )

  pagebreak()

  // Section 5: Nominating Persons
[= 5. Information pertaining to (a) further person(s) having the right to determine or nominate representatives (e.g. members of the foundation board), if these representatives may dispose over the assets or have the right to change the distribution of the assets or the nomination of beneficiaries:]

  v(0.5em)

  let nom_persons = get("NOMINATING_PERSON_LIST", default: ())
  let has_nom = type(nom_persons) == array and nom_persons.len() > 0

  if has_nom {
    for nom in nom_persons {
      let get_nom(key) = {
        nom.at(key, default: "")
      }

      block(breakable: false)[
        #table(
          columns: (35%, 65%),
          stroke: 0.5pt + black,
          inset: 5pt,
          [Full name/entity:], [#get_nom("PERSON_ENTITY_NAME")],
          [Actual address of domicile/registered office:], [#get_nom("PERSON_DOMICILE_REGISTERED_OFFICE")],
          [Country:], [#get_nom("PERSON_COUNTRY")],
          [Date of birth:], [#get_nom("PERSON_DATE_OF_BIRTH")],
          [Nationality:], [#get_nom("PERSON_NATIONALITY")]
        )
      ]
      v(0.5em)
    }
  } else {
    table(
      columns: (35%, 65%),
      stroke: 0.5pt + black,
      inset: 5pt,
      [Full name/entity:], [],
      [Actual address of domicile/registered office:], [],
      [Country:], [],
      [Date of birth:], [],
      [Nationality:], []
    )
  }

  v(0.5em)

  let nom_revoc = get("EXTRA_REVOCATION_RIGHTS")
  table(
      columns: (70%, 30%),
      stroke: 0.5pt + black,
      inset: 5pt,
      [In case of a revocable foundation: is/are there (a) further person(s) with the right to revoke the foundation?],
      [#grid(
        columns: (auto, auto),
        stroke: 0.5pt + black,
        inset: 5pt,
        [#checkbox(nom_revoc) Yes],
        [#checkbox(not nom_revoc) No],
      )]
  )

  v(1.5em)

  text()[The contracting partner(s) hereby undertake(s) to automatically inform of any changes to the information contained herein.]

  v(1.5em)

  // Signature
  table(
    columns: (1fr, 1fr),
    stroke: 0.5pt + black,
    inset: 5pt,
    [Date:], [Signature(s):],
    [#get("SIGN_DATE")], [#get("SIGNATURE")]
  )

  v(1em)

  text(size: 9pt, style: "italic")[
    It is a criminal offence to deliberately provide false information on this form (article 251 of the Swiss Criminal Code, document forgery).
  ]
}

// Example usage:
#form((
  "VQF_MEMBER_NUMBER": "12345",
  "FILE_NUMBER": "42",
  "IDENTITY_CONTRACTING_PARTNER": "Foundation Board AG\nExample Street 1\n8001 Zurich",
  "ENTITY_NAME": "Example Foundation",
  "ENTITY_TYPE": "DISCRETIONARY",
  "ENTITY_REVOCABILITY": "IRREVOCABLE",
  "EXTRA_REVOCATION_RIGHTS": false,
  "FOUNDER_LIST": (
    (
      "PERSON_ENTITY_NAME": "John Doe",
      "PERSON_DOMICILE_REGISTERED_OFFICE": "Main St 123\n8001 Zurich",
      "PERSON_COUNTRY": "CH",
      "PERSON_DATE_OF_BIRTH": "01.01.1950",
      "PERSON_NATIONALITY": "CH",
    ),
  ),
  "HAS_PREDECESSOR_ENTITY": false,
  "SIGNATURE": "Board Member",
  "SIGN_DATE": "10.11.2025",
))