#!/usr/bin/env bash
# This file is in the public domain.

set -eu

FF=${1:-"not"}

if [[ ! -e package.json ]]; then
  echo "Please run this from the root of the repo.">&2
  exit 1
fi

vers_manifest=$(jq -r '.version' manifest-common.json)

# Create version form Manifest v2
zipfile="taler-wallet-webextension-${vers_manifest}-v2.zip"

rm -rf extension-dev
mkdir -p extension-dev/{v2,v3}

TEMP_DIR=extension-dev/v2
jq -s 'add | .name = "GNU Taler Wallet" ' manifest-common.json manifest-v2.json > $TEMP_DIR/manifest.json
cp -r static $TEMP_DIR/static
cp -r static-dev $TEMP_DIR/static
mkdir $TEMP_DIR/dist

[ $FF == "firefox" ] && DEV=1 INSTALL_DIR=$TEMP_DIR/dist ./build.mjs

(cd $TEMP_DIR && zip -q -r "../$zipfile" dist static manifest.json)

# Create version form Manifest v3
zipfile="taler-wallet-webextension-${vers_manifest}-v3.zip"

TEMP_DIR=extension-dev/v3
jq -s 'add | .name = "GNU Taler Wallet" ' manifest-common.json manifest-v3.json > $TEMP_DIR/manifest.json
cp -r static $TEMP_DIR/static
cp -r static-dev $TEMP_DIR/static
mkdir $TEMP_DIR/dist
cp -r service_worker.js $TEMP_DIR

[ $FF == "firefox" ] && DEV=1 INSTALL_DIR=$TEMP_DIR/dist ./build.mjs

(cd $TEMP_DIR && zip -q -r "../$zipfile" dist static manifest.json service_worker.js)

echo wallet webextension can be installed from extension-dev/v3 and extension-dev/v2
echo now run the development server
echo 'INSTALL_DIR=$PWD/extension-dev/v3/dist ./dev.mjs #FOR v3 version'
echo 'INSTALL_DIR=$PWD/extension-dev/v2/dist ./dev.mjs #FOR v2 version'
