/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import type {
  DoubleColumnFormDesign,
  DoubleColumnFormSection,
  InternationalizationAPI,
  UIHandlerId,
} from "@gnu-taler/web-util/browser";

export const simplest = (
  i18n: InternationalizationAPI,
): DoubleColumnFormDesign => ({
  type: "double-column" as const,
  sections: [
    {
      title: i18n.str`Simple form`,
      fields: [
        {
          type: "textArea",
          id: "comment" as UIHandlerId,
          label: i18n.str`Comment`,
        },
      ],
    },
    resolutionSection(i18n),
  ],
});

export function resolutionSection(
  i18n: InternationalizationAPI,
): DoubleColumnFormSection {
  return {
    title: i18n.str`Resolution`,
    fields: [
      {
        type: "choiceHorizontal",
        id: "state" as UIHandlerId,
        label: i18n.str`New state`,
        converterId: "TalerExchangeApi.AmlState",
        choices: [
          {
            value: "frozen",
            label: i18n.str`Frozen`,
          },
          {
            value: "pending",
            label: i18n.str`Pending`,
          },
          {
            value: "normal",
            label: i18n.str`Normal`,
          },
        ],
      },
      {
        type: "amount",
        id: "threshold" as UIHandlerId,
        currency: "NETZBON",
        converterId: "Taler.Amount",
        label: i18n.str`New threshold`,
      },
    ],
  };
}
