/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import * as tests from "@gnu-taler/web-util/testing";
import { SettingsView as TestedComponent } from "./Settings.js";
import { WalletCoreVersion } from "@gnu-taler/taler-util";

export default {
  title: "settings",
  component: TestedComponent,
  argTypes: {
    setDeviceName: () => Promise.resolve(),
  },
};

const version = {
  coreVersion: {
    exchange: "12:0:0",
    merchant: "2:0:1",
    bank: "0:0:0",
    hash: "d439c3e1bc743f2aa47de4457953dba6ecb0e20f",
    version: "1:2:3",
    devMode: false,
    bankConversionApiRange: "0:0:0",
    bankIntegrationApiRange: "0:0:0",
    corebankApiRange: "0:0:0",
    implementationGitHash: "d439c3e1bc743f2aa47de4457953dba6ecb0e20f",
    implementationSemver: "0.9.0-dev.1",
  } satisfies WalletCoreVersion,
  webexVersion: {
    version: "0.9.0.13",
    hash: "d439c3e1bc743f2aa47de4457953dba6ecb0e20f",
  },
};

export const AllOff = tests.createExample(TestedComponent, {
  deviceName: "this-is-the-device-name",
  advanceToggle: { value: false, button: {} },
  autoOpenToggle: { value: false, button: {} },
  langToggle: { value: false, button: {} },
  setDeviceName: () => Promise.resolve(),
  ...version,
});

export const OneChecked = tests.createExample(TestedComponent, {
  deviceName: "this-is-the-device-name",
  advanceToggle: { value: false, button: {} },
  autoOpenToggle: { value: false, button: {} },
  langToggle: { value: false, button: {} },
  setDeviceName: () => Promise.resolve(),
  ...version,
});

export const WithOneExchange = tests.createExample(TestedComponent, {
  deviceName: "this-is-the-device-name",
  advanceToggle: { value: false, button: {} },
  autoOpenToggle: { value: false, button: {} },
  langToggle: { value: false, button: {} },
  setDeviceName: () => Promise.resolve(),
  ...version,
});

export const WithExchangeInDifferentState = tests.createExample(
  TestedComponent,
  {
    deviceName: "this-is-the-device-name",
    advanceToggle: { value: false, button: {} },
    autoOpenToggle: { value: false, button: {} },
    langToggle: { value: false, button: {} },
    setDeviceName: () => Promise.resolve(),
    ...version,
  },
);
