/*----------------------------------------------------------------------
 * Module name:  my_iconv
 * Author name:  Arkadiusz Firus
 * Create date:  07 Sep 08
 * Purpose:    iconv handles
 *--------------------------------------------------------------------*/

#include <stdio.h>

#include "malloc.h"
#include "my_iconv.h"
#include "util.h"

my_iconv_t
my_iconv_open(const char *tocode, const char *fromcode)
{
	char *path;
	FILE *f;
	my_iconv_t cd = MY_ICONV_T_CLEAR;
	int c, i;

	if ((cd.desc = iconv_open(tocode, fromcode)) == (iconv_t) -1)
	{
		path = concatenate(CHARMAP_DIR, fromcode);
		f = fopen(path, "r");

		if (f != NULL)
		{
			cd.char_table = (char **)my_malloc(char_table_size * sizeof(char *));
			c = fgetc(f);

			for (i = 0; i < char_table_size && c != EOF; i++)
			{
				if (c == '<')
					cd.char_table[i] = get_unicode_char(f);

				leave_line(f);
				c = fgetc(f);
			}

			fclose(f);
		}

		my_free(path);
	}

	return cd;
}

size_t
my_iconv(my_iconv_t cd, char **inbuf, size_t *inbytesleft, char **outbuf, size_t *outbytesleft)
{
	int c, i;
	size_t result = 0;

	if (cd.desc == (iconv_t) -1) {
		if (cd.char_table != NULL)
		{
			while (*inbytesleft > 0 && *outbytesleft > 0)
			{
				c = (int) **inbuf;
				if (c < 0)
					c = 256 + c;

				if (cd.char_table[c] != NULL)
				{
					for (i = 0; cd.char_table[c][i] != '\0' && *outbytesleft > 0; i++)
					{
						**outbuf = cd.char_table[c][i];
						(*outbytesleft)--;
						(*outbuf)++;
					}
				}

				(*inbuf)++;
				(*inbytesleft)--;
				result++;
			}
		}
	}
	else
		result = iconv(cd.desc, inbuf, inbytesleft, outbuf, outbytesleft);

	return result;
}

my_iconv_t
my_iconv_close(my_iconv_t cd)
{
	int i;

	if (cd.char_table != NULL)
	{
		for (i = 0; i < char_table_size; i++)
		{
			my_free(cd.char_table[i]);
		}

		my_free(cd.char_table);
		cd.char_table = NULL;
	}

	if (cd.desc != (iconv_t) -1)
	{
		iconv_close(cd.desc);
		cd.desc = (iconv_t) -1;
	}

	return cd;
}

int 
my_iconv_is_valid (my_iconv_t cd)
{
	if (cd.desc != (iconv_t) -1 || cd.char_table != NULL)
		return 1;

	return 0;
}

void
my_iconv_t_make_invalid(my_iconv_t *cd)
{
	cd->desc = (iconv_t) -1;
	cd->char_table = NULL;
}

