#ifndef XLOGMASTER_H
#define XLOGMASTER_H

/* 
   Include file for Xlogmaster 
*/

/*{{{  Variables  */
// This flag is used for enabling / disabling the logs...
int display_logs;                  // Display of logs file (ENABLED/DISABLED)

Log **entry;
int syslogs;                   // Amount of "Log" objects
int active;                     // currently active "Log" object
char* read_buffer;        // Pointer to I/O-buffer for file operations
long maxtext;               // Number of bytes to be cached
struct stat status;         // stat-buffer for files

// These are only used at startup & reconfiguration:
int *mode;                  // mode for opening the file / whatever it is
char **filename;          // where to find it
char **help;                 // helptext to display when holding mouse over button
char **buttontext;       // text of button itself
int *interval;              // interval to display things... only used for executing/catting stuff
char ***commandline;  // commandline parameters for executable
char ***filter;                // strings to filter for
char ***filter_exec;       // command to execute (if EXECUTE set, otherwise NULL)
int **filter_mode;          // and the mode to use
int fillups;                   // amount of logs to be created...

int request_active;      // which one should be activated...
int xpos,ypos;
int width, height;
int wordwrap;
int terse;                    // should there be a "are you sure" question for
// critical things ?
int lockmem;               // should I try to lock the Xlogmasters pages in memory ?
int small_icon;          // big or small icon to be displayed ?
int notice_follows_mouse; // should the notice window follow the mouse around ?
gint configuration_changed; // did the configuration change ?

/*}}}*/

/*{{{  GTK variables  */
/* GtkWidget is the storage type for widgets */
GtkWidget *window;            // Main window
static GtkWidget *box;                  // Main Box
static GtkWidget *buttonbox;       // Box for Buttons
GtkWidget *textwindow;    // Text window
GtkTooltips *tooltips;         // for the help messages
static GtkWidget *scrolled_window;
static GtkWidget *textscrollbar;

/* GTK-Widgets for dial boxes */
static GtkWidget *file_error_dialog; 
static GtkWidget *file_error_ok;
static GtkWidget *file_error_label;

/* GTK-Widgets for "really quit" dialog... */
static GtkWidget *really_quit_dialog; 
static GtkWidget *really_quit_ok;
static GtkWidget *really_quit_cancel;
static GtkWidget *really_quit_label;

/* GTK-Widgets for "about Xlogmaster" */
static GtkWidget *about_dialog;
GtkWidget *small_logo_xpm;

/* Standard style */
GtkStyle* stdstyle;

/* GDK variables: */
GdkColormap* cmap; // xlogmasters overall colormap
GdkColor alert;              // Alert color to start at
GdkColor base;              // Colors to fade to
GdkColor prelight;         // (prelight to fade to)
double c_alert[3] = {0,0,0};

/*}}}*/

/*{{{  commandline options  */
/*
  commandline options to be used by
  my_getopt_long (in xlogmaster.cc)
*/
static gchar* cmdline_options[] = 
{
  "activate",
  "alertcolor",
  "audio",
  "audio-alert",
  "audio-notice",
  "audio-uniconify",
  "buffer",
  "config",
  "fadeseconds",
  "fadesteps",
  "geometry",
  "gtkrc",
  "help",
#if HAVE_MLOCKALL
  "mlockall",
#endif /* HAVE_MLOCKALL */
  "notice-follows-mouse",
  "silent",
  "smallicon",
  "terse",
  "version",
  "wordwrap",
  NULL
};
/* return values for my_getopt_long 
   do not change outside that routine !!!! */
static gchar* cmdline_par;
static gchar* cmdline_val;
/*}}}*/

/*{{{  GTK subroutines  */
gint delete_event(GtkWidget *, GdkEvent *, gpointer);
void quit (GtkWidget*, gpointer*);
void really_quit_button_pressed();
void color_init();
void create_textwidget();
void destroy_textwidget();
void create_buttons();
void button_pressed (GtkWidget*, gpointer*);
void request_about();
void about_ready(GtkWidget *, gpointer *);
/*}}}*/

/*{{{  Data management  */
void setup_logs();
void unsetup_logs();
void free_memory();
void disable();
void enable();
gint determine_filter_class(gint);
void sort_filters(Filter**);
/*}}}*/

/*{{{  Initial preparations  */
void usage();
void help_message();
void version_message();
static void eval_colorstring(char*);
long get_value(char*, int*);
gint my_getopt_long(int, char**, int*);
gint getopt_sub(gchar*);
void init(int, char**);

/*}}}*/

/*{{{  Text output subroutines  */
void output_text (GtkWidget*, char*, long);
int does_match(char*, char*, long, long);




/*}}}*/

/*{{{  Error procedures  */
void file_error(gchar*);
void fork_error();


/*}}}*/

/*{{{  About Xlogmaster  */
void create_about();
/*}}}*/

#endif /* XLOGMASTER_H */
