/* ,file-id archive://[lord]/407/vu/./vu.h/1998-05-18
*/
#ifndef VUH
#define VUH

/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



#include <sys/stat.h>
#include <sys/types.h>
#include <sys/types.h>
#include <sys/time.h>
#include <dirent.h>
#include <unistd.h>
#include <utime.h> 


typedef int (*vu_access_fn) (int * errno, char * path, int mode);
typedef int (*vu_chdir_fn) (int * errno, char * path);
typedef int (*vu_chmode_fn) (int * errno, char * path, int mode);
typedef int (*vu_chown_fn) (int * errno, char * path, int owner, int group);
typedef int (*vu_chroot_fn) (int * errno, char * path);
typedef int (*vu_close_fn) (int * errno, int fd);
typedef int (*vu_closedir_fn) (int * errno, DIR * dir);
typedef int (*vu_fchdir_fn) (int * errno, int fd);
typedef int (*vu_fstat_fn) (int * errno, int fd, struct stat * buf);
typedef int (*vu_fsync_fn) (int * errno, int fd);
typedef int (*vu_ftruncate_fn) (int * errno, int fd, int where);
typedef int (*vu_link_fn) (int * errno, char * from, char * to);
typedef int (*vu_lseek_fn) (int * errno, int fd, int offset, int whence);
typedef int (*vu_lstat_fn) (int * errno, char * path, struct stat * buf);
typedef int (*vu_mkdir_fn) (int * errno, char * path, int mode);
typedef int (*vu_open_fn) (int * errno, char * path, int flags, int mode);
typedef int (*vu_opendir_fn) (int * errno, DIR ** retv,  char * path);
typedef int (*vu_read_fn) (int * errno, int fd, char * buf, int count);
typedef int (*vu_readdir_fn) (int * errno, struct dirent * retv, DIR * dir);
typedef int (*vu_readlink_fn) (int * errno, char * path, char * buf, int bufsize);
typedef int (*vu_rename_fn) (int * errno, char * from, char * to);
typedef int (*vu_rmdir_fn) (int * errno, char * path);
typedef int (*vu_seekdir_fn) (int * errno, DIR * dir, int offset);
typedef int (*vu_stat_fn) (int * errno, char * path, struct stat * buf);
typedef int (*vu_symlink_fn) (int * errno, char * from, char * to);
typedef int (*vu_telldir_fn) (int * errno, DIR *);
typedef int (*vu_truncate_fn) (int * errno, char * path, int where);
typedef int (*vu_unlink_fn) (int * errno, char * path);
typedef int (*vu_utimes_fn) (int * errno, char * path, struct timeval * tvp);
typedef int (*vu_write_fn) (int * errno, int fd, char * buf, int count);
typedef int (*vu_fcntl_fn) (int * errno, int fd, int cmd, long arg);
typedef int (*vu_ioctl_fn) (int * errno, int fd, int request, void * params);
typedef int (*vu_dup_fn) (int * errno, int oldfd);
typedef int (*vu_dup2_fn) (int * errno, int oldfd, int newfd);

#define VU_FS_INTERNAL_B(name, prefix, middle, suffix) prefix##name##middle name##suffix
#define VU_FS_INTERNAL_C(name, prefix, middle, suffix) prefix##name, 
#define VU_FS_INTERNAL_D(name, prefix, middle, suffix) (vu_##name##_fn)bad_arg_handler,

#define VU_MAP2_FS_NAMES(c ,prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (access, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (chdir, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (chmode, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (chown, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (chroot, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (close, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (closedir, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (fchdir, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (fstat, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (fsync, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (ftruncate, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (link, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (lseek, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (lstat, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (mkdir, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (open, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (opendir, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (read, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (readdir, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (readlink, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (rename, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (rmdir, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (seekdir, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (stat, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (symlink, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (telldir, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (truncate, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (unlink, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (utimes, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (write, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (fcntl, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (ioctl, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (dup, prefix, middle, suffix) \
		 VU_FS_INTERNAL##c (dup2, prefix, middle, suffix)


struct vu_fs_discipline
{
  /* This declares one field, a function pointer,
   * per fstem function. For example:
   *
   *	vu_dup2_fn dup2;
   */
  VU_MAP2_FS_NAMES (_B,  vu_,_fn ,;)
};



/* This generates initializers for a vu_fs_discipline
 * structure.  It presumes that you use a regular
 * naming convention for all functions and that all
 * functions are defined.  For example, if you specify
 * a prefix XYZZY_, this will expand to:
 *
 *	XYZZY_access
 *	XYZZY_chdir
 * 	XYZZY_chmode
 *
 * The key abstraction to the macro is that you can initialize
 * a vu_fs_discipline structure without knowing the order
 * of the fields. 
 */
#define VU_FS_DISCIPLINE_INITIALIZERS(PREFIX) \
  VU_MAP2_FS_NAMES (_C, PREFIX, , )

extern struct vu_fs_discipline vu_system_fs_vtable;


/* automatically generated __STDC__ prototypes */
extern int vu_push_name_handler (regex_t * preg,
				 int eflags,
				 struct vu_fs_discipline * vtable);
extern void vu_set_fd_handler (int fd, struct vu_fs_discipline * vtable);
extern struct vu_fs_discipline * vu_path_dispatch (char * path);
extern struct vu_fs_discipline * vu_fd_dispatch (int fd);
extern struct vu_fs_discipline * vu_dir_dispatch (DIR * dir);
extern int vu_access (int * errn, char * path, int mode);
extern int vu_chdir (int * errn, char * path);
extern int vu_chmode (int * errn, char * path, int mode);
extern int vu_chown (int * errn, char * path, int owner, int group);
extern int vu_chroot (int * errn, char * path);
extern int vu_close (int * errn, int fd);
extern int vu_closedir (int * errn, DIR * dir);
extern int vu_fchdir (int * errn, int fd);
extern int vu_fstat (int * errn, int fd, struct stat * buf);
extern int vu_fsync (int * errn, int fd);
extern int vu_ftruncate (int * errn, int fd, int where);
extern int vu_link (int * errn, char * from, char * to);
extern int vu_lseek (int * errn, int fd, int offset, int whence);
extern int vu_lstat (int * errn, char * path, struct stat * buf);
extern int vu_mkdir (int * errn, char * path, int mode);
extern int vu_open (int * errn, char * path, int flags, int mode);
extern int vu_opendir (int * errn, DIR ** retv,  char * path);
extern int vu_read (int * errn, int fd, char * buf, int count);
extern int vu_readdir (int * errn, struct dirent * retv, DIR * dir);
extern int vu_readlink (int * errn, char * path, char * buf, int bufsize);
extern int vu_rename (int * errn, char * from, char * to);
extern int vu_rmdir (int * errn, char * path);
extern int vu_seekdir (int * errn, DIR * dir, int offset);
extern int vu_stat (int * errn, char * path, struct stat * buf);
extern int vu_symlink (int * errn, char * from, char * to);
extern int vu_telldir (int * errn, DIR * dir);
extern int vu_truncate (int * errn, char * path, int where);
extern int vu_unlink (int * errn, char * path);
extern int vu_utimes (int * errn, char * path, struct timeval * tvp);
extern int vu_write (int * errn, int fd, char * buf, int count);
extern int vu_write_rtry (int * errn, int fd, char * buf, int count);
extern int vu_fcntl (int * errn, int fd, int cmd, long arg);
extern int vu_ioctl (int * errn, int fd, int request, void * params);
extern int vu_dup (int * errn, int fd);
extern int vu_dup2 (int * errn, int fd, int newfd);
extern int vu_sys_access (int * errn, char * path, int mode);
extern int vu_sys_chdir (int * errn, char * path);
extern int vu_sys_chmode (int * errn, char * path, int mode);
extern int vu_sys_chown (int * errn, char * path, int owner, int group);
extern int vu_sys_chroot (int * errn, char * path);
extern int vu_sys_closedir (int * errn, DIR * dir);
extern int vu_sys_close (int * errn, int fd);
extern int vu_sys_fchdir (int * errn, int fd);
extern int vu_sys_fstat (int * errn, int fd, struct stat * buf);
extern int vu_sys_fsync (int * errn, int fd);
extern int vu_sys_ftruncate (int * errn, int fd, int where);
extern int vu_sys_link (int * errn, char * from, char * to);
extern int vu_sys_lseek (int * errn, int fd, int offset, int whence);
extern int vu_sys_lstat (int * errn, char * path, struct stat * buf);
extern int vu_sys_mkdir (int * errn, char * path, int mode);
extern int vu_sys_open (int * errn, char * path, int flags, int mode);
extern int vu_sys_opendir (int * errn, DIR ** retv,  char * path);
extern int vu_sys_read (int * errn, int fd, char * buf, int count);
extern int vu_sys_readdir (int * errn, struct dirent * retv, DIR * dir);
extern int vu_sys_readlink (int * errn, char * path, char * buf, int bufsize);
extern int vu_sys_rename (int * errn, char * from, char * to);
extern int vu_sys_rmdir (int * errn, char * path);
extern int vu_sys_seekdir (int * errn, DIR * dir, int offset);
extern int vu_sys_stat (int * errn, char * path, struct stat * buf);
extern int vu_sys_symlink (int * errn, char * from, char * to);
extern int vu_sys_telldir (int * errn, DIR * dir);
extern int vu_sys_truncate (int * errn, char * path, int where);
extern int vu_sys_unlink (int * errn, char * path);
extern int vu_sys_utimes (int * errn, char * path, struct timeval * tvp);
extern int vu_sys_write (int * errn, int fd, char * buf, int count);
extern int vu_sys_fcntl (int * errn, int fd, int cmd, long arg);
extern int vu_sys_ioctl (int * errn, int fd, int request, void * params);
extern int vu_sys_dup (int * errn, int fd);
extern int vu_sys_dup2 (int * errn, int fd, int newfd);
#endif /* VUH */
