/* definitionoffunctions.h -- This file is part of Archimedes release 0.0.3.
   Archimedes is a simulator for Submicron 2D Silicon/GaAs
   Devices. It implements both the Monte Carlo method and MEP model
   for the simulation of the semiclassical Boltzmann equation for both
   electrons and holes. It also includes the quantum effects by means 
   of effective potential method.

   Copyright (C) 2004, 2005, 2006, 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */

// ######################################################
// Created on 21 Sep.2004, Siracusa, J.M.Sellier
// Last modif. : 04 Mar.2005, Siracusa, J.M.Sellier
// ######################################################

// Definition of all the functions used in Archimedes

void PoissonBCs(void);
void media(void);
void SaveOutput2D_MeshFormat(int);
void SaveOutput2DHole_MeshFormat(int);
void SaveOutput2DGNUPLOT(int);
void SaveOutput2DHoleGNUPLOT(int);
void SaveOutputFiles(int,int);
void Electric_Field(void);
void quantum_effective_potential(void);
void MCparameters(void);
void MCdevice_config(void);
void EMC(void);
void scat(void);
void drift(double);
void creation(int,real,int);
void Charge(void);
void updating(int);
void Read_Input_File(void);
void Compute_Currents(void);
void electron_relaxation_step(void);
void ParabMEP2D(int,int,real,real,real,real);
void HMEPBCs(void);
void MEP_coefficients(void);
void Hole_MEP2D(int,int,real,real,real,real);
void HoleHMEPBCs(void);
void Relaxation_Step_Hole(void);
real rnd(void);
real c11i(real);
real c12i(real);
real c21i(real);
real c22i(real);
real Ui(real);
real Fi(real);
real Gi(real);
real cwi(real);
real tauwi(real);

// =============================================
