// This file is part of The New Aspell
// Copyright (C) 2001 by Kevin Atkinson under the GNU LGPL license
// version 2.0 or 2.1.  You should have received a copy of the LGPL
// license along with this library if you did not you can find
// it at http://www.gnu.org/.

#include <string> //13-Sep-04 //std::string
//#include "settings.h"

//#include "iostream.hpp"

//#include "config.hpp"
//#include "fstream.hpp"
//#include "errors.hpp"
#include "string_list.hpp"

#ifdef USE_FILE_LOCKS
#  include <fcntl.h>
#endif
 
// This needs to be <stdio.h> and not <cstdio>
#include <stdio.h>
#include <sys/stat.h>

#ifdef WIN32

#  include <windows.h>
#  include <winbase.h>

#else

#  include <unistd.h>
#  include <dirent.h>

#endif

#include "pathbrowse.h"

namespace acommon {

#ifdef WIN32PORT
  //Windows version
  PathBrowser::PathBrowser(const StringList & sl, const char * suf) 
  {
    els = sl.elements();
    suffix = suf;
	 std::string filter = "*.*"; //need work here
	 dir_handle = ::FindFirstFile(filter.c_str(),&BrowseData);
  }

  PathBrowser::~PathBrowser() 
  {
    delete els;
    if (dir_handle) FindClose(dir_handle);
  }
/*
 This just gets the next file that matches the suffix.
 Since I can't check out what the Unix version does
 I expect to tune this function while debugging.
*/
  const char * PathBrowser::next()
  {
    if (dir_handle ==  INVALID_HANDLE_VALUE)
		 return ""; //failure
	 BOOL ok = true;
	 do {
      const char * name = BrowseData.cFileName;
      unsigned name_len = strlen(name);
      if (suffix.size() != 0 && 
          !(name_len > suffix.size() 
            && memcmp(name + name_len - suffix.size(), suffix.str(), suffix.size()) == 0))
				ok = FindNextFile(dir_handle,&BrowseData);
		else
			return BrowseData.cFileName;
	 } while (ok);
    return 0; //no more
  }
#else
//Unix version
  PathBrowser::PathBrowser(const StringList & sl, const char * suf)
    : dir_handle(0)
  {
    els = sl.elements();
    suffix = suf;
  }

  PathBrowser::~PathBrowser() 
  {
    delete els;
    if (dir_handle) closedir((DIR *)dir_handle);
  }

  const char * PathBrowser::next()
  {
    if (dir_handle == 0) goto get_next_dir;
  begin: {
      struct dirent * entry = readdir((DIR *)dir_handle);
      if (entry == 0) goto try_again;
      const char * name = entry->d_name;
      unsigned name_len = strlen(name);
      if (suffix.size() != 0 && 
          !(name_len > suffix.size() 
            && memcmp(name + name_len - suffix.size(), suffix.str(), suffix.size()) == 0))
        goto begin;
      path = dir;
      if (path.back() != '/') path += '/';
      path += name;
    }
    return path.str();
  try_again:
    closedir((DIR *)dir_handle);
    dir_handle = 0;
  get_next_dir:
    dir = els->next();
    if (!dir) return 0;
    dir_handle = opendir(dir);
    if (dir_handle == 0) goto try_again;
    goto begin;
  }
#endif
}