/*  -*- Mode: C -*-  */

/* filament-test.c ---  */

/* Author:	       Gary V. Vaughan <gvv@techie.com>
 * Maintainer:	       Gary V. Vaughan <gvv@techie.com>
 * Created:	       Thu Apr 29 15:46:01 1999
 * Last Modified:      Wed Jul 14 15:07:14 1999
 *            by:      Gary V. Vaughan <gvv@techie.com>
 * ---------------------------------------------------------------------
 * @(#) $Id$
 * ---------------------------------------------------------------------
 */

/* Copyright (C) 1999 Gary V. Vaughan */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * As a special exception to the GNU General Public License, if you
 * distribute this file as part of a program that also links with and
 * uses the libopts library from AutoGen, you may include it under
 * the same distribution terms used by the libopts library.
 */

/* Code: */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "snprintfv/filament.h"

#ifndef DIR_SEPARATOR
#define DIR_SEPARATOR '/'
#endif

static const char *progname;

static inline void
fildump (stream, pfil)
    FILE *stream;
    filament *pfil;
{
    fprintf(stream, "%p (%u): \"%s\"\n",
	    filval(pfil), fillen(pfil), filval(pfil));
}

int
main (argc, argv)
    int   argc;
    char *argv[];
{
    static char string[] = "0123456789XX";
    FILE *stream = NULL;
    filament *pfil;
    int i;
    char *pval;
    
    progname = argv[0] + strlen(argv[0]);
    while (progname > argv[0] && *(progname -1) != DIR_SEPARATOR)
    {
	progname--;
    }

    if (getenv("VERBOSE"))
    {
	stream = stdout;
    }
    else
    {
	stream = fopen("/dev/null", "w");
    }
  
    fprintf(stream, "=== running test %s\n", progname);

    pfil = filnew("Hello, World!", 13);
    fildump(stream, pfil);
    fildelete(pfil);

    /* 51 lots of string is 510 chars, 2 less than FILAMENT_BUFSIZ. */
    pfil = filnew(string, 10);
    pval = filval(pfil);
    for (i = 0; i < 50; i++)
    {
	if (filncat(pfil, string, 10) == NULL)
	{
	    fildump(stream, pfil);
	    return EXIT_FAILURE;
	}
	snv_fassert(stream, filval(pfil) == pval);
	snv_fassert(stream, strlen(filval(pfil)) == fillen(pfil));
	snv_fassert(stream, fillen(pfil) == 10+ (1+ i) * 10);
    }
    fildump(stream, pfil);

    /* overflow the internal buffer to force a reallocation */
    if (filncat(pfil, "Hello, World!", 13) == NULL)
    {
	fildump(stream, pfil);
	return EXIT_FAILURE;
    }
    snv_fassert(stream, filval(pfil) != pval);
    snv_fassert(stream, strlen(filval(pfil)) == fillen(pfil));
    snv_fassert(stream, fillen(pfil) == (51 * 10) + 13);
    fildump(stream, pfil);
    
    return EXIT_SUCCESS;
}

/* filament-test.c ends here */
