.\" -*- mode: troff; coding: utf-8 -*-
.\" Automatically generated by Pod::Man v6.0.2 (Pod::Simple 3.45)
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" \*(C` and \*(C' are quotes in nroff, nothing in troff, for use with C<>.
.ie n \{\
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds C`
.    ds C'
'br\}
.\"
.\" Escape single quotes in literal strings from groff's Unicode transform.
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\"
.\" If the F register is >0, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.SS), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.\"
.\" Avoid warning from groff about undefined register 'F'.
.de IX
..
.nr rF 0
.if \n(.g .if rF .nr rF 1
.if (\n(rF:(\n(.g==0)) \{\
.    if \nF \{\
.        de IX
.        tm Index:\\$1\t\\n%\t"\\$2"
..
.        if !\nF==2 \{\
.            nr % 0
.            nr F 2
.        \}
.    \}
.\}
.rr rF
.\"
.\" Required to disable full justification in groff 1.23.0.
.if n .ds AD l
.\" ========================================================================
.\"
.IX Title "C++FILT 1"
.TH C++FILT 1 2025-11-10 binutils-2.45.1 "GNU Development Tools"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.if n .ad l
.nh
.SH NAME
cxxfilt \- demangle C++ and Java symbols
.SH SYNOPSIS
.IX Header "SYNOPSIS"
c++filt [\fB\-_\fR|\fB\-\-strip\-underscore\fR]
        [\fB\-n\fR|\fB\-\-no\-strip\-underscore\fR]
        [\fB\-p\fR|\fB\-\-no\-params\fR]
        [\fB\-t\fR|\fB\-\-types\fR]
        [\fB\-i\fR|\fB\-\-no\-verbose\fR]
        [\fB\-r\fR|\fB\-\-no\-recurse\-limit\fR]
        [\fB\-R\fR|\fB\-\-recurse\-limit\fR]
        [\fB\-s\fR \fIformat\fR|\fB\-\-format=\fR\fIformat\fR]
        [\fB\-\-help\fR]  [\fB\-\-version\fR]  [\fIsymbol\fR...]
.SH DESCRIPTION
.IX Header "DESCRIPTION"
The C++ and Java languages provide function overloading, which means
that you can write many functions with the same name, providing that
each function takes parameters of different types.  In order to be
able to distinguish these similarly named functions C++ and Java
encode them into a low\-level assembler name which uniquely identifies
each different version.  This process is known as \fImangling\fR. The
\&\fBc++filt\fR
[1]
program does the inverse mapping: it decodes (\fIdemangles\fR) low\-level
names into user\-level names so that they can be read.
.PP
Every alphanumeric word (consisting of letters, digits, underscores,
dollars, or periods) seen in the input is a potential mangled name.
If the name decodes into a C++ name, the C++ name replaces the
low\-level name in the output, otherwise the original word is output.
In this way you can pass an entire assembler source file, containing
mangled names, through \fBc++filt\fR and see the same source file
containing demangled names.
.PP
You can also use \fBc++filt\fR to decipher individual symbols by
passing them on the command line:
.PP
.Vb 1
\&        c++filt <symbol>
.Ve
.PP
If no \fIsymbol\fR arguments are given, \fBc++filt\fR reads symbol
names from the standard input instead.  All the results are printed on
the standard output.  The difference between reading names from the
command line versus reading names from the standard input is that
command\-line arguments are expected to be just mangled names and no
checking is performed to separate them from surrounding text.  Thus
for example:
.PP
.Vb 1
\&        c++filt \-n _Z1fv
.Ve
.PP
will work and demangle the name to "f()" whereas:
.PP
.Vb 1
\&        c++filt \-n _Z1fv,
.Ve
.PP
will not work.  (Note the extra comma at the end of the mangled
name which makes it invalid).  This command however will work:
.PP
.Vb 1
\&        echo _Z1fv, | c++filt \-n
.Ve
.PP
and will display "f(),", i.e., the demangled name followed by a
trailing comma.  This behaviour is because when the names are read
from the standard input it is expected that they might be part of an
assembler source file where there might be extra, extraneous
characters trailing after a mangled name.  For example:
.PP
.Vb 1
\&            .type   _Z1fv, @function
.Ve
.SH OPTIONS
.IX Header "OPTIONS"
.IP \fB\-_\fR 4
.IX Item "-_"
.PD 0
.IP \fB\-\-strip\-underscore\fR 4
.IX Item "--strip-underscore"
.PD
On some systems, both the C and C++ compilers put an underscore in front
of every name.  For example, the C name \f(CW\*(C`foo\*(C'\fR gets the low\-level
name \f(CW\*(C`_foo\*(C'\fR.  This option removes the initial underscore.  Whether
\&\fBc++filt\fR removes the underscore by default is target dependent.
.IP \fB\-n\fR 4
.IX Item "-n"
.PD 0
.IP \fB\-\-no\-strip\-underscore\fR 4
.IX Item "--no-strip-underscore"
.PD
Do not remove the initial underscore.
.IP \fB\-p\fR 4
.IX Item "-p"
.PD 0
.IP \fB\-\-no\-params\fR 4
.IX Item "--no-params"
.PD
When demangling the name of a function, do not display the types of
the function\*(Aqs parameters.
.IP \fB\-t\fR 4
.IX Item "-t"
.PD 0
.IP \fB\-\-types\fR 4
.IX Item "--types"
.PD
Attempt to demangle types as well as function names.  This is disabled
by default since mangled types are normally only used internally in
the compiler, and they can be confused with non\-mangled names.  For example,
a function called "a" treated as a mangled type name would be
demangled to "signed char".
.IP \fB\-i\fR 4
.IX Item "-i"
.PD 0
.IP \fB\-\-no\-verbose\fR 4
.IX Item "--no-verbose"
.PD
Do not include implementation details (if any) in the demangled
output.
.IP \fB\-r\fR 4
.IX Item "-r"
.PD 0
.IP \fB\-R\fR 4
.IX Item "-R"
.IP \fB\-\-recurse\-limit\fR 4
.IX Item "--recurse-limit"
.IP \fB\-\-no\-recurse\-limit\fR 4
.IX Item "--no-recurse-limit"
.IP \fB\-\-recursion\-limit\fR 4
.IX Item "--recursion-limit"
.IP \fB\-\-no\-recursion\-limit\fR 4
.IX Item "--no-recursion-limit"
.PD
Enables or disables a limit on the amount of recursion performed
whilst demangling strings.  Since the name mangling formats allow for
an infinite level of recursion it is possible to create strings whose
decoding will exhaust the amount of stack space available on the host
machine, triggering a memory fault.  The limit tries to prevent this
from happening by restricting recursion to 2048 levels of nesting.
.Sp
The default is for this limit to be enabled, but disabling it may be
necessary in order to demangle truly complicated names.  Note however
that if the recursion limit is disabled then stack exhaustion is
possible and any bug reports about such an event will be rejected.
.Sp
The \fB\-r\fR option is a synonym for the
\&\fB\-\-no\-recurse\-limit\fR option.  The \fB\-R\fR option is a
synonym for the \fB\-\-recurse\-limit\fR option.
.IP "\fB\-s\fR \fIformat\fR" 4
.IX Item "-s format"
.PD 0
.IP \fB\-\-format=\fR\fIformat\fR 4
.IX Item "--format=format"
.PD
\&\fBc++filt\fR can decode various methods of mangling, used by
different compilers.  The argument to this option selects which
method it uses:
.RS 4
.ie n .IP """auto""" 4
.el .IP \f(CWauto\fR 4
.IX Item "auto"
Automatic selection based on executable (the default method)
.ie n .IP """gnu""" 4
.el .IP \f(CWgnu\fR 4
.IX Item "gnu"
the one used by the GNU C++ compiler (g++)
.ie n .IP """lucid""" 4
.el .IP \f(CWlucid\fR 4
.IX Item "lucid"
the one used by the Lucid compiler (lcc)
.ie n .IP """arm""" 4
.el .IP \f(CWarm\fR 4
.IX Item "arm"
the one specified by the C++ Annotated Reference Manual
.ie n .IP """hp""" 4
.el .IP \f(CWhp\fR 4
.IX Item "hp"
the one used by the HP compiler (aCC)
.ie n .IP """edg""" 4
.el .IP \f(CWedg\fR 4
.IX Item "edg"
the one used by the EDG compiler
.ie n .IP """gnu\-v3""" 4
.el .IP \f(CWgnu\-v3\fR 4
.IX Item "gnu-v3"
the one used by the GNU C++ compiler (g++) with the V3 ABI.
.ie n .IP """java""" 4
.el .IP \f(CWjava\fR 4
.IX Item "java"
the one used by the GNU Java compiler (gcj)
.ie n .IP """gnat""" 4
.el .IP \f(CWgnat\fR 4
.IX Item "gnat"
the one used by the GNU Ada compiler (GNAT).
.RE
.RS 4
.RE
.IP \fB\-\-help\fR 4
.IX Item "--help"
Print a summary of the options to \fBc++filt\fR and exit.
.IP \fB\-\-version\fR 4
.IX Item "--version"
Print the version number of \fBc++filt\fR and exit.
.IP \fB@\fR\fIfile\fR 4
.IX Item "@file"
Read command\-line options from \fIfile\fR.  The options read are
inserted in place of the original @\fIfile\fR option.  If \fIfile\fR
does not exist, or cannot be read, then the option will be treated
literally, and not removed.
.Sp
Options in \fIfile\fR are separated by whitespace.  A whitespace
character may be included in an option by surrounding the entire
option in either single or double quotes.  Any character (including a
backslash) may be included by prefixing the character to be included
with a backslash.  The \fIfile\fR may itself contain additional
@\fIfile\fR options; any such options will be processed recursively.
.SH FOOTNOTES
.IX Header "FOOTNOTES"
.IP 1. 4
MS\-DOS does not allow \f(CW\*(C`+\*(C'\fR characters in file names, so on
MS\-DOS this program is named \fBCXXFILT\fR.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
the Info entries for \fIbinutils\fR.
.SH COPYRIGHT
.IX Header "COPYRIGHT"
Copyright (c) 1991\-2025 Free Software Foundation, Inc.
.PP
Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3
or any later version published by the Free Software Foundation;
with no Invariant Sections, with no Front\-Cover Texts, and with no
Back\-Cover Texts.  A copy of the license is included in the
section entitled "GNU Free Documentation License".
