;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: GILT; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; This file originally created by Gilt, then hacked to pieces

#|
============================================================
Change log:
     2/18/92 Brad Myers - added constant definitions
     3/11/91 Osamu Hashimoto - moved cr-align-func and Show-Align-Dialogbox from
                               align-imp.lisp
     2/20/91 Osamu Hashimoto - separated it from "implementation"
     1/ 3/91 Osamu Hashimoto - created
============================================================
|#

;;; This file uses the following objects:
;;;     LINE from package OPAL
;;;     TEXT-BUTTON-PANEL from package GARNET-GADGETS
;;;     RADIO-BUTTON-PANEL from package GARNET-GADGETS
;;;     X-BUTTON-PANEL from package GARNET-GADGETS
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "GILT" :use '("LISP" "KR"))



(defun cr-align-func (gadget value)
  (declare (ignore gadget value))
  (let* ((cr         (g-value align-prop :c-r-align))
	 (new-value  (car (g-value cr :value)))
	 (col-gray   (g-value align-prop :column-grayout))
	 (row-gray   (g-value align-prop :row-grayout)))
    (when (string= "Column" new-value)
      (s-value cr :value '("Column"))
      (s-value col-gray :visible NIL)
      (s-value row-gray :visible T))
    (when (string= "Row" new-value)
      (s-value cr :value '("Row"))
      (s-value row-gray :visible NIL)
      (s-value col-gray :visible T))
    (when (null new-value)
      (s-value col-gray :visible T)
      (s-value row-gray :visible T))
))



(defun Show-Align-DialogBox ()
  (let ((selected-objs (length (g-value *selection-obj* :value))))
    (when (<= selected-objs 0)
      (Gilt-Error "Nothing Selected")
      (return-from Show-Align-DialogBox NIL))
    (when (<= selected-objs 1)
      (Gilt-Error "Must have more than one item selected for Align")
      (return-from Show-Align-DialogBox NIL)))
    
  (let ((cr        (g-value align-prop :C-R-ALIGN))
	(size      (g-value align-prop :same-size-style))
	(col-style (g-value align-prop :column :column-align-style))
	(row-style (g-value align-prop :row :row-align-style))
	(col-gray  (g-value align-prop :column-grayout))
	(row-gray  (g-value align-prop :row-grayout))
	(height-gray (g-value align-prop :height-grayout))
	(width-gray  (g-value align-prop :width-grayout)))

    (g-value cr :value) (s-value cr :value NIL)
    (g-value col-style :value) (s-value col-style :value "Left")
    (g-value row-style :value) (s-value row-style :value "Top")
    (s-value col-gray :visible T)
    (s-value row-gray :visible T)

    (g-value size :value) (s-value size :value NIL)
    (s-value height-gray :visible T)
    (s-value width-gray :visible T)
    (dolist (obj (g-value *selection-obj* :value))
      (let ((slots (g-value obj :gilt-type :changeable-slots)))
	(when (third slots) (s-value height-gray :visible NIL))
	(when (fourth slots) (s-value width-gray :visible NIL))
	(when (and (third slots) (fourth slots)) (return))))

    (let ((lowest 0)
	  (lowest-obj NIL))
      (dolist (obj (g-value *selection-obj* :value))
	(let ((bottom (+ (g-value obj :top) (g-value obj :height))))
	  (when (<= lowest bottom)
	    (setq lowest bottom) (setq lowest-obj obj))))
      (let ((left (g-value lowest-obj :left))
	    (top  (g-value lowest-obj :top)))
	(multiple-value-setq (left top)
	  (opal:convert-coordinates (g-value lowest-obj :window)
				    (g-value lowest-obj :left)
				    (opal:bottom lowest-obj) NIL))
	(setq top (+ 40 top))
	(show-in-window align-prop left top)))

))







(create-instance 'Column-align OPAL:AGGREGADGET
  (:parts `(
    (:COLUMN-ALIGN-STYLE ,GARNET-GADGETS:RADIO-BUTTON-PANEL
      (:CONSTANT (T))
      (:SELECTION-FUNCTION NIL)
      (:GILT-REF "TYPE-RADIO-BUTTON-PANEL")
      (:INDENT 0)
      (:V-ALIGN :TOP)
      (:H-SPACING 5)
      (:DIRECTION :VERTICAL)
      (:SELECT-FUNCTION NIL)
      (:H-ALIGN :RIGHT)
      (:GRAY-WIDTH 3)
      (:TEXT-ON-LEFT-P T)
      (:V-SPACING 2)
      (:FIXED-HEIGHT-P T)
      (:PIXEL-MARGIN NIL)
      (:RANK-MARGIN NIL)
      (:TEXT-OFFSET 5)
      (:SHADOW-OFFSET 5)
      (:BUTTON-DIAMETER 23)
      (:FONT ,OPAL:DEFAULT-FONT)
      (:FIXED-WIDTH-P T)
      (:BOX (105 18 74 88 ))
      (:ITEMS ("Left" "Centered" "Right" ))
      (:LEFT ,(o-formula (FIRST (KR:GVL :BOX)) 205))
      (:TOP ,(o-formula (SECOND (KR:GVL :BOX)) 18)))
;;; column-align's icons
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (205 23 230 23 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 294))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 53))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 316))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 53)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (205 28 219 28 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 293))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 59))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 309))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 59)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (205 33 217 33 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 294))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 64))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 307))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 64)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (205 38 222 38 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 294))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 68))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 312))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 68)))
;;;
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (205 55 230 55 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 295))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 23))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 321))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 23)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (211 60 225 60 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 301))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 27))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 315))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 27)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (214 65 222 65 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 304))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 32))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 312))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 32)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (206 70 229 70 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 294))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 36))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 324))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 36)))
;;;
    (NIL ,OPAL:LINE
      (:GILT-REF "TYPE-LINE")
      (:CONSTANT (T))
      (:POINTS (205 87 230 87 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 293))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 83))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 320))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 83)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (210 92 230 92 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 300))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 89))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 318))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 89)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (213 97 230 97 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 303))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 93))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 315))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 93)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (207 103 230 103 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 294))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 96))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 317))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 96)))
)))

(create-instance 'Row-align OPAL:AGGREGADGET
  (:parts `(
    (:ROW-ALIGN-STYLE ,GARNET-GADGETS:RADIO-BUTTON-PANEL
      (:CONSTANT (T))
      (:SELECTION-FUNCTION NIL)
      (:GILT-REF "TYPE-RADIO-BUTTON-PANEL")
      (:ITEMS ("Top" "Centered" "Bottom" ))
      (:BOX (105 122 88 88 ))
      (:FIXED-WIDTH-P T)
      (:FONT ,OPAL:DEFAULT-FONT)
      (:BUTTON-DIAMETER 23)
      (:SHADOW-OFFSET 5)
      (:TEXT-OFFSET 5)
      (:RANK-MARGIN NIL)
      (:PIXEL-MARGIN NIL)
      (:FIXED-HEIGHT-P T)
      (:V-SPACING 2)
      (:TEXT-ON-LEFT-P T)
      (:GRAY-WIDTH 3)
      (:H-ALIGN :RIGHT)
      (:SELECT-FUNCTION NIL)
      (:DIRECTION :VERTICAL)
      (:H-SPACING 5)
      (:V-ALIGN :TOP)
      (:INDENT 0)
      (:LEFT ,(o-formula (FIRST (KR:GVL :BOX)) 194))
      (:TOP ,(o-formula (SECOND (KR:GVL :BOX)) 118)))
;;; row-align's icons
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (205 125 205 142 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 295))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 154))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 295))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 175)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (213 125 213 135 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 300))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 153))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 300))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 167)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (221 125 221 137 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 305))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 153))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 305))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 169)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (229 125 229 141 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 312))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 153))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 312))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 173)))
;;;
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (205 157 205 174 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 296))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 122))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 296))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 142)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (213 162 213 169 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 301))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 126))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 301))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 138)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (221 160 221 171 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 307))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 128))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 307))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 137)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (229 157 229 174 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 311))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 121))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 311))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 142)))
;;;
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (205 189 205 206 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 296))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 186))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 296))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 207)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (213 192 213 206 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 302))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 192))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 302))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 205)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (221 194 221 206 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 306))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 194))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 306))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 205)))
    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (229 187 229 206 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 311))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 187))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 311))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 206)))
)))


(create-instance 'ALIGN-PROP OPAL:AGGREGADGET
  (:WINDOW-TITLE "Align Objects")
  (:WINDOW-LEFT 600)
  (:WINDOW-TOP 0)
  (:WINDOW-WIDTH 250)
  (:WINDOW-HEIGHT 330)
  (:PACKAGE-NAME "GILT")
  (:FUNCTION-FOR-OK `GILT::align-dialog-ok)
  (:LEFT 0)
  (:TOP 0)
  (:WIDTH (o-formula (KR:GVL :WINDOW :WIDTH) 450))
  (:HEIGHT (o-formula (KR:GVL :WINDOW :HEIGHT) 300))
  (:parts `(
    (:C-R-ALIGN ,GARNET-GADGETS:X-BUTTON-PANEL
      (:CONSTANT (T))
      (:SELECTION-FUNCTION cr-align-func)
      (:GILT-REF "TYPE-X-BUTTON-PANEL")
      (:INDENT 0)
      (:V-ALIGN :TOP)
      (:H-SPACING 5)
      (:DIRECTION :VERTICAL)
      (:SELECT-FUNCTION NIL)
      (:H-ALIGN :RIGHT)
      (:GRAY-WIDTH 3)
      (:TEXT-ON-LEFT-P T)
      (:V-SPACING 80)
      (:BUTTON-HEIGHT 20)
      (:FIXED-HEIGHT-P NIL)
      (:PIXEL-MARGIN NIL)
      (:RANK-MARGIN NIL)
      (:TEXT-OFFSET 5)
      (:SHADOW-OFFSET 5)
      (:BUTTON-WIDTH 20)
      (:button-diameter 20)
      (:FONT ,(create-instance nil OPAL:FONT
	    (:CONSTANT '(T))
            (:SIZE :medium)
            (:FACE :BOLD)))
      (:FIXED-WIDTH-P T)
      (:BOX (15 20 71 120 ))
      (:ITEMS ("Column" "Row" ))
      (:LEFT ,(o-formula (FIRST (KR:GVL :BOX)) 93))
      (:TOP ,(o-formula (SECOND (KR:GVL :BOX)) 23)))

    (:column ,column-align)
    (:row ,row-align)

    (NIL ,OPAL:LINE
      (:CONSTANT (T))
      (:GILT-REF "TYPE-LINE")
      (:POINTS (10 220 150 220 ))
      (:LINE-P T)
      (:X1 ,(o-formula (FIRST (KR:GVL :POINTS)) 295))
      (:Y1 ,(o-formula (SECOND (KR:GVL :POINTS)) 23))
      (:X2 ,(o-formula (THIRD (KR:GVL :POINTS)) 321))
      (:Y2 ,(o-formula (FOURTH (KR:GVL :POINTS)) 23)))

    (:same-size-style ,GARNET-GADGETS:X-BUTTON-PANEL
      (:CONSTANT (T))
      (:SELECTION-FUNCTION NIL)
      (:GILT-REF "TYPE-X-BUTTON-PANEL")
      (:ITEMS ( "Same Width" "Same Height"))
      (:BOX (15 225 95 60 ))
      (:FIXED-WIDTH-P T)
      (:FONT ,(create-instance nil OPAL:FONT
	    (:CONSTANT '(T))
            (:SIZE :medium)
            (:FACE :BOLD)))
      (:BUTTON-WIDTH 20)
      (:SHADOW-OFFSET 5)
      (:TEXT-OFFSET 5)
      (:RANK-MARGIN NIL)
      (:PIXEL-MARGIN NIL)
      (:FIXED-HEIGHT-P NIL)
      (:BUTTON-HEIGHT 20)
      (:V-SPACING 10)
      (:TEXT-ON-LEFT-P T)
      (:GRAY-WIDTH 3)
      (:H-ALIGN :RIGHT)
      (:SELECT-FUNCTION NIL)
      (:DIRECTION :VERTICAL)
      (:H-SPACING 5)
      (:V-ALIGN :TOP)
      (:INDENT 0)
      (:LEFT ,(o-formula (FIRST (KR:GVL :BOX)) 70))
      (:TOP ,(o-formula (SECOND (KR:GVL :BOX)) 218)))

    (:OK-CANCEL ,GARNET-GADGETS:Text-button-panel
      (:CONSTANT (T))
      (:SELECTION-FUNCTION GILT:OKCANCEL-FUNCTION)
      (:GILT-REF "TYPE-OKCANCEL")
      (:INDENT 0)
      (:V-ALIGN :TOP)
      (:V-SPACING 5)
      (:H-ALIGN :CENTER)
      (:FIXED-HEIGHT-P T)
      (:H-SPACING 5)
      (:PIXEL-MARGIN NIL)
      (:RANK-MARGIN NIL)
      (:FIXED-WIDTH-P T)
      (:SELECT-FUNCTION GILT:OKCANCEL-FUNCTION)
      (:ITEMS ("OK" "Apply" "Cancel" ))
      (:GRAY-WIDTH 3)
      (:FINAL-FEEDBACK-P NIL)
      (:TEXT-OFFSET 2)
      (:SHADOW-OFFSET 5)
      (:DIRECTION :VERTICAL)
      (:BOX (175 225 117 29 ))
      (:LEFT ,(o-formula (FIRST (KR:GVL :BOX)) 199))
      (:TOP ,(o-formula (SECOND (KR:GVL :BOX)) 244)))

    (:column-grayout ,opal:rectangle
      (:CONSTANT (T :except :visible))
      (:draw-function :and)
      (:filling-style ,opal:dark-gray-fill)
      (:left 105)(:top 18)
      (:width 130)(:height 95)
      (:visible T))
    (:row-grayout ,opal:rectangle
      (:CONSTANT (T :except :visible))
      (:draw-function :and)
      (:filling-style ,opal:dark-gray-fill)
      (:left 105)(:top 122)
      (:width 130)(:height 95)
      (:visible T))
    (:height-grayout ,opal:rectangle
      (:CONSTANT (T :except :visible))
      (:draw-function :and)
      (:filling-style ,opal:dark-gray-fill)
      (:left 10)(:top 225)
      (:width 130)(:height 30)
      (:visible T))
    (:width-grayout ,opal:rectangle
      (:CONSTANT (T :except :visible))
      (:draw-function :and)
      (:filling-style ,opal:dark-gray-fill)
      (:left 10)(:top 255)
      (:width 130)(:height 30)
      (:visible T))

)))

