;;; -*- Mode: Lisp; Base: 10; Syntax: Common-Lisp; Package: DSYS -*-
;;; File: common-lisp/sysdef.lisp 
;;; Author: Richard Harris

(in-package "DSYS")

(defsystem common-lisp
	   (:pretty-name "Common Lisp Systems")
  (:module clos pcl (:type :system))
  (:module clcs clcs (:type :system))
  (:parallel
    clos
    clcs
    #+kcl
    (:parallel
      "loop"
      ;;"xp"
      ;;"s"
      ;;"logical-pathnames"
      )
    (:serial
     "package"
     "exports")))

(defun common-lisp-files ()
  (append *pcl-files*
	  *clcs-files*
	  '((("systems") "lisp"
	     "common-lisp")
	    (("common-lisp") "lisp"
	     "sysdef")
	    (("common-lisp") "lisp" 
	     "loop"
	     ;;"xp" "xptest"
	     ;;"s" "stest"
	     ;;"logical-pathnames"
	     "package" "exports")
	    (("common-lisp") "txt"
	     ;;"xpdoc" "sdoc"
	     ))))
