


CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



NAME
     readline - get a line from a user with editing

NOTATION
     An emacs-style notation is used to denote keystrokes.   Con-
     trol  keys  are denoted by C-_k_e_y, e.g., C-n means Control-N.
     Similarly, _m_e_t_a keys are denoted  by  M-_k_e_y,  so  M-x  means
     Meta-X.   (On keyboards without a _m_e_t_a key, M-_x means ESC _x,
     i.e., press the Escape key then the _x key.  This  makes  ESC
     the _m_e_t_a _p_r_e_f_i_x.  The combination M-C-_x means ESC-Control-_x,
     or press the Escape key then  hold  the  Control  key  while
     pressing the _x key.)

     Readline commands may be given numeric _a_r_g_u_m_e_n_t_s, which nor-
     mally  act as a repeat count.  Sometimes, however, it is the
     sign of the argument that is significant.  Passing  a  nega-
     tive  argument  to a command that acts in the forward direc-
     tion (e.g., kill-line) causes that command to act in a back-
     ward  direction.   Commands  whose  behavior  with arguments
     deviates from this are noted.

     When a command  is  described  as  _k_i_l_l_i_n_g  text,  the  text
     deleted  is  saved  for possible future retrieval (_y_a_n_k_i_n_g).
     The killed text is saved in a _k_i_l_l _r_i_n_g.  Consecutive  kills
     cause the text to be accumulated into one unit, which can be
     yanked all at once. Commands which do not kill text separate
     the chunks of text on the kill ring.

INITIALIZATION FILE
     Readline is customized by putting commands in an initializa-
     tion  file  (the  _i_n_p_u_t_r_c  file).   The name of this file is
     taken from the value of the  INPUTRC  environment  variable.
     If  that variable is unset, the default is ~/._i_n_p_u_t_r_c.  When
     a program which uses the readline  library  starts  up,  the
     init  file  is  read, and the key bindings and variables are
     set.  There are only a few basic constructs allowed  in  the
     readline  init file.  Blank lines are ignored.  Lines begin-
     ning with a # are comments.  Lines beginning with a $  indi-
     cate  conditional  constructs.  Other lines denote key bind-
     ings and variable settings.  Each program using this library
     may add its own commands and bindings.

     For example, placing

          M-Control-u: universal-argument
     or
          C-Meta-u: universal-argument
     into the _i_n_p_u_t_r_c would make M-C-u execute the readline  com-
     mand _u_n_i_v_e_r_s_a_l-_a_r_g_u_m_e_n_t.

     The following symbolic character names are recognized  while
     processing  key  bindings:  _R_U_B_O_U_T,  _D_E_L, _E_S_C, _L_F_D, _N_E_W_L_I_N_E,



GNU               Last change: 1998 October 11                  1






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



     _R_E_T, _R_E_T_U_R_N, _S_P_C, _S_P_A_C_E, and _T_A_B.  In  addition  to  command
     names,  readline allows keys to be bound to a string that is
     inserted when the key is pressed (a _m_a_c_r_o).

  Key Bindings
     The syntax for controlling key bindings in the _i_n_p_u_t_r_c  file
     is  simple.  All that is required is the name of the command
     or the text of a macro and a key sequence to which it should
     be bound. The name may be specified in one of two ways: as a
     symbolic key name, possibly with _M_e_t_a- or _C_o_n_t_r_o_l- prefixes,
     or    as    a   key   sequence.    When   using   the   form
     keyname:_f_u_n_c_t_i_o_n-_n_a_m_e or _m_a_c_r_o, _k_e_y_n_a_m_e is the name of a key
     spelled out in English.  For example:

          Control-u: universal-argument
          Meta-Rubout: backward-kill-word
          Control-o: ">&output"

     In  the  above  example,  _C-_u  is  bound  to  the   function
     universal-argument,   _M-_D_E_L   is   bound   to  the  function
     backward-kill-word, and  _C-_o  is  bound  to  run  the  macro
     expressed  on  the  right  hand side (that is, to insert the
     text >&_o_u_t_p_u_t into the line).

     In the second form, "keyseq":_f_u_n_c_t_i_o_n-_n_a_m_e or _m_a_c_r_o,  keyseq
     differs  from  keyname  above  in  that  strings denoting an
     entire key sequence may be specified by placing the sequence
     within  double quotes.  Some GNU Emacs style key escapes can
     be used, as in the following example.

          "\C-u": universal-argument
          "\C-x\C-r": re-read-init-file
          "\e[11~": "Function Key 1"

     In  this  example,  _C-_u  is  again  bound  to  the  function
     universal-argument.   _C-_x  _C-_r  is  bound  to  the  function
     re-read-init-file, and _E_S_C [ _1 _1 ~ is bound  to  insert  the
     text Function Key 1.  The full set of GNU Emacs style escape
     sequences is
          \C-  control prefix
          \M-  meta prefix
          \e   an escape character
          \\   backslash
          " \" literal "
          \'   literal '

     In addition to the  GNU  Emacs  style  escape  sequences,  a
     second set of backslash escapes is available:
          \a   alert (bell)
          \b   backspace
          \d   delete
          \f   form feed



GNU               Last change: 1998 October 11                  2






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



          \n   newline
          \r   carriage return
          \t   horizontal tab
          \v   vertical tab
          \_n_n_n the character whose ASCII code is the octal  value
               _n_n_n (one to three digits)
          \x_n_n_n
               the character whose ASCII code is the  hexadecimal
               value _n_n_n (one to three digits)

     When entering the text of a macro, single or  double  quotes
     should  be  used  to  indicate a macro definition.  Unquoted
     text is assumed to be a function name.  In the  macro  body,
     the   backslash   escapes   described  above  are  expanded.
     Backslash will quote any other character in the macro  text,
     including " and '.

     Bash  allows  the  current  readline  key  bindings  to   be
     displayed  or  modified  with the bind builtin command.  The
     editing mode may be switched during interactive use by using
     the  -o  option  to the set builtin command.  Other programs
     using this library provide similar mechanisms.  The  _i_n_p_u_t_r_c
     file may be edited and re-read if a program does not provide
     any other means to incorporate new bindings.

  Variables
     Readline has variables that can be used to further customize
     its  behavior.   A  variable  may be set in the _i_n_p_u_t_r_c file
     with a statement of the form

          set _v_a_r_i_a_b_l_e-_n_a_m_e _v_a_l_u_e

     Except where noted, readline variables can take  the  values
     On or Off.  The variables and their default values are:

     bell-style (audible)
          Controls what happens when readline wants to  ring  the
          terminal  bell.   If  set to none, readline never rings
          the bell.  If set to visible, readline uses  a  visible
          bell  if one is available.  If set to audible, readline
          attempts to ring the terminal's bell.
     comment-begin (``;'')
          The string  that  is  inserted  in  vi  mode  when  the
          insert-comment  command  is  executed.  This command is
          bound to M-# in emacs mode and to # in vi command mode.
     completion-ignore-case (Off)
          If set to On, readline performs filename  matching  and
          completion in a case-insensitive fashion.
     blink-matching-paren (On)
          If set to On, readline will display  the  corresponding
          opening  parenthesis  when  a  closing  parenthesis  is
          typed.



GNU               Last change: 1998 October 11                  3






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



     completion-query-items (100)
          This determines when the user is queried about  viewing
          the  number  of  possible  completions generated by the
          possible-completions command.  It may  be  set  to  any
          integer  value  greater  than or equal to zero.  If the
          number of possible completions is greater than or equal
          to  the  value  of  this  variable,  the  user is asked
          whether or not he wishes to view them;  otherwise  they
          are simply listed on the terminal.
     disable-completion (Off)
          If set to On, readline will  inhibit  word  completion.
          Completion characters will be inserted into the line as
          if they had been mapped to self-insert.
     editing-mode (emacs)
          Controls whether readline begins  with  a  set  of  key
          bindings  similar  to _e_m_a_c_s or _v_i.  editing-mode can be
          set to either emacs or vi.
     enable-keypad (Off)
          When set to On, readline will try to enable the  appli-
          cation  keypad  when  it  is called.  Some systems need
          this to enable the arrow keys.
     expand-tilde (Off)
          If set to on, tilde expansion is performed  when  read-
          line attempts word completion.
     horizontal-scroll-mode (Off)
          When set to On, makes readline use a  single  line  for
          display,  scrolling  the input horizontally on a single
          screen line when it  becomes  longer  than  the  screen
          width rather than wrapping to a new line.
     keymap (emacs)
          Set the current readline keymap.  The set of legal key-
          map  names is _e_m_a_c_s, _e_m_a_c_s-_s_t_a_n_d_a_r_d, _e_m_a_c_s-_m_e_t_a, _e_m_a_c_s-
          _c_t_l_x, _v_i, _v_i-_m_o_v_e, _v_i-_c_o_m_m_a_n_d, and  _v_i-_i_n_s_e_r_t.   _v_i  is
          equivalent   to  _v_i-_c_o_m_m_a_n_d;  _e_m_a_c_s  is  equivalent  to
          _e_m_a_c_s-_s_t_a_n_d_a_r_d.  The default value is _e_m_a_c_s; the  value
          of editing-mode also affects the default keymap.
     mark-directories (On)
          If set to On, completed directory names  have  a  slash
          appended.
     mark-modified-lines (Off)
          If set to On, history lines that have been modified are
          displayed with a preceding asterisk (*).
     convert-meta (On)
          If set to On, readline will convert characters with the
          eighth  bit  set  to an ASCII key sequence by stripping
          the eighth bit and prepending an escape  character  (in
          effect, using escape as the _m_e_t_a _p_r_e_f_i_x).
     meta-flag (Off)
          If set to On,  readline  will  enable  eight-bit  input
          (that is, it will not strip the high bit from the char-
          acters it  reads),  regardless  of  what  the  terminal
          claims it can support.



GNU               Last change: 1998 October 11                  4






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



     output-meta (Off)
          If set to On, readline will display characters with the
          eighth  bit set directly rather than as a meta-prefixed
          escape sequence.
     print-completions-horizontally (Off)
          If set to On, readline will  display  completions  with
          matches  sorted  horizontally  in  alphabetical  order,
          rather than down the screen.
     show-all-if-ambiguous (Off)
          This alters the  default  behavior  of  the  completion
          functions.   If  set  to on, words which have more than
          one possible completion cause the matches to be  listed
          immediately instead of ringing the bell.
     visible-stats (Off)
          If set to On, a character denoting  a  file's  type  as
          reported  by  stat(2)  is appended to the filename when
          listing possible completions.

  Conditional Constructs
     Readline implements a facility similar in spirit to the con-
     ditional  compilation  features  of the C preprocessor which
     allows key bindings and variable settings to be performed as
     the result of tests.  There are four parser directives used.

     $if  The $if construct allows bindings to be made  based  on
          the  editing  mode,  the  terminal  being  used, or the
          application using  readline.   The  text  of  the  test
          extends  to  the  end  of  the  line; no characters are
          required to isolate it.

          mode The mode= form of the $if  directive  is  used  to
               test  whether  readline  is  in  emacs or vi mode.
               This may be used in conjunction with the set  key-
               map  command, for instance, to set bindings in the
               _e_m_a_c_s-_s_t_a_n_d_a_r_d  and  _e_m_a_c_s-_c_t_l_x  keymaps  only  if
               readline is starting out in emacs mode.

          term The term= form may be used  to  include  terminal-
               specific  key  bindings,  perhaps  to bind the key
               sequences output by the terminal's function  keys.
               The  word  on  the  right  side of the = is tested
               against the full name of the terminal and the por-
               tion  of  the  terminal  name  before the first -.
               This allows _s_u_n to match both _s_u_n and _s_u_n-_c_m_d, for
               instance.

          application
               The  application  construct  is  used  to  include
               application-specific settings.  Each program using
               the readline library sets  the  _a_p_p_l_i_c_a_t_i_o_n  _n_a_m_e,
               and an initialization file can test for a particu-
               lar  value.   This  could  be  used  to  bind  key



GNU               Last change: 1998 October 11                  5






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



               sequences  to functions useful for a specific pro-
               gram.  For instance, the following command adds  a
               key  sequence  that quotes the current or previous
               word in Bash:

               $if bash
               # Quote the current or previous word
               "\C-xq": "\eb\"\ef\""
               $endif

     $endif
          This command, as seen in  the  previous  example,  ter-
          minates an $if command.

     $else
          Commands in this branch of the $if directive  are  exe-
          cuted if the test fails.

     $include
          This directive takes a single filename as  an  argument
          and  reads  commands  and bindings from that file.  For
          example,   the   following   directive    would    read
          /_e_t_c/_i_n_p_u_t_r_c:

          $include  /_e_t_c/_i_n_p_u_t_r_c

SEARCHING
     Readline provides commands for searching through the command
     history  for lines containing a specified string.  There are
     two search modes: _i_n_c_r_e_m_e_n_t_a_l and _n_o_n-_i_n_c_r_e_m_e_n_t_a_l.

     Incremental searches begin before the user has finished typ-
     ing  the  search  string.   As  each character of the search
     string is typed, readline displays the next entry  from  the
     history  matching  the  string typed so far.  An incremental
     search requires only as many characters as  needed  to  find
     the  desired history entry.  The Escape character is used to
     terminate an incremental search.  Control-J will  also  ter-
     minate  the  search.   Control-G  will  abort an incremental
     search and restore the original line.  When  the  search  is
     terminated,  the  history entry containing the search string
     becomes the current line.  To find other matching entries in
     the  history  list, type Control-S or Control-R as appropri-
     ate.  This will search backward or forward  in  the  history
     for  the  next line matching the search string typed so far.
     Any other key sequence bound to a readline command will ter-
     minate the search and execute that command.  For instance, a
     _n_e_w_l_i_n_e will terminate  the  search  and  accept  the  line,
     thereby executing the command from the history list.

     Non-incremental  searches  read  the  entire  search  string
     before  starting  to search for matching history lines.  The



GNU               Last change: 1998 October 11                  6






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



     search string may be typed by the user or  be  part  of  the
     contents of the current line.

EDITING COMMANDS
     The following is a list of the names of the commands and the
     default  key  sequences  to  which  they are bound.  Command
     names without an accompanying key sequence  are  unbound  by
     default.

  Commands for Moving
     beginning-of-line (C-a)
          Move to the start of the current line.
     end-of-line (C-e)
          Move to the end of the line.
     forward-char (C-f)
          Move forward a character.
     backward-char (C-b)
          Move back a character.
     forward-word (M-f)
          Move forward to the end of the next  word.   Words  are
          composed   of   alphanumeric  characters  (letters  and
          digits).
     backward-word (M-b)
          Move back to the start of this, or the previous,  word.
          Words  are composed of alphanumeric characters (letters
          and digits).
     clear-screen (C-l)
          Clear the screen leaving the current line at the top of
          the screen.  With an argument, refresh the current line
          without clearing the screen.
     redraw-current-line
          Refresh the current line.

  Commands for Manipulating the History
     accept-line (Newline, Return)
          Accept the line regardless of where the cursor is.   If
          this  line is non-empty, add it to the history list. If
          the line is a modified history line, then  restore  the
          history line to its original state.
     previous-history (C-p)
          Fetch the previous command from the history list,  mov-
          ing back in the list.
     next-history (C-n)
          Fetch the next command from the  history  list,  moving
          forward in the list.
     beginning-of-history (M-<)
          Move to the first line in the history.
     end-of-history (M->)
          Move to the end of the input history,  i.e.,  the  line
          currently being entered.
     reverse-search-history (C-r)
          Search backward starting at the current line and moving



GNU               Last change: 1998 October 11                  7






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



          `up'  through  the  history  as  necessary.  This is an
          incremental search.
     forward-search-history (C-s)
          Search forward starting at the current line and  moving
          `down'  through  the  history as necessary.  This is an
          incremental search.
     non-incremental-reverse-search-history (M-p)
          Search backward through the  history  starting  at  the
          current  line  using  a  non-incremental  search  for a
          string supplied by the user.
     non-incremental-forward-search-history (M-n)
          Search  forward  through  the  history  using  a   non-
          incremental search for a string supplied by the user.
     history-search-forward
          Search forward through the history for  the  string  of
          characters  between  the  start of the current line and
          the current cursor position (the  _p_o_i_n_t).   This  is  a
          non-incremental search.
     history-search-backward
          Search backward through the history for the  string  of
          characters  between  the  start of the current line and
          the point.  This is a non-incremental search.
     yank-nth-arg (M-C-y)
          Insert the first argument to the previous command (usu-
          ally  the  second  word  on the previous line) at point
          (the current cursor position).   With  an  argument  _n,
          insert  the  _nth  word  from  the previous command (the
          words in the previous command begin with  word  0).   A
          negative  argument inserts the _nth word from the end of
          the previous command.
     yank-last-arg (M-., M-_)
          Insert the last argument to the previous  command  (the
          last  word  of  the  previous  history entry).  With an
          argument, behave exactly like yank-nth-arg.  Successive
          calls  to  yank-last-arg  move back through the history
          list, inserting the last argument of each line in turn.

  Commands for Changing Text
     delete-char (C-d)
          Delete the character under the cursor.  If point is  at
          the  beginning  of the line, there are no characters in
          the line, and the last character typed was not bound to
          delete-char, then return EOF.
     backward-delete-char (Rubout)
          Delete the character behind the cursor.  When  given  a
          numeric  argument,  save  the  deleted text on the kill
          ring.
     quoted-insert (C-q, C-v)
          Add the next character that you type to the line verba-
          tim.   This  is  how to insert characters like C-q, for
          example.
     tab-insert (M-TAB)



GNU               Last change: 1998 October 11                  8






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



          Insert a tab character.
     self-insert (a, b, A, 1, !, ...)
          Insert the character typed.
     transpose-chars (C-t)
          Drag the character before point forward over the  char-
          acter at point.  Point moves forward as well.  If point
          is at the end of the line, then transpose the two char-
          acters before point.  Negative arguments don't work.
     transpose-words (M-t)
          Drag the word behind the cursor past the word in  front
          of the cursor moving the cursor over that word as well.
     upcase-word (M-u)
          Uppercase the current  (or  following)  word.   With  a
          negative  argument, uppercase the previous word, but do
          not move point.
     downcase-word (M-l)
          Lowercase the current  (or  following)  word.   With  a
          negative  argument, lowercase the previous word, but do
          not move point.
     capitalize-word (M-c)
          Capitalize the current (or  following)  word.   With  a
          negative argument, capitalize the previous word, but do
          not move point.

  Killing and Yanking
     kill-line (C-k)
          Kill the text from the current cursor position  to  the
          end of the line.
     backward-kill-line (C-x Rubout)
          Kill backward to the beginning of the line.
     unix-line-discard (C-u)
          Kill backward from point to the beginning of the  line.
          The killed text is saved on the kill-ring.
     kill-whole-line
          Kill all characters on  the  current  line,  no  matter
          where the cursor is.
     kill-word (M-d)
          Kill from the cursor to the end of the current word, or
          if  between  words,  to the end of the next word.  Word
          boundaries are the same as those used by forward-word.
     backward-kill-word (M-Rubout)
          Kill the word behind the cursor.  Word  boundaries  are
          the same as those used by backward-word.
     unix-word-rubout (C-w)
          Kill the word behind the cursor, using white space as a
          word  boundary.  The word boundaries are different from
          backward-kill-word.
     delete-horizontal-space (M-\)
          Delete all spaces and tabs around point.
     kill-region
          Kill the text between the point and _m_a_r_k (saved  cursor
          position).  This text is referred to as the _r_e_g_i_o_n.



GNU               Last change: 1998 October 11                  9






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



     copy-region-as-kill
          Copy the text in the region to the kill buffer.
     copy-backward-word
          Copy the word before point to  the  kill  buffer.   The
          word boundaries are the same as backward-word.
     copy-forward-word
          Copy the word following point to the kill buffer.   The
          word boundaries are the same as forward-word.
     yank (C-y)
          Yank the top of the kill ring into the  buffer  at  the
          cursor.
     yank-pop (M-y)
          Rotate the kill ring, and yank the new top.  Only works
          following yank or yank-pop.

  Numeric Arguments
     digit-argument (M-0, M-1, ..., M--)
          Add this digit to the argument already accumulating, or
          start a new argument.  M-- starts a negative argument.
     universal-argument
          This is another way to specify an  argument.   If  this
          command  is  followed by one or more digits, optionally
          with a leading minus  sign,  those  digits  define  the
          argument.   If  the command is followed by digits, exe-
          cuting universal-argument again ends the numeric  argu-
          ment,  but is otherwise ignored.  As a special case, if
          this command is immediately  followed  by  a  character
          that  is  neither  a  digit or minus sign, the argument
          count for the next command is multiplied by four.   The
          argument  count  is  initially  one,  so executing this
          function the first time makes the argument count  four,
          a  second time makes the argument count sixteen, and so
          on.

  Completing
     complete (TAB)
          Attempt to perform completion on the text before point.
          The   actual   completion   performed  is  application-
          specific.  Clisp, for instance, attempts completion  of
          symbol  names,  of  function names (if the text is pre-
          fixed by ( or #') or of filenames (if the text is  pre-
          fixed  by  #").  Bash, on the other hand, attempts com-
          pletion treating the text as a variable  (if  the  text
          begins  with  $), username (if the text begins with ~),
          hostname (if  the  text  begins  with  @),  or  command
          (including  aliases and functions) in turn.  If none of
          these  produces  a  match,   filename   completion   is
          attempted.   Gdb, finally, allows completion of program
          functions and variables,  and  only  attempts  filename
          completion under certain circumstances.
     possible-completions (M-?)
          List the possible completions of the text before point.



GNU               Last change: 1998 October 11                 10






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



     insert-completions (M-*)
          Insert all completions of the text  before  point  that
          would have been generated by possible-completions.
     menu-complete
          Similar to complete, but replaces the word to  be  com-
          pleted  with  a  single match from the list of possible
          completions.  Repeated execution of menu-complete steps
          through  the  list  of  possible completions, inserting
          each match in turn.  At the end of the list of  comple-
          tions,  the  bell  is  rung  and  the  original text is
          restored.  An argument of _n moves _n  positions  forward
          in the list of matches; a negative argument may be used
          to move backward through the  list.   This  command  is
          intended to be bound to TAB, but is unbound by default.

  Keyboard Macros
     start-kbd-macro (C-x ()
          Begin saving the characters typed into the current key-
          board macro.
     end-kbd-macro (C-x ))
          Stop saving the characters typed into the current  key-
          board macro and store the definition.
     call-last-kbd-macro (C-x e)
          Re-execute the last keyboard macro defined,  by  making
          the  characters  in the macro appear as if typed at the
          keyboard.

  Miscellaneous
     re-read-init-file (C-x C-r)
          Read in the contents of the _i_n_p_u_t_r_c  file,  and  incor-
          porate  any  bindings  or  variable  assignments  found
          there.
     abort (C-g)
          Abort  the  current  editing  command  and   ring   the
          terminal's bell (subject to the setting of bell-style).
     do-uppercase-version (M-a, M-b, M-_x, ...)
          If the metafied character _x is lowercase, run the  com-
          mand that is bound to the corresponding uppercase char-
          acter.
     prefix-meta (ESC)
          Metafy the next character typed.  ESC f  is  equivalent
          to Meta-f.
     undo (C-_, C-x C-u)
          Incremental undo, separately remembered for each line.
     revert-line (M-r)
          Undo all changes made to this line.  This is like  exe-
          cuting the undo command enough times to return the line
          to its initial state.
     tilde-expand (M-~)
          Perform tilde expansion on the current word.
     set-mark (C-@, M-<space>)
          Set the mark  to  the  current  point.   If  a  numeric



GNU               Last change: 1998 October 11                 11






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



          argument is supplied, the mark is set to that position.
     exchange-point-and-mark (C-x C-x)
          Swap the point with the mark.  The current cursor posi-
          tion  is  set to the saved position, and the old cursor
          position is saved as the mark.
     character-search (C-])
          A character is read and point  is  moved  to  the  next
          occurrence   of   that  character.   A  negative  count
          searches for previous occurrences.
     character-search-backward (M-C-])
          A character is read and point is moved to the  previous
          occurrence   of   that  character.   A  negative  count
          searches for subsequent occurrences.
     insert-comment (M-#)
          The value of the  readline  comment-begin  variable  is
          inserted  at the beginning of the current line, and the
          line is accepted as if a newline had been typed.   This
          makes the current line a shell comment.
     dump-functions
          Print all of the functions and their  key  bindings  to
          the  readline  output stream.  If a numeric argument is
          supplied, the output is formatted in such a way that it
          can be made part of an _i_n_p_u_t_r_c file.
     dump-variables
          Print all of the settable variables and their values to
          the  readline  output stream.  If a numeric argument is
          supplied, the output is formatted in such a way that it
          can be made part of an _i_n_p_u_t_r_c file.
     dump-macros
          Print all of the readline key sequences bound to macros
          and  the  strings they ouput.  If a numeric argument is
          supplied, the output is formatted in such a way that it
          can be made part of an _i_n_p_u_t_r_c file.
     emacs-editing-mode (C-e)
          When in vi editing mode, this causes a switch to  emacs
          editing mode.
     vi-editing-mode (M-C-j)
          When in emacs editing mode, this causes a switch to  vi
          editing mode.

DEFAULT KEY BINDINGS
     The following is a list of the default emacs  and  vi  bind-
     ings.   Characters  with  the  8th  bit  set  are written as
     M-<character>, and are referred to as  _m_e_t_a_f_i_e_d  characters.
     The  printable ASCII characters not mentioned in the list of
     emacs standard bindings are bound to the  _s_e_l_f-_i_n_s_e_r_t  func-
     tion,  which just inserts the given character into the input
     line.  In vi insertion mode, all characters not specifically
     mentioned  are bound to _s_e_l_f-_i_n_s_e_r_t.  Characters assigned to
     signal generation by _s_t_t_y(1) or the terminal driver, such as
     C-Z  or  C-C,  retain  that  function.  Upper and lower case
     _m_e_t_a_f_i_e_d characters are bound to the same  function  in  the



GNU               Last change: 1998 October 11                 12






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



     emacs  mode  meta  keymap.   The  remaining  characters  are
     unbound, which causes readline to ring the bell (subject  to
     the setting of the bell-style variable).

  Emacs Mode
           Emacs Standard bindings

           "C-@"                    set-mark
           "C-A"                    beginning-of-line
           "C-B"                    backward-char
           "C-D"                    delete-char
           "C-E"                    end-of-line
           "C-F"                    forward-char
           "C-G"                    abort
           "C-H"                    backward-delete-char
           "C-I"                    complete
           "C-J"                    accept-line
           "C-K"                    kill-line
           "C-L"                    clear-screen
           "C-M"                    accept-line
           "C-N"                    next-history
           "C-P"                    previous-history
           "C-Q"                    quoted-insert
           "C-R"                    reverse-search-history
           "C-S"                    forward-search-history
           "C-T"                    transpose-chars
           "C-U"                    unix-line-discard
           "C-V"                    quoted-insert
           "C-W"                    unix-word-rubout
           "C-Y"                    yank
           "C-]"                    character-search
           "C-_"                    undo
           " " to "/"               self-insert
           "0"  to "9"              self-insert
           ":"  to "~"              self-insert
           "C-?"                    backward-delete-char

           Emacs Meta bindings

           "M-C-G"                  abort
           "M-C-H"                  backward-kill-word
           "M-C-I"                  tab-insert
           "M-C-J"                  vi-editing-mode
           "M-C-M"                  vi-editing-mode
           "M-C-R"                  revert-line
           "M-C-Y"                  yank-nth-arg
           "M-C-["                  complete
           "M-C-]"                  character-search-backward
           "M-space"                set-mark
           "M-#"                    insert-comment
           "M-&"                    tilde-expand
           "M-*"                    insert-completions



GNU               Last change: 1998 October 11                 13






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



           "M--"                    digit-argument
           "M-."                    yank-last-arg
           "M-0"                    digit-argument
           "M-1"                    digit-argument
           "M-2"                    digit-argument
           "M-3"                    digit-argument
           "M-4"                    digit-argument
           "M-5"                    digit-argument
           "M-6"                    digit-argument
           "M-7"                    digit-argument
           "M-8"                    digit-argument
           "M-9"                    digit-argument
           "M-<"                    beginning-of-history
           "M-="                    possible-completions
           "M->"                    end-of-history
           "M-?"                    possible-completions
           "M-B"                    backward-word
           "M-C"                    capitalize-word
           "M-D"                    kill-word
           "M-F"                    forward-word
           "M-L"                    downcase-word
           "M-N"                    non-incremental-forward-search-history
           "M-P"                    non-incremental-reverse-search-history
           "M-R"                    revert-line
           "M-T"                    transpose-words
           "M-U"                    upcase-word
           "M-Y"                    yank-pop
           "M-\"                    delete-horizontal-space
           "M-~"                    tilde-expand
           "M-C-?"                  backward-delete-word
           "M-_"                    yank-last-arg

           Emacs Control-X bindings

           "C-XC-G"                 abort
           "C-XC-R"                 re-read-init-file
           "C-XC-U"                 undo
           "C-XC-X"                 exchange-point-and-mark
           "C-X("                   start-kbd-macro
           "C-X)"                   end-kbd-macro
           "C-XE"                   call-last-kbd-macro
           "C-XC-?"                 backward-kill-line


  VI Mode bindings
           VI Insert Mode functions

           "C-D"                    vi-eof-maybe
           "C-H"                    backward-delete-char
           "C-I"                    complete
           "C-J"                    accept-line
           "C-M"                    accept-line



GNU               Last change: 1998 October 11                 14






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



           "C-R"                    reverse-search-history
           "C-S"                    forward-search-history
           "C-T"                    transpose-chars
           "C-U"                    unix-line-discard
           "C-V"                    quoted-insert
           "C-W"                    unix-word-rubout
           "C-Y"                    yank
           "C-["                    vi-movement-mode
           "C-_"                    undo
           " " to "~"               self-insert
           "C-?"                    backward-delete-char

           VI Command Mode functions

           "C-D"                    vi-eof-maybe
           "C-E"                    emacs-editing-mode
           "C-G"                    abort
           "C-H"                    backward-char
           "C-J"                    accept-line
           "C-K"                    kill-line
           "C-L"                    clear-screen
           "C-M"                    accept-line
           "C-N"                    next-history
           "C-P"                    previous-history
           "C-Q"                    quoted-insert
           "C-R"                    reverse-search-history
           "C-S"                    forward-search-history
           "C-T"                    transpose-chars
           "C-U"                    unix-line-discard
           "C-V"                    quoted-insert
           "C-W"                    unix-word-rubout
           "C-Y"                    yank
           " "                      forward-char
           "#"                      insert-comment
           "$"                      end-of-line
           "%"                      vi-match
           "&"                      vi-tilde-expand
           "*"                      vi-complete
           "+"                      next-history
           ","                      vi-char-search
           "-"                      previous-history
           "."                      vi-redo
           "/"                      vi-search
           "0"                      beginning-of-line
           "1" to "9"               vi-arg-digit
           ";"                      vi-char-search
           "="                      vi-complete
           "?"                      vi-search
           "A"                      vi-append-eol
           "B"                      vi-prev-word
           "C"                      vi-change-to
           "D"                      vi-delete-to



GNU               Last change: 1998 October 11                 15






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



           "E"                      vi-end-word
           "F"                      vi-char-search
           "G"                      vi-fetch-history
           "I"                      vi-insert-beg
           "N"                      vi-search-again
           "P"                      vi-put
           "R"                      vi-replace
           "S"                      vi-subst
           "T"                      vi-char-search
           "U"                      revert-line
           "W"                      vi-next-word
           "X"                      backward-delete-char
           "Y"                      vi-yank-to
           "\"                      vi-complete
           "^"                      vi-first-print
           "_"                      vi-yank-arg
           "`"                      vi-goto-mark
           "a"                      vi-append-mode
           "b"                      vi-prev-word
           "c"                      vi-change-to
           "d"                      vi-delete-to
           "e"                      vi-end-word
           "f"                      vi-char-search
           "h"                      backward-char
           "i"                      vi-insertion-mode
           "j"                      next-history
           "k"                      prev-history
           "l"                      forward-char
           "m"                      vi-set-mark
           "n"                      vi-search-again
           "p"                      vi-put
           "r"                      vi-change-char
           "s"                      vi-subst
           "t"                      vi-char-search
           "u"                      undo
           "w"                      vi-next-word
           "x"                      vi-delete
           "y"                      vi-yank-to
           "|"                      vi-column
           "~"                      vi-change-case

SEE ALSO
     _T_h_e _G_n_u _R_e_a_d_l_i_n_e _L_i_b_r_a_r_y, Brian Fox
     _T_h_e _G_n_u _H_i_s_t_o_r_y _L_i_b_r_a_r_y, Brian Fox
     _b_a_s_h(1)

FILES
     ~/._i_n_p_u_t_r_c
          Individual readline initialization file

AUTHORS
     Brian Fox, Free Software Foundation (primary author)



GNU               Last change: 1998 October 11                 16






CLISP-READLINE(3)      C LIBRARY FUNCTIONS      CLISP-READLINE(3)



     bfox@ai.MIT.Edu

     Chet Ramey, Case Western Reserve University
     chet@ins.CWRU.Edu

     Bruno Haible
     haible@clisp.cons.org

BUG REPORTS
     If you find a bug in readline, you should  report  it.  Send
     mail to _h_a_i_b_l_e@_c_l_i_s_p._c_o_n_s._o_r_g.

BUGS
     It's too big and too slow.









































GNU               Last change: 1998 October 11                 17



